/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.importODBC;

import datatransfer.DataTransferFrame;
import datatransfer.HelpButton;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.CommonUt.WizardTextArea;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dttwizard.exportText.ExTextDialog;
import dttwizard.exportXML.ExXmlDialog;
import dttwizard.importODBC.LogDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class ViewLogFile
extends AbstractWizardPanel {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dttproperties.Import.dtt_ImportOdbcRes", LocaleManager.getLocale());
    private String title = this.res.getString("Page_title_viewlogfile");
    private LogDialog logdlg = null;
    private JTextPane logContent_TextPane = new JTextPane();
    private String logName = "";

    public ViewLogFile(LogDialog logdlg, String logName) {
        try {
            this.logdlg = logdlg;
            this.logName = logName;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        DbaButton ok_Button = new DbaButton(new Dimension(80, 24), false, this.res.getString("OK"), 'O', DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"), new ReflectionAction(this, "ok_Button_actionPerformed"));
        HelpButton help_Button = new HelpButton();
        JLabel jlabel1 = new JLabel();
        JLabel jlabel2 = new JLabel(this.res.getString("Log_information"));
        WizardTextArea area1 = new WizardTextArea(this.title, "");
        JScrollPane jscroll = new JScrollPane(this.logContent_TextPane);
        this.logContent_TextPane.setCaretPosition(0);
        JPanel panel1 = new JPanel(new BorderLayout());
        JPanel panel2 = new JPanel(new FlowLayout(2));
        if (this.logdlg.parent instanceof ExTextDialog) {
            DataTransferFrame.enableDialogHelp(this, help_Button, "wizard_ExportText_Introduction", null);
        } else if (this.logdlg.parent instanceof ExXmlDialog) {
            DataTransferFrame.enableDialogHelp(this, help_Button, "wizard_ExportXml_Introduction", null);
        } else {
            DataTransferFrame.enableDialogHelp(this, help_Button, "wizard_ImportODBC_ViewLogFile", null);
        }
        jscroll.setPreferredSize(new Dimension(0, 400));
        jscroll.setBorder(BorderFactory.createLineBorder(null));
        this.logContent_TextPane.setEditable(false);
        panel2.add(ok_Button);
        panel2.add(help_Button);
        panel1.add((Component)jscroll, "Center");
        this.setImage(DBAImageResource.getResource(this.getClass(), "/dttimages/ImportODBC.jpg"));
        this.setButtonBar(panel2);
        this.setTextArea(area1);
        this.setContent(panel1, false);
        this.getFileContent(this.logName);
    }

    public void ok_Button_actionPerformed(ActionEvent e) {
        this.logdlg.dispose();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    private void getFileContent(String filename) {
        try {
            this.logContent_TextPane.setText("");
            File file = new File(filename);
            if (!file.exists()) {
                GuiUt.showWarningDlg(this, this.res.getString("Warning"), filename + " " + this.res.getString("Is_not_exist"));
                return;
            }
            int size = (int)file.length();
            int chars_read = 0;
            FileReader in = new FileReader(file);
            char[] data = new char[size];
            while (in.ready()) {
                chars_read += in.read(data, chars_read, size - chars_read);
            }
            in.close();
            this.logContent_TextPane.setText(new String(data, 0, chars_read));
        }
        catch (IOException e) {
            GuiUt.showErrorDlg(this, e.getMessage(), null);
        }
    }
}

