/*
 * Decompiled with CFR 0.152.
 */
package dbaut.textField;

import dbaut.text.TextField;
import dbaut.textField.DbaTextField;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class CharField
extends TextField
implements DbaTextField {
    private static final long serialVersionUID = 7106023813840346855L;
    private Toolkit toolkit;
    private int max_length = 0;
    private boolean length_limited = false;
    private CharField field = this;
    private String origValue = null;

    public CharField() {
        this.toolkit = Toolkit.getDefaultToolkit();
        this.setPreferredSize(new Dimension(-1, 26));
    }

    public CharField(String value) {
        this();
        this.setValue(value);
    }

    public CharField(String value, int max_length) {
        this(value);
        this.max_length = max_length;
        this.length_limited = true;
    }

    public CharField(int max_length) {
        this();
        this.max_length = max_length;
        this.length_limited = true;
    }

    public CharField(int max_length, boolean limited) {
        this();
        this.max_length = max_length;
        this.length_limited = limited;
    }

    @Override
    public Object getValue() {
        return this.getText();
    }

    @Override
    public void setInitValue(String value) {
        this.setValue(value);
        this.origValue = value;
    }

    @Override
    public boolean isEmpty() {
        String txt = this.getText();
        return txt == null || txt.trim().length() == 0;
    }

    @Override
    public boolean isChanged() {
        boolean isChanged = false;
        if (this.origValue != null) {
            isChanged = this.origValue.compareTo((String)this.getValue()) != 0;
        }
        return isChanged;
    }

    public void setValue(String value) {
        this.setText(value);
    }

    @Override
    protected Document createDefaultModel() {
        return new CharDocument();
    }

    protected class CharDocument
    extends PlainDocument {
        private static final long serialVersionUID = -8412705801444920968L;

        protected CharDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (CharField.this.length_limited) {
                byte[] strByteArray;
                String temp = CharField.this.field.getText();
                if (temp == null || str == null) {
                    return;
                }
                byte[] tmpByteArray = temp.getBytes();
                if (tmpByteArray.length + (strByteArray = str.getBytes()).length > CharField.this.max_length) {
                    CharField.this.toolkit.beep();
                    return;
                }
            }
            super.insertString(offs, str, a);
        }
    }
}

