/*
 * Decompiled with CFR 0.152.
 */
package dbaut.locale;

import dbaut.locale.LocaleChangeEvent;
import dbaut.locale.LocaleChangeListener;
import dbaut.resource.DBAResourceBundle;
import java.util.Locale;
import java.util.Vector;
import javax.swing.UIManager;
import startup.ToolInfo;

public class LocaleManager
implements LocaleChangeListener {
    private static LocaleManager localeManager = null;
    private static Locale locale = null;
    private Vector<LocaleChangeListener> listenerList = new Vector();
    public static final short ENGLISH = 0;
    public static final short CHINESE = 1;
    public static final short JAPANESE = 2;
    public static final short CHINA = 3;
    public static boolean isDBMaker = true;
    public static boolean[] language_enable = new boolean[]{true, true, true, true};
    public static short default_System_Language = 0;

    public LocaleManager(short choice) {
        switch (choice) {
            case 1: {
                locale = Locale.TAIWAN;
                break;
            }
            case 2: {
                locale = Locale.JAPAN;
                break;
            }
            case 3: {
                locale = Locale.CHINA;
                break;
            }
            default: {
                locale = Locale.US;
            }
        }
        LocaleManager.setDefaultSystemLanguage(ToolInfo.getDefaultLanguage());
        LocaleManager.setIsDBMaker(ToolInfo.getDBMaker());
        LocaleManager.setLanguageEnableArray(ToolInfo.getLanguageEnable());
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith("Windows");
    }

    public static short getDefaultSystemLanguage() {
        LocaleManager.setDefaultSystemLanguage(ToolInfo.getDefaultLanguage());
        if (LocaleManager.isWindows()) {
            return default_System_Language;
        }
        return 0;
    }

    public static void setDefaultSystemLanguage(short lang) {
        default_System_Language = lang;
    }

    public static boolean getIsDBMaker() {
        LocaleManager.setIsDBMaker(ToolInfo.getDBMaker());
        return isDBMaker;
    }

    public static void setIsDBMaker(boolean b) {
        isDBMaker = b;
    }

    public static void setLanguageEnableArray(boolean[] booleanArray) {
        for (boolean LocaleManager.language_enable[i] : booleanArray) {
        }
    }

    public static short getHelpFileLanguage() {
        LocaleManager.setDefaultSystemLanguage(ToolInfo.getDefaultLanguage());
        return default_System_Language;
    }

    public static Locale getLocale() {
        if (localeManager == null) {
            localeManager = new LocaleManager(LocaleManager.getDefaultSystemLanguage());
        }
        return locale;
    }

    public static LocaleManager getLocaleManager() {
        if (localeManager == null) {
            localeManager = new LocaleManager(LocaleManager.getDefaultSystemLanguage());
        }
        return localeManager;
    }

    public static LocaleManager getLocaleManager(short language_choice) {
        if (localeManager == null) {
            localeManager = new LocaleManager(language_choice);
        }
        return localeManager;
    }

    public synchronized void addLocaleChangeListener(LocaleChangeListener listener) {
        this.listenerList.addElement(listener);
    }

    public synchronized void removeLocaleChangeListener(LocaleChangeListener listener) {
        this.listenerList.removeElement(listener);
    }

    public Vector getLocaleChangedListener() {
        Vector listeners = (Vector)this.listenerList.clone();
        return listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void localeChanged(LocaleChangeEvent e) {
        Vector listeners;
        DBAResourceBundle.clear();
        locale = e.getLocale();
        DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dbautproperties.dbaut.Res", LocaleManager.getLocale());
        UIManager.put("FileChooser.filesOfTypeLabelText", res.getString("File_of_types"));
        UIManager.put("FileChooser.filesOfTypeLabelMnemonic", new Integer(116));
        UIManager.put("FileChooser.fileNameLabelText", res.getString("File_name"));
        UIManager.put("FileChooser.fileNameLabelMnemonic", new Integer(110));
        UIManager.put("FileChooser.lookInLabelText", res.getString("Look_in"));
        UIManager.put("FileChooser.lookInLabelMnemonic", new Integer(105));
        UIManager.put("FileChooser.cancelButtonText", res.getString("Cancel"));
        UIManager.put("FileChooser.cancelButtonMnemonic", new Integer(99));
        UIManager.put("FileChooser.acceptAllFileFilterText", res.getString("All_Files"));
        UIManager.put("FileChooser.saveButtonText", res.getString("saveButtonText"));
        UIManager.put("FileChooser.openButtonText", res.getString("openButtonText"));
        UIManager.put("FileChooser.saveDialogTitleText", res.getString("saveDialogTitleText"));
        UIManager.put("FileChooser.openDialogTitleText", res.getString("openDialogTitleText"));
        UIManager.put("FileChooser.cancelButtonText", res.getString("cancelButtonText"));
        UIManager.put("FileChooser.saveButtonToolTipText", res.getString("saveButtonToolTipText"));
        UIManager.put("FileChooser.openButtonToolTipText", res.getString("openButtonToolTipText"));
        UIManager.put("FileChooser.cancelButtonToolTipText", res.getString("cancelButtonToolTipText"));
        LocaleManager localeManager = this;
        synchronized (localeManager) {
            listeners = (Vector)this.listenerList.clone();
        }
        int size = listeners.size();
        for (int i = 0; i < size; ++i) {
            ((LocaleChangeListener)listeners.elementAt(i)).localeChanged(e);
        }
    }

    public void resetLocale(short choice) {
        locale = choice == 0 ? Locale.US : (choice == 1 ? Locale.TAIWAN : (choice == 3 ? Locale.CHINA : Locale.JAPAN));
    }

    public static String getLanguage() {
        if (LocaleManager.getLocale().equals(Locale.US)) {
            return new String("english");
        }
        if (LocaleManager.getLocale().equals(Locale.TAIWAN)) {
            return new String("chinese");
        }
        if (LocaleManager.getLocale().equals(Locale.JAPAN)) {
            return new String("japanese");
        }
        if (LocaleManager.getLocale().equals(Locale.CHINA)) {
            return new String("china");
        }
        return new String("english");
    }

    public static short getLanguageChoice() {
        if (LocaleManager.getLocale().equals(Locale.TAIWAN)) {
            return 1;
        }
        if (LocaleManager.getLocale().equals(Locale.US)) {
            return 0;
        }
        if (LocaleManager.getLocale().equals(Locale.JAPAN)) {
            return 2;
        }
        if (LocaleManager.getLocale().equals(Locale.CHINA)) {
            return 3;
        }
        return 0;
    }

    public static String getErrlcode() {
        Locale currentLocale = LocaleManager.getLocale();
        if (currentLocale == Locale.TAIWAN) {
            return "zh_TW";
        }
        if (currentLocale == Locale.CHINA) {
            return "zh_CN";
        }
        if (currentLocale == Locale.JAPAN) {
            return "ja";
        }
        return "en";
    }
}

