/*
 * Decompiled with CFR 0.152.
 */
package dbaut.editorPanel;

import dbaut.editorPanel.AutoIndentationEditor;
import dbaut.editorPanel.SQLSPColorEditorKit;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextPane;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.undo.UndoManager;

public class SQLTextPaneIndentation
extends JTextPane {
    private JTextPane textPane;

    public SQLTextPaneIndentation() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setCaretColor(Color.RED);
        this.setFont(new Font("Monospaced", 0, 14));
        this.setEditorKit(new SQLSPColorEditorKit());
        AbstractDocument doc = (AbstractDocument)this.getDocument();
        doc.setDocumentFilter(new AutoIndentationEditor());
        final UndoManager undo = new UndoManager();
        this.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                undo.addEdit(e.getEdit());
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getModifiers() == 2 && (e.getKeyCode() == 90 || e.getKeyCode() == 122)) {
                    if (SQLTextPaneIndentation.this.textPane.getText().length() == 0) {
                        return;
                    }
                    undo.undo();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
    }
}

