/*
 * Decompiled with CFR 0.152.
 */
package dbaut.comp;

import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.concurrent.Semaphore;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ProgressDialog
extends JDialog {
    private static final long serialVersionUID = -9075116372222845715L;
    protected DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dbautproperties.dbaut.Res", LocaleManager.getLocale());
    private JProgressBar pb = new JProgressBar();
    private JLabel updateContent = new JLabel("");
    private DbaButton cancelButton = new DbaButton(new Dimension(80, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "cancelButtonActionPerformed"));
    private Component parent = null;
    private int pbMaxValue = 100;
    private int pbMinValue = 0;
    private boolean stringPainted = true;
    private boolean isCanceling = false;
    private boolean isUserCanceled = false;
    protected WindowAdapter closeListener = null;
    public static final Semaphore sem = new Semaphore();

    public ProgressDialog(JDialog parentDialog, String title) {
        super(parentDialog, title, true);
        this.parent = parentDialog;
        this.init();
        this.pack();
    }

    public ProgressDialog(JFrame parentFrame, String title) {
        super(parentFrame, title, true);
        this.parent = parentFrame;
        this.init();
        this.pack();
    }

    private void init() {
        this.setName("ProgressDialog");
        this.setDefaultCloseOperation(0);
        this.closeListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProgressDialog.this.cancelButtonActionPerformed(null);
            }
        };
        this.addWindowListener(this.closeListener);
        this.setSize(new Dimension(300, 200));
        this.setResizable(false);
        Container contentPanel = this.getContentPane();
        JPanel pbPanel = new JPanel(new FlowLayout(0));
        this.pb.setPreferredSize(new Dimension(200, 24));
        this.pb.setStringPainted(this.stringPainted);
        this.pb.setMinimum(this.pbMinValue);
        this.pb.setMaximum(this.pbMaxValue);
        pbPanel.add(this.pb);
        this.cancelButton.setName("CancelButton");
        pbPanel.add(this.cancelButton);
        contentPanel.add((Component)pbPanel, "South");
        contentPanel.add((Component)this.updateContent, "Center");
        GuiUt.setCenterLocation(this.parent, this);
    }

    public void setProgressBarValue(final int newValue) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.pb.setValue(newValue);
                ProgressDialog.this.pb.repaint();
            }
        });
    }

    public void setProgressBarMaxValue(int pbMaxValue) {
        this.pbMaxValue = pbMaxValue;
    }

    public void setProgressBarMinValue(int pbMinValue) {
        this.pbMinValue = pbMinValue;
    }

    public void setStringPainted(boolean progressBarStringPainted) {
        this.stringPainted = progressBarStringPainted;
    }

    public void cancelButtonActionPerformed(ActionEvent e) {
        this.isCanceling = true;
        int rc = GuiUt.showOptionDlg(this.parent, this.res.getString("Warning"), this.res.getString("Do_You_Want_To_Cancel_Really_QuestionMark"));
        this.isUserCanceled = rc == 0;
        sem.semaphoreNotify();
    }

    public boolean isCanceling() {
        return this.isCanceling;
    }

    public void setIsCanceling(boolean isCanceling) {
        this.isCanceling = isCanceling;
    }

    public boolean isUserCanceled() {
        return this.isUserCanceled;
    }

    public void setUpdateContent(String content) {
        if (content != null) {
            this.updateContent.setText(content);
            this.updateContent.repaint();
        }
    }
}

