/*
 * Decompiled with CFR 0.152.
 */
package dbatool.tableCell;

import dbatool.DbFrame;
import dbatool.Table.DataTableModel;
import dbatool.tableCell.BlobCellObject;
import dbatool.tableCell.BlobEditor;
import dbatool.tableCell.BlobEditorButtonInterface;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.WebBrowser;
import dbaut.comp.DbaFileChooser;
import dbaut.comp.DbaMenu;
import dbaut.comp.DbaMenuItem;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import dbaut.system.BackupFile;
import dbaut.text.TextArea;
import dbaut.util.JdbcUtil;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class BlobEditorNoJAIButton
extends JButton
implements BlobEditorButtonInterface {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.dbatool.ToolRes", LocaleManager.getLocale());
    private BlobCellObject object = null;
    private BlobEditor editor = null;
    private JTable table = null;
    private DataTableModel model = null;
    private static int displayClobMaxSize = 10240;
    private static int bufferSize = 1024;
    private static int displayBlobMaxSize = 0x300000;
    private Object[] tmpfiles = new Object[]{new String[]{"html", "H", "html"}, new String[]{"word document", "H", "DOC"}, new String[]{"pdf document", "P", "PDF"}, new String[]{"rtf document", "R", "RTF"}, new String[]{"wav audio", "U", "WAV"}, new String[]{"avi video", "V", "AVI"}, new String[]{"ppt document", "T", "PPT"}};

    public BlobEditorNoJAIButton() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setTableAndModel(JTable table, DataTableModel model) {
        this.table = table;
        this.model = model;
    }

    @Override
    public void setEditor(BlobEditor editor) {
        this.editor = editor;
    }

    @Override
    public BlobCellObject getValue() {
        return this.object;
    }

    @Override
    public void setValue(BlobCellObject object) {
        this.object = object;
        if (object != null) {
            this.setText(object.toString());
        }
    }

    private void jbInit() throws Exception {
        this.setBorder(null);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BlobEditorNoJAIButton.this.this_mouseClicked(e);
            }
        });
    }

    void this_mouseClicked(MouseEvent e) {
        JMenuItem importblob;
        JPopupMenu menu = new JPopupMenu();
        if (this.object.type.equalsIgnoreCase("FILE")) {
            importblob = new DbaMenu("import", 'i');
            ((JMenu)importblob).add(new DbaMenuItem("store content", 'C', new ReflectionAction(this, "systemfo_actionPerformed")));
            ((JMenu)importblob).add(new DbaMenuItem("store file name", 'F', new ReflectionAction(this, "userfo_actionPerformed")));
            menu.add(importblob);
            importblob.setEnabled(this.model.isEditable);
        } else {
            importblob = new DbaMenuItem("import", 'i', new ReflectionAction(this, "systemfo_actionPerformed"));
            menu.add(importblob);
        }
        DbaMenuItem exportblob = new DbaMenuItem("export", 'e', new ReflectionAction(this, "exportblob_actionPerformed"));
        DbaMenuItem setnull = new DbaMenuItem("set null", 'u', new ReflectionAction(this, "setnull_actionPerformed"));
        menu.add(exportblob);
        menu.add(setnull);
        menu.addSeparator();
        DbaMenu viewer_menu = new DbaMenu("View", 'v');
        DbaMenuItem auto = new DbaMenuItem("auto", 'a', new ReflectionAction(this, "auto_actionPerformed"));
        DbaMenuItem text = new DbaMenuItem("text", 't', new ReflectionAction(this, "text_actionPerformed"));
        viewer_menu.add(auto);
        viewer_menu.addSeparator();
        viewer_menu.add(text);
        Object tmp = null;
        String[] t = null;
        viewer_menu.addSeparator();
        if (DbFrame.isWindows) {
            for (int i = 0; i < this.tmpfiles.length; ++i) {
                t = (String[])this.tmpfiles[i];
                viewer_menu.add(new DbaMenuItem(t[0], t[1].charAt(0), new ReflectionAction(this, "tmpfile_actionPerformed")));
            }
        }
        if (this.object.filename != null && this.object.filename.length() > 0 || this.object.oid != null && this.object.oid.length() > 0 && !this.object.isNull) {
            exportblob.setEnabled(true);
            viewer_menu.setEnabled(true);
            setnull.setEnabled(this.model.isEditable);
        } else {
            exportblob.setEnabled(false);
            viewer_menu.setEnabled(false);
            setnull.setEnabled(false);
        }
        menu.add(viewer_menu);
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    public void systemfo_actionPerformed(ActionEvent e) {
        this.importblob_actionPerformed(true);
    }

    public void userfo_actionPerformed(ActionEvent e) {
        this.importblob_actionPerformed(false);
    }

    public void importblob_actionPerformed(boolean asSystemFileObject) {
        DbaFileChooser chooser = new DbaFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        int state = chooser.showOpenDialog(this);
        if (state == 0) {
            this.object.filename = chooser.getSelectedFile().getPath();
            this.object.asSystemFileObject = asSystemFileObject;
            int row = this.table.getEditingRow();
            int col = this.table.getEditingColumn();
            this.table.editingStopped(null);
            this.table.editCellAt(row, col);
        }
    }

    public void setnull_actionPerformed(ActionEvent e) {
        this.object.isNull = true;
    }

    private void copyfile(String dest) {
        this.copyfile(new File(dest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyfile(File dest) {
        Statement stmt = null;
        ResultSet rs = null;
        FileOutputStream out = null;
        long len = 0L;
        Blob b = null;
        try {
            String query;
            if (!this.object.isView && (rs = (stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement()).executeQuery(query = "SELECT " + GuiUt.getIDString(this.object.column_name) + " FROM \"" + this.object.table_owner + "\".\"" + this.object.table_name + "\" WHERE OID = '" + this.object.oid + "'x")).next()) {
                b = rs.getBlob(1);
            }
            if (this.object.isView) {
                ResultSet vResultSet = this.object.getResultSet();
                int rowNum = this.object.getRowNum();
                int colNum = this.object.getColNum();
                if (vResultSet != null && vResultSet.absolute(rowNum)) {
                    b = vResultSet.getBlob(colNum);
                }
            }
            if (b != null) {
                out = new FileOutputStream(dest);
                len = b.length();
                byte[] buffer = null;
                for (long pos = 1L; pos < len + 1L; pos += (long)bufferSize) {
                    long offset;
                    buffer = len + 1L < (long)bufferSize ? b.getBytes(pos, (int)len) : ((offset = len + 1L - pos) < (long)bufferSize ? b.getBytes(pos, (int)offset) : b.getBytes(pos, bufferSize));
                    ((OutputStream)out).write(buffer);
                }
                out.flush();
                ((OutputStream)out).close();
                JdbcUtil.free(b);
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            GuiUt.showSQLException(this, null, sqle);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            GuiUt.showErrorDlg(DbFrame.frame, ioe.getMessage(), null);
        }
        finally {
            DbaObject.close(out);
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
    }

    public void exportblob_actionPerformed(ActionEvent e) {
        DbaFileChooser chooser = new DbaFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        DBAResourceBundle res1 = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.dbatool.BlobDlgRes", LocaleManager.getLocale());
        int state = chooser.showDialog(this, res1.getString("Save"));
        if (state == 0) {
            if (this.object.filename != null && this.object.filename.length() > 0) {
                if (!BackupFile.copy(this.object.filename, chooser.getSelectedFile().getPath())) {
                    String s = this.res.getString("Cannot_export_object_filename");
                    String[] sa = new String[]{this.object.filename, chooser.getSelectedFile().getPath()};
                    s = GuiUt.mapStringForProperty(s, sa);
                    GuiUt.showErrorDlg(DbFrame.frame, s, null);
                    return;
                }
            } else if (this.object.oid != null && this.object.oid.length() > 0) {
                this.copyfile(chooser.getSelectedFile());
            }
        }
    }

    public void auto_actionPerformed(ActionEvent e) {
        Statement stmt = null;
        ResultSet rs = null;
        String ext = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "SELECT GETEXTNAME(" + this.object.column_name + ") FROM \"" + this.object.table_owner + "\".\"" + this.object.table_name + "\" WHERE OID = '" + this.object.oid + "'x";
            rs = stmt.executeQuery(query);
            if (rs.next()) {
                ext = rs.getString(1).trim();
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(this, null, sqle);
            return;
        }
        String[] s = null;
        for (int i = 0; i < this.tmpfiles.length; ++i) {
            s = (String[])this.tmpfiles[i];
            if (!ext.equalsIgnoreCase(s[2])) continue;
            this.showTempFile(s[2]);
            return;
        }
        GuiUt.showErrorDlg(DbFrame.frame, this.res.getString("Cannot_find_proper_application_to_view_the_data"), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void text_actionPerformed(ActionEvent e) {
        String s1;
        String title = null;
        InputStream in = null;
        Statement stmt = null;
        ResultSet rs = null;
        byte[] ba = null;
        String total = null;
        Reader reader = null;
        long len = -1L;
        try {
            if (this.object.filename != null && this.object.filename.length() > 0) {
                title = this.object.filename;
                in = new FileInputStream(this.object.filename);
                ba = new byte[((InputStream)in).available()];
                ((InputStream)in).read(ba);
            } else if (this.object.oid != null && this.object.oid.length() > 0) {
                String query;
                title = this.object.column_name;
                if (!this.object.isView && (rs = (stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement()).executeQuery(query = "SELECT " + GuiUt.getIDString(this.object.column_name) + " FROM \"" + this.object.table_owner + "\".\"" + this.object.table_name + "\" WHERE OID = '" + this.object.oid + "'x")).next()) {
                    if (this.object.type.equalsIgnoreCase("long varchar") || this.object.type.equalsIgnoreCase("clob") || this.object.type.equalsIgnoreCase("longvarchar")) {
                        in = rs.getAsciiStream(1);
                    } else if (this.object.type.equalsIgnoreCase("nclob")) {
                        Clob c = rs.getClob(1);
                        len = c.length();
                        reader = rs.getCharacterStream(1);
                        JdbcUtil.free(c);
                    } else {
                        in = rs.getBinaryStream(1);
                    }
                }
                if (this.object.isView) {
                    ResultSet vResultSet = this.object.getResultSet();
                    int rowNum = this.object.getRowNum();
                    int colNum = this.object.getColNum();
                    if (vResultSet != null && vResultSet.absolute(rowNum)) {
                        if (this.object.type.equalsIgnoreCase("long varchar") || this.object.type.equalsIgnoreCase("clob") || this.object.type.equalsIgnoreCase("longvarchar")) {
                            Clob c = vResultSet.getClob(colNum);
                            len = c.length();
                            in = vResultSet.getAsciiStream(colNum);
                            JdbcUtil.free(c);
                        } else if (this.object.type.equalsIgnoreCase("nclob")) {
                            Clob c = vResultSet.getClob(colNum);
                            len = c.length();
                            reader = vResultSet.getCharacterStream(colNum);
                            JdbcUtil.free(c);
                        } else {
                            Blob b = vResultSet.getBlob(colNum);
                            len = b.length();
                            in = vResultSet.getBinaryStream(colNum);
                            JdbcUtil.free(b);
                        }
                    }
                }
                if (in != null) {
                    int i = ((InputStream)in).available();
                    if (i > displayClobMaxSize) {
                        s1 = this.res.getString("Blob_lenght_is_too_big");
                        String s2 = GuiUt.mapStringForProperty(s1, Integer.toString(i));
                        GuiUt.showWarningDlg(DbFrame.frame, this.res.getString("Warning"), s2);
                        i = displayClobMaxSize;
                    }
                    ba = new byte[i];
                    ((InputStream)in).read(ba);
                    total = new String(ba).trim();
                }
                if (reader != null) {
                    if (len > (long)displayClobMaxSize) {
                        String s12 = this.res.getString("Blob_lenght_is_too_big");
                        String s2 = GuiUt.mapStringForProperty(s12, Long.toString(len));
                        GuiUt.showWarningDlg(DbFrame.frame, this.res.getString("Warning"), s2);
                        len = displayClobMaxSize;
                    }
                    char[] cbuf = new char[(int)len / 2];
                    reader.read(cbuf);
                    total = new String(cbuf);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            GuiUt.showErrorDlg(DbFrame.frame, ex.getMessage(), null);
        }
        finally {
            DbaObject.close(in);
            DbaObject.close(reader);
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
        JScrollPane panel = new JScrollPane();
        panel.setName("TextContentsPanel");
        if (total.length() == 0 && ba.length > 0) {
            s1 = this.res.getString("Cannot_show_as_text_file_format");
            String s2 = GuiUt.mapStringForProperty(s1, title);
            GuiUt.showErrorDlg(DbFrame.frame, s2, null);
            return;
        }
        TextArea area = new TextArea(total);
        area.setName("TextAreaContents");
        area.setEditable(false);
        panel.getViewport().add(area);
        JDialog dlg = null;
        dlg = this.object.comp != null ? new JDialog((JDialog)this.object.comp, title, false) : new JDialog(DbFrame.frame, title, false);
        dlg.setName("TextContentsDialog");
        dlg.getContentPane().add(panel);
        dlg.setSize(400, 300);
        GuiUt.setCenterLocation(DbFrame.frame, dlg);
        dlg.setVisible(true);
    }

    public void tmpfile_actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        String[] t = null;
        for (int i = 0; i < this.tmpfiles.length; ++i) {
            t = (String[])this.tmpfiles[i];
            if (!s.equals(t[0])) continue;
            this.showTempFile(t[2]);
            return;
        }
    }

    private void showTempFile(String ext) {
        if (this.object.filename != null && this.object.filename.length() > 0) {
            WebBrowser.displayURL(DbFrame.frame, this.object.filename);
            return;
        }
        if (this.object.oid != null && this.object.oid.length() > 0 && !this.object.isNull) {
            try {
                File f = File.createTempFile(this.object.column_name + this.object.oid, "." + ext);
                this.copyfile(f);
                WebBrowser.displayURL(DbFrame.frame, f.getPath());
                return;
            }
            catch (IOException ioe) {
                GuiUt.showErrorDlg(DbFrame.frame, ioe.getMessage(), null);
            }
        }
    }
}

