/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Tablespace;

import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.Tablespace.MoveTableSpaceDialog;
import dbatool.Tablespace.newTransferHandler;
import dbatool.tableModel.DBARowInfo;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbatool.tableModel.DbaTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class TablesPanel
extends DbaPanel {
    private DBAResourceBundle res = DbFrame.frame.getResourceBundle();
    private DbaButton moveButton = new DbaButton(new Dimension(100, 24), this.res.getString("Move"), 'M', DBAImageResource.getResource(this.getClass(), "/jdbaimages/edit.gif"), new ReflectionAction(this, "moveButtonActionPerformed"));
    private DbaTableModel model = null;
    private DBAToolAbstractTableModel absModel = null;
    private JTable table1 = null;
    private String tsName = null;
    private boolean isReadOnlyTs = false;
    private final int OWNER = 0;
    private final int NAME = 1;
    private final int TABLESPACE = 2;
    private final int NUM_OF_ROW = 3;
    private final int NUM_OF_PAGE = 4;
    private final int NUM_OF_INDEX = 5;
    private final int NUM_OF_COLUMN = 6;
    private final int NUM_OF_INDIRECT = 7;
    private final int NUM_OF_BLOB_FRAME = 8;
    private final int CREATE_TIME = 9;
    private final int COLUMN_COUNT = 10;

    public TablesPanel(String tsName, boolean isReadOnlyTs) {
        super(DbFrame.helpres, "tablespace.tables");
        this.tsName = tsName;
        this.isReadOnlyTs = isReadOnlyTs;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setPreferredSize(new Dimension(300, 300));
        String[] columnNames = new String[]{DbFrame.frame.res.getString("Schema_Name_Big"), DbFrame.frame.res.getString("Name"), DbFrame.frame.res.getString("Tablespace"), DbFrame.frame.res.getString("_of_row"), DbFrame.frame.res.getString("_of_page"), DbFrame.frame.res.getString("_of_index"), DbFrame.frame.res.getString("_of_column"), "# of indirect row", "# of blob frame", DbFrame.frame.res.getString("Creation_Time")};
        this.model = new DbaTableModel(columnNames);
        this.absModel = new DBAToolAbstractTableModel(this.model);
        this.table1 = new JTable(this.absModel);
        JPanel contentPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.setBorder(BorderFactory.createLoweredBevelBorder());
        jScrollPane1.getViewport().add((Component)this.table1, null);
        this.table1.setAutoResizeMode(4);
        this.table1.getSelectionModel().addListSelectionListener(new ReflectionListSelection(this, "tableSelectChanged"));
        contentPanel.add(jScrollPane1);
        this.add(contentPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        buttonPanel.add(this.moveButton);
        this.add((Component)buttonPanel, "North");
        this.initColumnSizes(this.table1);
        this.getTableList();
        this.absModel.addMouseListenerToHeaderInTable(this.table1);
        this.moveButton.setEnabled(false);
        if (this.tsName.equals("SYSTABLESPACE") || this.tsName.equals("TMPTABLESPACE")) {
            this.moveButton.setVisible(false);
        }
        this.setName("TablesPane");
        this.moveButton.setName("MoveButton");
        this.table1.setName("TSTablesTable");
        this.table1.setDragEnabled(true);
        this.table1.setTransferHandler(new newTransferHandler());
    }

    public void moveButtonActionPerformed(ActionEvent e) {
        ArrayList<String[]> tables = new ArrayList<String[]>();
        String[] tmp = null;
        int[] rows = this.table1.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            String schema = (String)this.model.getValueAt(rows[i], 0);
            String tbName = (String)this.model.getValueAt(rows[i], 1);
            tmp = new String[]{schema, tbName};
            tables.add(tmp);
        }
        new MoveTableSpaceDialog(DbFrame.frame, this.tsName, tables, null, false);
        this.model.removeAll();
        this.getTableList();
        this.absModel.fireTableChanged(null);
        this.initColumnSizes(this.table1);
        this.absModel.removeMouseListenerToHeaderInTable(this.table1);
        this.absModel.addMouseListenerToHeaderInTable(this.table1);
        int tabIdx = ((DbaTabbedPane)DbFrame.frame.getContentPanel()).getSelectedIndex();
        DbFrame.frame.toolbar.refreshButton_actionPerformed(null);
        ((DbaTabbedPane)DbFrame.frame.getContentPanel()).setSelectedIndex(tabIdx);
    }

    public void tableSelectChanged(ListSelectionEvent e) {
        if (!this.isReadOnlyTs) {
            if (this.table1.getSelectedRowCount() < 1) {
                this.moveButton.setEnabled(false);
                this.moveButton.setToolTipText(null);
            } else {
                this.moveButton.setEnabled(true);
                this.moveButton.setToolTipText(this.res.getString("Move_Tips"));
            }
        }
    }

    private void getTableList() {
        Statement stmt = null;
        ResultSet rs = null;
        String query = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            boolean insystbl = DbFrame.frame.treePanel.getOption("INSYSTBL");
            query = "select TABLE_OWNER, TABLE_NAME, TS_NAME, NUM_ROW, NUM_PAGE, NUM_INDEX, NUM_COL, DWTOSTR(CREATE_TIME), NUM_INDIRECT_ROW, NUM_FRAME ";
            query = insystbl ? query + "from SYSTEM.SYSTABLE " + "where TABLE_TYPE in ('TABLE','SYSTEM TABLE') " + "and TS_NAME='" + this.tsName + "' " + "ORDER BY TABLE_TYPE, TABLE_OWNER, TABLE_NAME" : query + "from SYSTEM.SYSTABLE " + "where TABLE_TYPE = 'TABLE' " + "and TS_NAME='" + this.tsName + "' " + "ORDER BY TABLE_OWNER, TABLE_NAME";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                this.model.addValue(new DBARowInfo(this.getRowInfo(GuiUt.rightTrim(rs.getString(1)), GuiUt.rightTrim(rs.getString(2)), GuiUt.rightTrim(rs.getString(3)), rs.getInt(4), rs.getInt(5), rs.getInt(6), rs.getInt(7), rs.getInt(9), rs.getInt(10), GuiUt.rightTrim(rs.getString(8)))));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
            DbFrame.frame.setStatusDisc(DbFrame.frame.res.getString("Number_of_tables") + " " + this.model.getRowCount());
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
            System.out.println("query=" + query);
            sqle.printStackTrace();
        }
    }

    private void initColumnSizes(JTable table) {
        TableColumn column = null;
        DefaultTableCellRenderer renderer = null;
        int RIGHT = 4;
        int LEFT = 2;
        int[] sizes = new int[]{100, 140, 120, 60, 60, 60, 60, 60, 60, 120};
        int[] alignments = new int[]{LEFT, LEFT, LEFT, RIGHT, RIGHT, RIGHT, RIGHT, RIGHT, RIGHT, LEFT};
        for (int i = 0; i < sizes.length; ++i) {
            column = table.getColumnModel().getColumn(i);
            renderer = new DefaultTableCellRenderer();
            renderer.setToolTipText(table.getColumnName(i));
            renderer.setHorizontalAlignment(alignments[i]);
            column.setCellRenderer(renderer);
            column.setPreferredWidth(sizes[i]);
        }
    }

    private Object[] getRowInfo(String table_owner, String table_name, String ts_name, int num_row, int num_page, int num_index, int num_col, int num_indirect_row, int num_frame, String create_time) {
        Object[] data = new Object[10];
        data[0] = GuiUt.rightTrim(table_owner);
        data[1] = GuiUt.rightTrim(table_name);
        data[2] = ts_name;
        data[3] = num_row == -1 ? new String("N/A") : Integer.toString(num_row);
        data[4] = num_page == -1 ? new String("N/A") : Integer.toString(num_page);
        data[5] = new Integer(num_index);
        data[6] = new Integer(num_col);
        data[9] = create_time;
        data[7] = num_indirect_row == -1 ? new String("N/A") : Integer.toString(num_indirect_row);
        data[8] = num_frame == -1 ? new String("N/A") : Integer.toString(num_frame);
        return data;
    }
}

