/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Table;

import dbatool.DbFrame;
import dbatool.Table.DependencyListNode;
import dbatool.Table.DependencyScrollPane;
import dbatool.Table.TableInfo;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class TableDependencyGraph
extends DbaPanel {
    private DBAResourceBundle res = null;
    private int dependNumber = 0;
    private int beDependedNumber = 0;
    private TableInfo tableinfo = null;
    private String table_owner = null;
    private String table_name = null;
    private JList dependList = new JList();
    private JList beDependedList = new JList();
    private ArrayList<DependencyListNode> beDependedModel = null;
    private ArrayList<DependencyListNode> dependModel = null;
    private ArrayList<Vector> tableColumns = null;
    private Vector<String> pkColumn = new Vector();
    private DependencyScrollPane DependencyPanel = null;
    private JRadioButton background1 = new JRadioButton();
    private JRadioButton background2 = new JRadioButton();
    private JLabel background = new JLabel();

    public TableDependencyGraph(String helpid2, TableInfo tableinfo) {
        super(DbFrame.helpres, helpid2);
        this.tableinfo = tableinfo;
        this.table_owner = tableinfo.table_owner;
        this.table_name = tableinfo.table_name;
        this.res = tableinfo.res;
    }

    public void initPanel() {
        if (this.getComponentCount() > 0) {
            return;
        }
        this.getTableColumnMetaData(this.table_owner, this.table_name);
        this.getPrimaryKeyInfo(this.table_owner, this.table_name);
        JScrollPane scrollPanel = new JScrollPane();
        this.DependencyPanel = new DependencyScrollPane(this.table_owner, this.table_name, this.dependNumber, this.beDependedNumber, this.dependModel, this.beDependedModel, this.res);
        this.DependencyPanel.setLayout(null);
        this.DependencyPanel.setVisible(true);
        scrollPanel.getViewport().add(this.DependencyPanel);
        this.setLayout(new BorderLayout());
        this.background.setHorizontalAlignment(4);
        this.background.setText(this.res.getString("Background"));
        this.background1.setText(this.res.getString("Blank"));
        this.background1.addActionListener(new ReflectionAction(this, "selectBackground1"));
        this.background1.setSelected(true);
        this.background2.setText(this.res.getString("Grid"));
        this.background2.addActionListener(new ReflectionAction(this, "selectBackground2"));
        ButtonGroup background_radiobuttons = new ButtonGroup();
        background_radiobuttons.add(this.background1);
        background_radiobuttons.add(this.background2);
        this.background.setBounds(10, 3, 160, 20);
        this.background1.setBounds(this.background.getX() + this.background.getWidth(), 3, 80, 20);
        this.background2.setBounds(this.background1.getX() + this.background1.getWidth() + 20, 3, 80, 20);
        JPanel optionPanel = new JPanel();
        optionPanel.setLayout(null);
        optionPanel.setPreferredSize(new Dimension(this.getWidth(), 25));
        optionPanel.add(this.background);
        optionPanel.add(this.background1);
        optionPanel.add(this.background2);
        this.add((Component)optionPanel, "North");
        this.add((Component)scrollPanel, "Center");
    }

    private void getPrimaryKeyInfo(String tbowner, String tbname) {
        Connection conn = DbFrame.conn_DatabaseConnection.getDbConnection();
        String pkname = "";
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            ResultSet rs = dbmd.getPrimaryKeys(null, tbowner, tbname);
            while (rs.next()) {
                pkname = rs.getString("PK_NAME");
                if (pkname == null || pkname.equals("")) continue;
                String columnName = GuiUt.rightTrim(rs.getString("COLUMN_NAME"));
                this.pkColumn.addElement(columnName);
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void getTableColumnMetaData(String tbowner, String tbname) {
        Statement stmt = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select COLUMN_ORDER, COLUMN_NAME,TYPE_NAME,SCALE,NULLABLE,PRECISION from SYSTEM.SYSCOLUMN where TABLE_OWNER = '" + GuiUt.singleQuoteHandle(this.table_owner) + "' and TABLE_NAME = '" + GuiUt.singleQuoteHandle(this.table_name) + "' order by COLUMN_ORDER";
            rs = stmt.executeQuery(query);
            rsmd = rs.getMetaData();
            String column_name = null;
            String type_name = null;
            short nullAble = 0;
            String nullAbleToString = "";
            this.tableColumns = new ArrayList();
            while (rs.next()) {
                Vector<String> v = new Vector<String>();
                column_name = GuiUt.rightTrim(rs.getString(2));
                type_name = rs.getString(3).trim();
                nullAble = rs.getShort(5);
                nullAbleToString = nullAble == 0 ? "not null" : "default null";
                v.addElement(column_name);
                v.addElement(type_name);
                v.addElement(nullAbleToString);
                this.tableColumns.add(v);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            e.printStackTrace();
        }
    }

    public void getDependencies(String tbowner, String tbname) {
        Statement stmt = null;
        ResultSet rs = null;
        this.dependNumber = 0;
        this.beDependedNumber = 0;
        try {
            DependencyListNode node;
            this.beDependedModel = new ArrayList();
            this.dependModel = new ArrayList();
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select FK_NAME, FK_TBL_OWNER, FK_TBL_NAME, FK_COL_ORDER, PK_TBL_OWNER, PK_TBL_NAME, PK_COL_ORDER, UPD_ACT, DEL_ACT from SYSTEM.SYSFOREIGNKEY where PK_TBL_OWNER = '" + GuiUt.singleQuoteHandle(tbowner) + "' and PK_TBL_NAME = '" + GuiUt.singleQuoteHandle(tbname) + "' order by FK_TBL_OWNER, FK_TBL_NAME ";
            rs = stmt.executeQuery(query);
            byte[] fk_col_order_bytes = null;
            byte[] pk_col_order_bytes = null;
            String fk_name = "";
            String fk_tbl_owner = "";
            String fk_tbl_name = "";
            String pk_tbl_owner = "";
            String pk_tbl_name = "";
            String upd_act = "";
            String del_act = "";
            while (rs.next()) {
                ++this.beDependedNumber;
                fk_name = rs.getString(1).trim();
                fk_tbl_owner = rs.getString(2).trim();
                fk_tbl_name = rs.getString(3).trim();
                pk_tbl_owner = rs.getString(5).trim();
                pk_tbl_name = rs.getString(6).trim();
                fk_col_order_bytes = rs.getBytes(4);
                pk_col_order_bytes = rs.getBytes(7);
                switch (rs.getInt(8)) {
                    case 0: {
                        upd_act = new String("No Action");
                        break;
                    }
                    case 1: {
                        upd_act = new String("Set Null");
                        break;
                    }
                    case 2: {
                        upd_act = new String("Cascade");
                        break;
                    }
                    case 3: {
                        upd_act = new String("Set Default");
                    }
                }
                switch (rs.getInt(9)) {
                    case 0: {
                        del_act = new String("No Action");
                        break;
                    }
                    case 1: {
                        del_act = new String("Set Null");
                        break;
                    }
                    case 2: {
                        del_act = new String("Cascade");
                        break;
                    }
                    case 3: {
                        del_act = new String("Set Default");
                    }
                }
                node = new DependencyListNode(fk_tbl_owner + "." + fk_tbl_name, fk_name, fk_tbl_owner, fk_tbl_name, fk_col_order_bytes, pk_tbl_owner, pk_tbl_name, pk_col_order_bytes, upd_act, del_act);
                this.beDependedModel.add(node);
            }
            rs.close();
            query = "select FK_NAME, FK_TBL_OWNER, FK_TBL_NAME, FK_COL_ORDER, PK_TBL_OWNER, PK_TBL_NAME, PK_COL_ORDER, UPD_ACT, DEL_ACT from SYSTEM.SYSFOREIGNKEY where FK_TBL_OWNER = '" + GuiUt.singleQuoteHandle(tbowner) + "' and FK_TBL_NAME = '" + GuiUt.singleQuoteHandle(tbname) + "' order by PK_TBL_OWNER, PK_TBL_NAME ";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                ++this.dependNumber;
                fk_name = rs.getString(1).trim();
                fk_tbl_owner = rs.getString(2).trim();
                fk_tbl_name = rs.getString(3).trim();
                pk_tbl_owner = rs.getString(5).trim();
                pk_tbl_name = rs.getString(6).trim();
                fk_col_order_bytes = rs.getBytes(4);
                pk_col_order_bytes = rs.getBytes(7);
                switch (rs.getInt(8)) {
                    case 0: {
                        upd_act = new String("No Action");
                        break;
                    }
                    case 1: {
                        upd_act = new String("Set Null");
                        break;
                    }
                    case 2: {
                        upd_act = new String("Cascade");
                        break;
                    }
                    case 3: {
                        upd_act = new String("Set Default");
                    }
                }
                switch (rs.getInt(9)) {
                    case 0: {
                        del_act = new String("No Action");
                        break;
                    }
                    case 1: {
                        del_act = new String("Set Null");
                        break;
                    }
                    case 2: {
                        del_act = new String("Cascade");
                        break;
                    }
                    case 3: {
                        del_act = new String("Set Default");
                    }
                }
                node = new DependencyListNode(pk_tbl_owner + "." + pk_tbl_name, fk_name, fk_tbl_owner, fk_tbl_name, fk_col_order_bytes, pk_tbl_owner, pk_tbl_name, pk_col_order_bytes, upd_act, del_act);
                this.dependModel.add(node);
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }

    public void selectBackground1(ActionEvent e) {
        this.DependencyPanel.newBackground(2, 0);
    }

    public void selectBackground2(ActionEvent e) {
        this.DependencyPanel.newBackground(2, 2);
    }
}

