/*
 * Decompiled with CFR 0.152.
 */
package dbatool.StoredProcedure;

import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.StoredCommand.CommandPermissionRowInfo;
import dbatool.StoredCommand.CommandPermissionTableModel;
import dbatool.StoredProcedure.ExecuteProcedure;
import dbatool.Table.UserGroupRenderer;
import dbatool.tableCell.BooleanEditor;
import dbatool.tableCell.BooleanRenderer;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.editorPanel.SQLTextPaneIndentation;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;

public class StoredProcedureInfo
extends DbaTabbedPane
implements ComponentPrivilege {
    DBAResourceBundle res2 = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.wizard.ResWizard", LocaleManager.getLocale());
    private String modulename = null;
    private String proc_owner = null;
    private String proc_name = null;
    private DbaButton Modify_Button;
    private DbaButton Confirm_Button;
    private DbaButton Cancel_Button;
    private DbaButton Properties_Modify_Button;
    private DbaButton Properties_Confirm_Button;
    private DbaButton Properties_Cancel_Button;
    private DbaButton Execute_Button;
    private SQLTextPaneIndentation Source;
    private String proc_def;
    private CommandPermissionTableModel model;
    private DBAToolAbstractTableModel absModel;
    private JTable permission_table;
    private boolean isSQLSP;
    private boolean isESQL;

    public StoredProcedureInfo(String modulename, String proc_owner, String proc_name) {
        this.Modify_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Start_Modify"), 'M', DBAImageResource.getResource(this.getClass(), "/jdbaimages/start_modify.gif"), new ReflectionAction(this, "Modify_Button_actionPerformed"));
        this.Confirm_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Confirm"), 'N', DBAImageResource.getResource(this.getClass(), "/jdbaimages/confirm.gif"), new ReflectionAction(this, "Confirm_Button_actionPerformed"));
        this.Cancel_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "Cancel_Button_actionPerformed"));
        this.Properties_Modify_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Start_Modify"), 'M', DBAImageResource.getResource(this.getClass(), "/jdbaimages/start_modify.gif"), new ReflectionAction(this, "Properties_Modify_Button_actionPerformed"));
        this.Properties_Confirm_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Confirm"), 'N', DBAImageResource.getResource(this.getClass(), "/jdbaimages/confirm.gif"), new ReflectionAction(this, "Properties_Confirm_Button_actionPerformed"));
        this.Properties_Cancel_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "Properties_Cancel_Button_actionPerformed"));
        this.Execute_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Execute"), 'E', DBAImageResource.getResource(this.getClass(), "/jdbaimages/execute.gif"), new ReflectionAction(this, "Execute_Button_actionPerformed"));
        this.Source = new SQLTextPaneIndentation();
        this.proc_def = "";
        this.model = null;
        this.absModel = null;
        this.permission_table = null;
        this.isSQLSP = false;
        this.isESQL = false;
        this.modulename = GuiUt.rightTrim(modulename);
        this.proc_owner = GuiUt.rightTrim(proc_owner);
        this.proc_name = GuiUt.rightTrim(proc_name);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("StoredProcedureTabbedPane");
        this.Source.setName("StoredProcedureSourceTextBox");
        DbaPanel jPanel1 = new DbaPanel(DbFrame.helpres, "storedprocedure.info.properties");
        jPanel1.setName("StoredProcedurePropertiesPanel");
        DbaPanel jPanel4 = new DbaPanel(DbFrame.helpres, "storedprocedure.info.permission");
        JScrollPane jScrollPane1 = new JScrollPane();
        JScrollPane jScrollPane2 = new JScrollPane();
        JPanel jToolBar1 = new JPanel(new FlowLayout(0));
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        this.model = new CommandPermissionTableModel(this.proc_owner);
        this.absModel = new DBAToolAbstractTableModel(this.model);
        this.permission_table = new JTable(this.absModel);
        this.permission_table.getTableHeader().setReorderingAllowed(false);
        jPanel1.setLayout(new BorderLayout(5, 5));
        jScrollPane1.setBorder(BorderFactory.createEtchedBorder());
        jPanel4.setLayout(new BorderLayout(5, 5));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.Source.setEditable(false);
        this.add((Component)jPanel1, DbFrame.frame.res.getTitle("Properties"));
        jPanel1.add((Component)jScrollPane1, "Center");
        jPanel1.add((Component)jToolBar1, "North");
        jToolBar1.add((Component)this.Execute_Button, null);
        jToolBar1.add((Component)this.Properties_Modify_Button, null);
        jToolBar1.add((Component)this.Properties_Confirm_Button, null);
        jToolBar1.add((Component)this.Properties_Cancel_Button, null);
        if (this.proc_owner.equalsIgnoreCase("SYSTEM")) {
            this.Properties_Modify_Button.setEnabled(false);
            this.Modify_Button.setEnabled(false);
        }
        this.Properties_Confirm_Button.setEnabled(false);
        this.Properties_Cancel_Button.setEnabled(false);
        this.add((Component)jPanel4, DbFrame.frame.res.getTitle("Permission"));
        jPanel4.add((Component)jPanel5, "North");
        jPanel5.add((Component)this.Modify_Button, null);
        jPanel5.add((Component)this.Confirm_Button, null);
        jPanel5.add((Component)this.Cancel_Button, null);
        jPanel4.add((Component)jScrollPane2, "Center");
        jScrollPane2.getViewport().add((Component)this.permission_table, null);
        jScrollPane1.getViewport().add((Component)this.Source, null);
        this.setUpUserGroupRenderer(this.permission_table, 0);
        this.setUpBooleanRendererEditor(this.permission_table);
        this.getStoredProcedureInfo();
        this.getPermission();
        this.authority = DbaAuthorityFactory.create(this);
        this.authority.authoriseOnce();
        this.setPermissionEditable(false);
    }

    @Override
    public int getComponentType() {
        return 17;
    }

    @Override
    public void grantOnce(boolean enabled) {
    }

    @Override
    public void grant(boolean enabled) {
        if (this.proc_owner.compareTo("SYSTEM") == 0) {
            this.Modify_Button.setEnabled(false);
        } else {
            this.Modify_Button.setEnabled(enabled);
        }
    }

    private void setPermissionEditable(boolean editable) {
        if (editable) {
            this.grant(false);
            this.Confirm_Button.setEnabled(true);
            this.Cancel_Button.setEnabled(true);
        } else {
            this.authority.authorise(this.proc_owner);
            this.Confirm_Button.setEnabled(false);
            this.Cancel_Button.setEnabled(false);
        }
    }

    private void setUpUserGroupRenderer(JTable table, int index) {
        TableColumn column = table.getColumnModel().getColumn(index);
        column.setCellRenderer(new UserGroupRenderer());
    }

    private void setUpBooleanRendererEditor(JTable table) {
        table.setDefaultEditor(Boolean.class, new BooleanEditor(table, table.getModel()));
        table.setDefaultRenderer(Boolean.class, new BooleanRenderer());
    }

    private void getStoredProcedureInfo() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String encode = DbFrame.conn_DatabaseConnection.getDatabaseEncoding();
            String query = "select SOURCE, REMARKS, SQLDEF from SYSTEM.SYSPROCINFO where MODULENAME = '" + this.modulename + "' " + "and PROC_OWNER = '" + this.proc_owner + "'" + "and PROC_NAME = '" + this.proc_name + "'";
            rs = stmt.executeQuery(query);
            String source = "";
            if (rs.next()) {
                String sqldef = rs.getString(3).trim();
                if (rs.getString(2).trim().equalsIgnoreCase("SQL")) {
                    this.isSQLSP = true;
                    source = encode != null ? new String(sqldef.getBytes(), encode) : sqldef;
                } else if (rs.getString(2).trim().equalsIgnoreCase("ESQL")) {
                    this.isESQL = true;
                    InputStream in = rs.getBinaryStream(1);
                    byte[] buffer = new byte[in.available()];
                    in.read(buffer);
                    source = encode != null ? new String(buffer, encode) : new String(buffer);
                    in.close();
                } else {
                    this.Properties_Modify_Button.setEnabled(false);
                }
            }
            rs.close();
            stmt.close();
            this.Source.setText(source.trim());
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
        catch (IOException ioe) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showErrorDlg(DbFrame.frame, ioe.getMessage(), null);
        }
    }

    private void getPermission() {
        this.model.removeAll();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            boolean includePublic = false;
            String query = "select USER_NAME, 'USER', au.GRANTEE, DBA, RESOURCE from SYSAUTHUSER usr outer SYSAUTHEXE au where usr.USER_NAME = au.GRANTEE and OBJNAME = '" + this.proc_name + "' " + "and OWNER = '" + this.proc_owner + "' " + "union all " + "select GROUP_NAME, 'GROUP', au.GRANTEE, 0, 0 " + "from SYSAUTHMEMBER grp outer SYSAUTHEXE au " + "where grp.GROUP_NAME = au.GRANTEE " + "and OBJNAME = '" + this.proc_name + "' " + "and OWNER = '" + this.proc_owner + "' " + "and GROUP_NAME != 'PUBLIC' " + "union all " + "select 'PUBLIC', 'GROUP', GRANTEE, 0, 0 " + "from SYSAUTHEXE au " + "where GRANTEE = 'PUBLIC' " + "and OWNER = '" + this.proc_owner + "' " + "and OBJNAME = '" + this.proc_name + "' ";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                String user = GuiUt.rightTrim(rs.getString(1));
                String grantee = rs.getString(3);
                boolean execute = false;
                execute = !rs.wasNull();
                String authority_type = GuiUt.rightTrim(rs.getString(2));
                short dba = rs.getShort(4);
                short resource = rs.getShort(5);
                if (user.equals("PUBLIC")) {
                    includePublic = true;
                }
                CommandPermissionRowInfo one_row = new CommandPermissionRowInfo(user, authority_type, dba >= 1 || resource == 1 && user.equals(this.proc_owner) || execute, dba >= 1, resource == 1);
                this.model.addValue(one_row);
            }
            rs.close();
            stmt.close();
            if (!includePublic) {
                CommandPermissionRowInfo one_row = new CommandPermissionRowInfo("PUBLIC", "GROUP", false, false, false);
                this.model.addValue(one_row);
            }
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }

    public void Modify_Button_actionPerformed(ActionEvent e) {
        this.fixTabbedPanelAt(this.getSelectedIndex());
        this.setPermissionEditable(true);
        this.model.setEditable(true);
        this.revalidate();
        this.repaint();
    }

    public void Confirm_Button_actionPerformed(ActionEvent e) {
        boolean result;
        Vector v = this.model.getUpdatingProcPermission(this.modulename, this.proc_owner, this.proc_name);
        StringBuffer query_sb = new StringBuffer();
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            query_sb.append((String)v.elementAt(i)).append(";\n");
        }
        if (query_sb.length() > 0 && !(result = DatabaseConnection.executeMultiSQL(query_sb.toString()))) {
            return;
        }
        this.Cancel_Button_actionPerformed(null);
    }

    public void Cancel_Button_actionPerformed(ActionEvent e) {
        this.setPermissionEditable(false);
        this.model.setEditable(false);
        this.getPermission();
        this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
        this.releaseTabbedPanel();
    }

    public void Execute_Button_actionPerformed(ActionEvent e) {
        ExecuteProcedure es = new ExecuteProcedure(this.modulename, this.proc_owner, this.proc_name);
        es.executeProcedure();
    }

    public void Properties_Cancel_Button_actionPerformed(ActionEvent e) {
        this.getStoredProcedureInfo();
        this.revalidate();
        this.repaint();
        this.releaseTabbedPanel();
        this.Source.setText(this.proc_def);
        this.Source.setEditable(false);
        this.Properties_Modify_Button.setEnabled(true);
        this.Execute_Button.setEnabled(true);
        this.Properties_Confirm_Button.setEnabled(false);
        this.Properties_Cancel_Button.setEnabled(false);
    }

    public void Properties_Modify_Button_actionPerformed(ActionEvent e) {
        this.fixTabbedPanelAt(this.getSelectedIndex());
        this.Execute_Button.setEnabled(false);
        this.Properties_Confirm_Button.setEnabled(true);
        this.Properties_Cancel_Button.setEnabled(true);
        this.Properties_Modify_Button.setEnabled(false);
        if (this.isESQL) {
            this.modifyESQL();
        }
        if (this.isSQLSP) {
            this.modifySQLSP();
        }
    }

    public void Properties_Confirm_Button_actionPerformed(ActionEvent e) {
        File tmpFile = null;
        String fileAbsolutePath = "";
        String str1 = "";
        if (this.isSQLSP) {
            try {
                tmpFile = File.createTempFile("proctmp", ".sp");
                fileAbsolutePath = tmpFile.getAbsolutePath();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        if (this.isESQL) {
            try {
                tmpFile = File.createTempFile("proctmp", ".ec");
                fileAbsolutePath = tmpFile.getAbsolutePath();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        try {
            DataOutputStream outFile = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(tmpFile)));
            str1 = this.Source.getText().trim();
            outFile.write(str1.getBytes());
            outFile.close();
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        Statement stmt = null;
        JDialog dialog = new JDialog();
        GuiUt.setCenterLocation(DbFrame.frame, dialog);
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            stmt.execute("create procedure from '" + fileAbsolutePath + "'");
            this.Source.setText(str1);
            stmt.close();
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(dialog, null, sqle);
            DbaObject.close(stmt);
            this.Source.setText(this.proc_def);
        }
        dialog.setVisible(false);
        dialog.dispose();
        this.getStoredProcedureInfo();
        this.Source.setEditable(false);
        this.revalidate();
        this.repaint();
        this.releaseTabbedPanel();
        this.Properties_Modify_Button.setEnabled(true);
        this.Execute_Button.setEnabled(true);
        this.Properties_Confirm_Button.setEnabled(false);
        this.Properties_Cancel_Button.setEnabled(false);
    }

    private void modifySQLSP() {
        String sql_text;
        this.Source.setEditable(true);
        this.proc_def = sql_text = this.Source.getText();
        String new_str = "";
        Pattern p = Pattern.compile("create\\s+procedure\\s", 2);
        Matcher match = p.matcher(sql_text);
        if (match.find()) {
            String out;
            new_str = out = match.replaceAll("CREATE OR REPLACE PROCEDURE ");
        } else {
            p = Pattern.compile("create\\s+or\\s+replace\\s+procedure\\s", 2);
            match = p.matcher(sql_text);
            if (match.find()) {
                String out;
                new_str = out = match.replaceAll("CREATE OR REPLACE PROCEDURE ");
            }
        }
        this.Source.setText(new_str);
    }

    private void modifyESQL() {
        String sql_text;
        this.Source.setEditable(true);
        this.proc_def = sql_text = this.Source.getText();
        String new_str = "";
        Pattern p = Pattern.compile("exec\\s+sql\\s+create\\s+procedure", 2);
        Matcher match = p.matcher(sql_text);
        if (match.find()) {
            String out;
            new_str = out = match.replaceAll("EXEC SQL CREATE OR REPLACE PROCEDURE ");
        } else {
            p = Pattern.compile("exec\\s+sql\\s+create\\s+or\\s+replace\\s+procedure", 2);
            match = p.matcher(sql_text);
            if (match.find()) {
                String out;
                new_str = out = match.replaceAll("EXEC SQL CREATE OR REPLACE PROCEDURE ");
            }
        }
        this.Source.setText(new_str);
    }
}

