/*
 * Decompiled with CFR 0.152.
 */
package dbatool.StoredCommand;

import dbatool.DbFrame;
import dbatool.StoredCommand.CommandPermissionRowInfo;
import dbatool.tableModel.ColumnSorting;
import dbaut.GuiUt;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class CommandPermissionTableModel
extends AbstractTableModel
implements ColumnSorting {
    private int TYPE = 0;
    private int NAME = 1;
    private int EXECUTE = 2;
    private int DBA = 3;
    private int RESOURCE = 4;
    private String[] columnNames;
    private Vector data;
    private boolean isEditable;
    private boolean isCommand;
    private String owner;

    public CommandPermissionTableModel(String owner) {
        this.columnNames = new String[]{DbFrame.frame.res.getString("Type"), DbFrame.frame.res.getString("User_Group"), DbFrame.frame.res.getString("Execute")};
        this.data = new Vector();
        this.isEditable = false;
        this.isCommand = true;
        this.owner = null;
        this.owner = owner;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        CommandPermissionRowInfo rowData = (CommandPermissionRowInfo)this.data.elementAt(row);
        return rowData.getValueAt(col);
    }

    public Class getColumnClass(int c) {
        CommandPermissionRowInfo rowData = (CommandPermissionRowInfo)this.data.elementAt(0);
        return rowData.getValueAt(c).getClass();
    }

    public void addValue(CommandPermissionRowInfo newData) {
        this.data.addElement(newData);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        CommandPermissionRowInfo rowData = (CommandPermissionRowInfo)this.data.elementAt(row);
        rowData.setValueAt(value, col);
    }

    public void setEditable(boolean b) {
        this.isEditable = b;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (!this.isEditable || col == 0 || col == 1) {
            return false;
        }
        Boolean dba = (Boolean)this.getValueAt(row, 3);
        Boolean resource = (Boolean)this.getValueAt(row, 4);
        String user = (String)this.getValueAt(row, 0);
        if (dba.booleanValue()) {
            return false;
        }
        return resource == false || !user.equals(this.owner);
    }

    public void removeAll() {
        this.data.removeAllElements();
    }

    public Vector getUpdatingProcPermission(String modulename, String owner, String name) {
        this.isCommand = false;
        return this.getUpdatingPermission(modulename, owner, name);
    }

    public Vector getUpdatingPermission(String modulename, String owner, String name) {
        StringBuffer revoke_sb = new StringBuffer();
        StringBuffer grant_sb = new StringBuffer();
        int count = this.data.size();
        for (int i = 0; i < count; ++i) {
            String user;
            CommandPermissionRowInfo cur_row = (CommandPermissionRowInfo)this.data.elementAt(i);
            Boolean cur_value = (Boolean)cur_row.getValueAt(this.EXECUTE);
            if (cur_value.booleanValue() && !cur_row.orig_data) {
                user = (String)cur_row.getValueAt(this.NAME);
                if (grant_sb.length() == 0) {
                    if (this.isCommand) {
                        grant_sb.append("GRANT EXECUTE ON COMMAND ");
                    } else {
                        grant_sb.append("GRANT EXECUTE ON PROCEDURE ").append(GuiUt.getIDString(modulename)).append(".");
                    }
                    grant_sb.append(GuiUt.getIDString(owner)).append(".").append(GuiUt.getIDString(name)).append(" TO ").append(GuiUt.getIDString(user));
                } else {
                    grant_sb.append(", ").append(GuiUt.getIDString(user));
                }
            }
            if (cur_value.booleanValue() || !cur_row.orig_data) continue;
            user = (String)cur_row.getValueAt(this.NAME);
            if (revoke_sb.length() == 0) {
                if (this.isCommand) {
                    revoke_sb.append("REVOKE EXECUTE ON COMMAND ");
                } else {
                    revoke_sb.append("REVOKE EXECUTE ON PROCEDURE ").append(GuiUt.getIDString(modulename)).append(".");
                }
                revoke_sb.append(GuiUt.getIDString(owner)).append(".").append(GuiUt.getIDString(name)).append(" FROM ").append(GuiUt.getIDString(user));
                continue;
            }
            revoke_sb.append(", ").append(GuiUt.getIDString(user));
        }
        Vector<String> v = new Vector<String>();
        if (revoke_sb.length() > 0) {
            v.addElement(revoke_sb.toString());
        }
        if (grant_sb.length() > 0) {
            v.addElement(grant_sb.toString());
        }
        return v;
    }

    @Override
    public void switchOrder(int godown, int goup) {
        Object downRow = this.data.elementAt(godown);
        Object upRow = this.data.elementAt(goup);
        this.data.setElementAt(downRow, goup);
        this.data.setElementAt(upRow, godown);
    }
}

