/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Monitor;

import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.Monitor.UpdateStatisticsTableModel;
import dbatool.StatisticsParser;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.alarm.Alarm2;
import dbaut.alarm.Sleeper;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class UpdateStatisticsInfo
extends DbaTabbedPane
implements Sleeper {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.dbatool.MonitorRes", LocaleManager.getLocale());
    private UpdateStatisticsTableModel model1 = new UpdateStatisticsTableModel();
    private DBAToolAbstractTableModel absModel = new DBAToolAbstractTableModel(this.model1);
    private JTable table1 = new JTable(this.absModel);
    private Alarm2 clock = null;
    private boolean isRefreshing = false;
    private JPanel buttonBar = null;
    private DbaButton Refresh_Button = new DbaButton(new Dimension(120, 24), this.res.getString("Refresh"), 'R', DBAImageResource.getResource(this.getClass(), "/jdbaimages/refresh.gif"), new ReflectionAction(this, "refreshButtonActionPerformed"));
    private DbaButton abortButton = new DbaButton(new Dimension(120, 24), this.res.getString("Abort"), 'K', DBAImageResource.getResource(this.getClass(), "/jdbaimages/kill_connection.gif"), new ReflectionAction(this, "abortButtonActionPerformed"));
    private JCheckBox Auto_Refresh_Checkbox = new JCheckBox(this.res.getString("Auto_Refresh"));

    public UpdateStatisticsInfo() {
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.table1.setAutoResizeMode(4);
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.getViewport().add((Component)this.table1, null);
        DbaPanel updStatPanel = new DbaPanel(DbFrame.helpres, "updatestatistics.info");
        updStatPanel.setName("UpdateStatisticsPanel");
        updStatPanel.setLayout(new BorderLayout());
        updStatPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        updStatPanel.add((Component)jScrollPane1, "Center");
        this.buttonBar = new JPanel(new FlowLayout(0));
        this.buttonBar.setName("SessionInfoToolBar");
        this.buttonBar.add((Component)this.Refresh_Button, null);
        this.buttonBar.add((Component)this.abortButton, null);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setMaximumSize(new Dimension(559, 27));
        buttonPanel.add(this.buttonBar);
        buttonPanel.add((Component)this.Auto_Refresh_Checkbox, "East");
        updStatPanel.add((Component)buttonPanel, "North");
        this.abortButton.setEnabled(false);
        this.Auto_Refresh_Checkbox.addActionListener(new ReflectionAction(this, "Auto_Refresh_Checkbox_actionPerformed"));
        if (DbFrame.frame.px.getAutoRefresh()) {
            this.Auto_Refresh_Checkbox.setSelected(true);
        } else {
            this.Auto_Refresh_Checkbox.setSelected(false);
        }
        this.add((Component)updStatPanel, this.res.getTitle("Session_Information"));
        this.initColumnSizes(this.table1, this.model1);
        this.table1.setSelectionMode(0);
        ListSelectionModel lsm = this.table1.getSelectionModel();
        lsm.addListSelectionListener(new ReflectionListSelection(this, "table1_valueChanged"));
        boolean result = this.getUpdateStatisticsInfo();
        this.absModel.addMouseListenerToHeaderInTable(this.table1);
        if (result) {
            this.clock = new Alarm2();
            this.clock.setAlarm(this, DbFrame.frame.px.getAutoRefreshTime());
        }
        this.setNames();
    }

    private void setNames() {
        this.setName("UpdateStatisticsInfoTabbedPane");
        this.Refresh_Button.setName("RefreshButton");
        this.abortButton.setName("AbortButton");
        this.Auto_Refresh_Checkbox.setName("AutoRefreshButton");
        this.buttonBar.setName("UpdateStatisticsButtonBar");
        this.table1.setName("UpdateStatisticsTable");
    }

    public void table1_valueChanged(ListSelectionEvent e) {
        if (this.table1.getSelectionModel().isSelectionEmpty()) {
            this.abortButton.setEnabled(false);
        } else {
            this.abortButton.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean getUpdateStatisticsInfo() {
        Statement stmt = null;
        Statement stmt1 = null;
        ResultSet rs = null;
        ResultSet rs1 = null;
        String self_id = null;
        Connection con = DbFrame.conn_DatabaseConnection.getDbConnection();
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("select CONNECTION_ID from SYSCONINFO");
            if (rs.next()) {
                self_id = rs.getString(1);
            }
            this.model1.removeAll();
            stmt1 = con.createStatement();
            String query = "select CONNECTION_ID, SQL_CMD from SYSTEM.SYSUSER where SQL_CMD like '%UPDATE STATISTICS%' and CONNECTION_ID!=" + self_id;
            rs1 = stmt1.executeQuery(query);
            while (rs1.next()) {
                String connection_id = rs1.getString(1);
                String sql_cmd = rs1.getString(2);
                StatisticsParser parser = StatisticsParser.getParser();
                parser.parse(sql_cmd);
                ArrayList<String> total = parser.getTotalList();
                ArrayList<String> table = parser.getTableList();
                ArrayList<String> index = parser.getIndexList();
                Object[] data = new Object[]{connection_id, total.get(4), total.get(3), total.get(2), total.get(1), total.get(0), table.get(4), table.get(3), table.get(2), table.get(1), table.get(0), index.get(4), index.get(3), index.get(2), index.get(1), index.get(0)};
                this.model1.addValue(data);
            }
            this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
            this.table1_valueChanged(null);
        }
        catch (SQLException sqle) {
            boolean bl;
            try {
                GuiUt.showSQLException(DbFrame.frame, null, sqle);
                bl = false;
            }
            catch (Throwable throwable) {
                DbaObject.close(rs);
                DbaObject.close(stmt);
                DbaObject.close(rs1);
                DbaObject.close(stmt1);
                throw throwable;
            }
            DbaObject.close(rs);
            DbaObject.close(stmt);
            DbaObject.close(rs1);
            DbaObject.close(stmt1);
            return bl;
        }
        DbaObject.close(rs);
        DbaObject.close(stmt);
        DbaObject.close(rs1);
        DbaObject.close(stmt1);
        return true;
    }

    private void initColumnSizes(JTable table, TableModel model) {
        TableColumn column = null;
        int[] sizes = new int[]{80, 50, 120, 80, 80, 50, 120, 120, 80, 80, 50, 60, 120, 80, 80, 50};
        for (int i = 0; i < sizes.length; ++i) {
            column = table.getColumnModel().getColumn(i);
            column.setPreferredWidth(sizes[i]);
        }
    }

    @Override
    public synchronized void wakeUp() {
        if (this.isRefreshing) {
            System.out.println("It's refreshing already.");
            this.clock.setAlarm(this, DbFrame.frame.px.getAutoRefreshTime());
            return;
        }
        if (this.isShowing() && DbFrame.frame.px.getAutoRefresh()) {
            this.isRefreshing = true;
            boolean result = this.getUpdateStatisticsInfo();
            this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
            this.isRefreshing = false;
            if (result) {
                this.clock.setAlarm(this, DbFrame.frame.px.getAutoRefreshTime());
            }
            this.table1_valueChanged(null);
        }
    }

    public void refreshButtonActionPerformed(ActionEvent e) {
        if (this.isRefreshing) {
            System.out.println("It's refreshing already.");
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.isRefreshing = true;
        this.getUpdateStatisticsInfo();
        this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
        this.isRefreshing = false;
        this.table1_valueChanged(null);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void abortButtonActionPerformed(ActionEvent e) {
        int option = GuiUt.showOptionDlg(DbFrame.frame, this.res.getString("Warning"), this.res.getString("Do_you_want_to_abort_really"));
        if (option != 0) {
            return;
        }
        CallableStatement stmt = null;
        try {
            int row = this.table1.getSelectedRow();
            this.abortButton.setEnabled(false);
            String connection_id = (String)this.model1.getValueAt(row, 0);
            String abortSQL = "call SETSYSTEMOPTION('STS_ABORT', '" + connection_id + "')";
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().prepareCall(abortSQL);
            stmt.execute();
            stmt.close();
            this.table1.clearSelection();
            this.model1.removeAll();
            this.isRefreshing = true;
            this.getUpdateStatisticsInfo();
            this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
            this.isRefreshing = false;
            this.table1_valueChanged(null);
        }
        catch (SQLException sqle) {
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }

    public void Auto_Refresh_Checkbox_actionPerformed(ActionEvent e) {
        if (this.Auto_Refresh_Checkbox.isSelected()) {
            DbFrame.frame.px.updateVariables(3, "true");
            this.clock.setAlarm(this, DbFrame.frame.px.getAutoRefreshTime());
        } else {
            DbFrame.frame.px.updateVariables(3, "false");
        }
    }
}

