/*
 * Decompiled with CFR 0.152.
 */
package dbatool;

import com.syscom.dm.dba.sca.DbaAuthority;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.DbaTree;
import dbatool.Tablespace.MoveTableSpaceDialog;
import dbatool.TreeNode.CommandTreeNode;
import dbatool.TreeNode.DBATreeCellRenderer;
import dbatool.TreeNode.DBATreeNode;
import dbatool.TreeNode.DatabaseTreeNode;
import dbatool.TreeNode.DummyTreeNode;
import dbatool.TreeNode.GroupTreeNode;
import dbatool.TreeNode.ProcedureTreeNode;
import dbatool.TreeNode.ReplicationTreeNode;
import dbatool.TreeNode.RootTreeNode;
import dbatool.TreeNode.ScheduleTreeNode;
import dbatool.TreeNode.TableListTreeNode;
import dbatool.TreeNode.TableSpaceTreeNode;
import dbatool.TreeNode.TableSubTreeNode;
import dbatool.TreeNode.TableTreeNode;
import dbatool.TreeNode.TriggerTreeNode;
import dbatool.TreeNode.UserTreeNode;
import dbatool.TreeNode.ViewTreeNode;
import dbatool.View.ViewDataPanel;
import dbatool.View.ViewInfo;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.locale.LocaleChangeListener;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.metal.MetalTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class DbaTreePane
extends JScrollPane {
    public DbaTree tree = null;
    private DbaAuthority authority = null;
    private boolean isTablespaceLoaded = false;
    private boolean isTableLoaded = false;
    private boolean isViewLoaded = false;
    private boolean isTriggerLoaded = false;
    private boolean isProcedureLoaded = false;
    private boolean isCommandLoaded = false;
    private boolean isReplicationLoaded = false;
    private boolean isScheduleLoaded = false;
    private boolean isUserLoaded = false;
    private boolean isGroupLoaded = false;
    private DefaultTreeModel treeModel = null;
    private TreeSelectionListener tslistener = null;
    private TreeWillExpandListener twelistener = null;
    private MouseAdapter treeMouseAdapter = null;
    private DBATreeNode databaseNode = null;
    private DBATreeNode tableSpaceNode = null;
    private TableListTreeNode tableNode = null;
    private DBATreeNode viewNode = null;
    private DBATreeNode domainNode = null;
    private DBATreeNode userNode = null;
    private DBATreeNode groupNode = null;
    private DBATreeNode synonymNode = null;
    private DBATreeNode commandNode = null;
    private DBATreeNode procNode = null;
    private DBATreeNode dbmonitorNode = null;
    private DBATreeNode dblinkNode = null;
    private DBATreeNode scheduleNode = null;
    private DBATreeNode replicationNode = null;
    private DBATreeNode indexNode = null;
    private DBATreeNode tindexNode = null;
    private DBATreeNode foreignkeyNode = null;
    private DBATreeNode triggerNode = null;
    private DBATreeNode ivftindexNode = null;
    private DBATreeNode schemaNode = null;
    private DBATreeNode aclNode = null;
    private boolean moveTableFlag;

    public void setMoveTableFlag(boolean flag) {
        this.moveTableFlag = flag;
    }

    public void initDatabaseTree() {
        this.authority = DbaAuthorityFactory.create(null);
        DatabaseConnection conn_DatabaseConnection = DbFrame.conn_DatabaseConnection;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.isTableLoaded = false;
        this.isTablespaceLoaded = false;
        this.isViewLoaded = false;
        this.databaseNode = new RootTreeNode(conn_DatabaseConnection.dbname);
        this.tableSpaceNode = new DatabaseTreeNode(0);
        this.tableNode = new TableListTreeNode(1);
        this.viewNode = new DatabaseTreeNode(2);
        this.indexNode = new DatabaseTreeNode(12);
        this.tindexNode = new DatabaseTreeNode(13);
        this.foreignkeyNode = new DatabaseTreeNode(14);
        this.triggerNode = new DatabaseTreeNode(15);
        this.domainNode = new DatabaseTreeNode(11);
        this.userNode = new DatabaseTreeNode(8);
        this.groupNode = new DatabaseTreeNode(9);
        this.synonymNode = new DatabaseTreeNode(10);
        this.commandNode = new DatabaseTreeNode(16);
        this.procNode = new DatabaseTreeNode(17);
        this.dbmonitorNode = new DatabaseTreeNode(7);
        this.dblinkNode = new DatabaseTreeNode(18);
        this.scheduleNode = new DatabaseTreeNode(19);
        this.replicationNode = new DatabaseTreeNode(20);
        this.ivftindexNode = new DatabaseTreeNode(21);
        this.schemaNode = new DatabaseTreeNode(22);
        this.aclNode = new DatabaseTreeNode(23);
        if (this.authority.isAboveDba() || this.authority.isResource()) {
            this.databaseNode.add(this.tableSpaceNode);
        }
        this.databaseNode.add(this.tableNode);
        this.databaseNode.add(this.viewNode);
        this.databaseNode.add(this.indexNode);
        this.databaseNode.add(this.tindexNode);
        this.databaseNode.add(this.ivftindexNode);
        this.databaseNode.add(this.foreignkeyNode);
        this.databaseNode.add(this.triggerNode);
        this.databaseNode.add(this.commandNode);
        this.databaseNode.add(this.procNode);
        this.databaseNode.add(this.dblinkNode);
        if (this.authority.isAboveDba()) {
            this.databaseNode.add(this.scheduleNode);
        }
        this.databaseNode.add(this.replicationNode);
        this.databaseNode.add(this.domainNode);
        this.databaseNode.add(this.synonymNode);
        this.databaseNode.add(this.userNode);
        if (this.authority.isAboveDba()) {
            this.databaseNode.add(this.groupNode);
        }
        this.databaseNode.add(this.schemaNode);
        this.databaseNode.add(this.aclNode);
        if (this.authority.isAboveDba()) {
            this.databaseNode.add(this.dbmonitorNode);
        }
        this.tableSpaceNode.add(new DummyTreeNode());
        this.tableNode.add(new DummyTreeNode());
        this.viewNode.add(new DummyTreeNode());
        this.triggerNode.add(new DummyTreeNode());
        this.procNode.add(new DummyTreeNode());
        this.commandNode.add(new DummyTreeNode());
        this.replicationNode.add(new DummyTreeNode());
        this.scheduleNode.add(new DummyTreeNode());
        this.userNode.add(new DummyTreeNode());
        this.groupNode.add(new DummyTreeNode());
        this.dbmonitorNode.add(new DatabaseTreeNode(5));
        this.dbmonitorNode.add(new DatabaseTreeNode(3));
        this.dbmonitorNode.add(new DatabaseTreeNode(4));
        this.dbmonitorNode.add(new DatabaseTreeNode(6));
        this.dbmonitorNode.add(new DatabaseTreeNode(24));
        this.dbmonitorNode.add(new DatabaseTreeNode(25));
        this.dbmonitorNode.add(new DatabaseTreeNode(26));
        this.treeModel = new DefaultTreeModel(this.databaseNode);
        this.tree = new DbaTree(this.treeModel);
        this.tree.setName("DBATree");
        TreeUI treeUI = this.tree.getUI();
        if (treeUI instanceof MetalTreeUI) {
            MetalTreeUI mTreeUI = (MetalTreeUI)treeUI;
            ImageIcon icon = DBAImageResource.getResource(this.getClass(), "/jdbaimages/minus.gif");
            mTreeUI.setExpandedIcon(icon);
            icon = DBAImageResource.getResource(this.getClass(), "/jdbaimages/plus.gif");
            mTreeUI.setCollapsedIcon(icon);
        }
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.setShowsRootHandles(true);
        TreeExpansionListener telistener = new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent e) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent e) {
                TreePath p = e.getPath();
                if (DbaTreePane.this.tree.getModel().isLeaf(p.getLastPathComponent())) {
                    DbaTreePane.this.tree.collapsePath(p);
                }
            }
        };
        this.twelistener = new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent e) {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
                DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
                DbaTreePane.this.tree_treeWillExpand(e);
                DbFrame.frame.setCursor(Cursor.getDefaultCursor());
            }
        };
        this.tslistener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
                if (!DbaTreePane.this.moveTableFlag) {
                    DbaTreePane.this.tree_valueChanged(e);
                }
                DbFrame.frame.setCursor(Cursor.getDefaultCursor());
            }
        };
        this.treeMouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
                DbaTreePane.this.tree_mousePressed(e);
                DbFrame.frame.setCursor(Cursor.getDefaultCursor());
            }
        };
        this.tree.addTreeExpansionListener(telistener);
        this.tree.addTreeWillExpandListener(this.twelistener);
        this.tree.addMouseListener(this.treeMouseAdapter);
        this.tree.addTreeSelectionListener(this.tslistener);
        this.tree.setCellRenderer(new DBATreeCellRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setTransferHandler(new Transfer());
        try {
            this.tree.getDropTarget().addDropTargetListener(new DropTargetAdapter(){

                @Override
                public void dragExit(DropTargetEvent dte) {
                    DbFrame.frame.treePanel.setMoveTableFlag(false);
                    ((Transfer)DbaTreePane.this.tree.getTransferHandler()).setPath(null);
                }

                @Override
                public void drop(DropTargetDropEvent dtde) {
                }
            });
        }
        catch (TooManyListenersException e1) {
            e1.printStackTrace();
        }
        this.getViewport().add((Component)this.tree, null);
        TreePath aTreePath = this.tree.getPathForRow(0);
        this.tree.expandPath(aTreePath);
        this.tree.setSelectionPath(aTreePath);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void addTable(String table_owner, String table_name) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (this.isTableLoaded) {
            TableTreeNode tbnode = new TableTreeNode(table_owner, table_name, "TABLE");
            tbnode.add(new DummyTreeNode());
            this.treeModel.insertNodeInto(tbnode, this.tableNode, this.tableNode.getChildCount());
        }
        if (node instanceof DatabaseTreeNode && ((DatabaseTreeNode)node).getType() == 1) {
            this.tree_valueChanged(null);
            return;
        }
    }

    public void addTablespace(String tsname) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (this.isTablespaceLoaded) {
            this.treeModel.insertNodeInto(new TableSpaceTreeNode(tsname), this.tableSpaceNode, this.tableSpaceNode.getChildCount());
        }
        if (node instanceof DatabaseTreeNode && ((DatabaseTreeNode)node).getType() == 0) {
            this.tree_valueChanged(null);
            return;
        }
    }

    public void addView(String view_owner, String view_name) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (this.isViewLoaded) {
            this.treeModel.insertNodeInto(new ViewTreeNode(view_owner, view_name), this.viewNode, this.viewNode.getChildCount());
        }
        if (node instanceof DatabaseTreeNode && ((DatabaseTreeNode)node).getType() == 2) {
            this.tree_valueChanged(null);
            return;
        }
    }

    private void cleanTree(DefaultMutableTreeNode curNode) {
        if (curNode != null) {
            curNode.removeAllChildren();
        }
        System.gc();
    }

    public void freezeTreeSelection(boolean isFreeze) {
        this.tree.setEnabled(!isFreeze);
        this.freezeTreeNode((DBATreeNode)this.treeModel.getRoot(), isFreeze);
    }

    private void freezeTreeNode(DBATreeNode object, boolean isFreeze) {
        object.setFreeze(isFreeze);
        if (object.getChildCount() > 0) {
            for (DBATreeNode child = (DBATreeNode)object.getFirstChild(); child != null; child = (DBATreeNode)child.getNextSibling()) {
                this.freezeTreeNode(child, isFreeze);
            }
        }
    }

    private DBATreeNode getTreeNode(DBATreeNode parent, String s1, String s2, String s3) {
        DBATreeNode dtnode = null;
        if (parent != null && parent.getChildCount() > 0) {
            for (DBATreeNode child = (DBATreeNode)parent.getFirstChild(); child != null; child = (DBATreeNode)child.getNextSibling()) {
                if (!child.isFound(s1, s2, s3)) continue;
                dtnode = child;
                break;
            }
        }
        return dtnode;
    }

    private void openSelectedTreeNode(DBATreeNode selected) {
        TreePath path = new TreePath(selected.getPath());
        this.tree.makeVisible(path);
        this.tree.scrollPathToVisible(path);
        this.tree.setSelectionPath(path);
    }

    public void openTreeNode(DBATreeNode parent, String s1, String s2, String s3) {
        DBATreeNode selected = this.getTreeNode(parent, s1, s2, s3);
        if (selected == null) {
            selected = parent;
        }
        this.openSelectedTreeNode(selected);
    }

    public void openTablespaceTree(String ts_name) {
        DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
        if (!this.isTablespaceLoaded) {
            this.refreshTableSpaceTree();
        }
        this.openTreeNode(this.tableSpaceNode, ts_name, null, null);
        DbFrame.frame.setCursor(Cursor.getDefaultCursor());
    }

    public void openTableTree(String table_owner, String table_name) {
        DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
        if (!this.isTableLoaded) {
            this.refreshTableTree();
        }
        this.openTreeNode(this.tableNode, table_owner, table_name, null);
        DbFrame.frame.setCursor(Cursor.getDefaultCursor());
    }

    public void openViewTree(String view_owner, String view_name) {
        DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
        if (!this.isViewLoaded) {
            this.refreshViewTree();
        }
        this.openTreeNode(this.viewNode, view_owner, view_name, null);
        DbFrame.frame.setCursor(Cursor.getDefaultCursor());
    }

    public void openTriggerTree(String table_owner, String table_name, String trigger_name) {
        DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
        if (!this.isTriggerLoaded) {
            this.refreshTriggerTree();
        }
        this.openTreeNode(this.triggerNode, table_owner, table_name, trigger_name);
        DbFrame.frame.setCursor(Cursor.getDefaultCursor());
    }

    public void openScheduleTree(String dbname) {
        DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
        if (!this.isScheduleLoaded) {
            this.refreshScheduleTree();
        }
        this.openTreeNode(this.scheduleNode, dbname, null, null);
        DbFrame.frame.setCursor(Cursor.getDefaultCursor());
    }

    public void openReplicationTree(String table_owner, String table_name, String name) {
        DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
        if (!this.isReplicationLoaded) {
            this.refreshReplicationTree(this.replicationNode);
        }
        this.openTreeNode(this.replicationNode, table_owner, table_name, name);
        DbFrame.frame.setCursor(Cursor.getDefaultCursor());
    }

    private DBATreeNode getTableSubTreeNode(String table_owner, String table_name, String type) {
        DBATreeNode p = this.getTreeNode(this.tableNode, table_owner, table_name, null);
        if (p != null) {
            this.refreshTableSubTree((TableTreeNode)p);
            return this.getTreeNode(p, type, null, null);
        }
        return null;
    }

    public void openTableObjectTree(String table_owner, String table_name, String object_name, int type) {
        DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
        DBATreeNode dtnode = this.getTreeNode(this.tableNode, table_owner, table_name, null);
        if (dtnode != null) {
            DBATreeNode rpnode = this.getTreeNode(dtnode, Integer.toString(type), null, null);
            this.openTreeNode(rpnode, table_owner, table_name, object_name);
        }
        DbFrame.frame.setCursor(Cursor.getDefaultCursor());
    }

    public void openProcedureTree(String module, String owner, String name) {
        DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
        if (!this.isProcedureLoaded) {
            this.refreshProcedureTree();
        }
        this.openTreeNode(this.procNode, module, owner, name);
        DbFrame.frame.setCursor(Cursor.getDefaultCursor());
    }

    public void openCommandTree(String owner, String name) {
        DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
        if (!this.isCommandLoaded) {
            this.refreshCommandTree();
        }
        this.openTreeNode(this.commandNode, owner, name, null);
        DbFrame.frame.setCursor(Cursor.getDefaultCursor());
    }

    public void openUserTree(String user) {
        DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
        if (!this.isUserLoaded) {
            this.refreshUserTree();
        }
        this.openTreeNode(this.userNode, user, null, null);
        DbFrame.frame.setCursor(Cursor.getDefaultCursor());
    }

    public void openGroupTree(String group) {
        DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
        if (!this.isGroupLoaded) {
            this.refreshGroupTree();
        }
        this.openTreeNode(this.groupNode, group, null, null);
        DbFrame.frame.setCursor(Cursor.getDefaultCursor());
    }

    public void openDatabaseNode() {
        this.openSelectedTreeNode(this.databaseNode);
    }

    public void refreshAfterCreation(int choice) {
        DBATreeNode node = (DBATreeNode)this.tree.getLastSelectedPathComponent();
        switch (choice) {
            case 0: {
                this.refreshTableSpaceTree();
                break;
            }
            case 1: {
                this.refreshTableTree();
                break;
            }
            case 5: {
                this.refreshTableTree();
                this.refreshTriggerTree();
                break;
            }
            case 6: {
                this.refreshViewTree();
                break;
            }
            case 7: {
                this.refreshUserTree();
                break;
            }
            case 8: {
                this.refreshGroupTree();
                break;
            }
            case 11: {
                this.refreshScheduleTree();
                break;
            }
            case 12: {
                this.refreshTableTree();
                this.refreshReplicationTree();
                break;
            }
            case 13: {
                this.refreshTableTree();
                this.refreshReplicationTree();
                break;
            }
            case 15: {
                this.refreshProcedureTree();
                break;
            }
            case 14: {
                this.refreshCommandTree();
                break;
            }
        }
        this.select(node);
    }

    private void select(DBATreeNode node) {
        this.select(node, null);
    }

    private void select(DBATreeNode node, DBATreeNode parent) {
        if (node instanceof TableSpaceTreeNode) {
            this.openTablespaceTree(((TableSpaceTreeNode)node).getTableSpaceName());
        } else if (node instanceof TableTreeNode) {
            this.openTableTree(((TableTreeNode)node).getTableOwner(), ((TableTreeNode)node).getTableName());
        } else if (node instanceof TableSubTreeNode) {
            DBATreeNode p = this.getTreeNode(this.tableNode, ((TableSubTreeNode)node).getTableOwner(), ((TableSubTreeNode)node).getTableName(), null);
            if (p != null) {
                this.refreshTableSubTree((TableTreeNode)p);
                this.openTreeNode(p, Integer.toString(((TableSubTreeNode)node).getType()), null, null);
            } else {
                this.openSelectedTreeNode(this.tableNode);
            }
        } else if (node instanceof ViewTreeNode) {
            this.openViewTree(((ViewTreeNode)node).getViewOwner(), ((ViewTreeNode)node).getViewName());
        } else if (node instanceof TriggerTreeNode) {
            if (parent != null && parent instanceof TableSubTreeNode) {
                DBATreeNode p2 = this.getTableSubTreeNode(((TriggerTreeNode)node).getTableOwner(), ((TriggerTreeNode)node).getTableName(), Integer.toString(3));
                this.openTreeNode(p2, ((TriggerTreeNode)node).getTableOwner(), ((TriggerTreeNode)node).getTableName(), ((TriggerTreeNode)node).getTriggerName());
            } else {
                this.openTriggerTree(((TriggerTreeNode)node).getTableOwner(), ((TriggerTreeNode)node).getTableName(), ((TriggerTreeNode)node).getTriggerName());
            }
        } else if (node instanceof CommandTreeNode) {
            this.openCommandTree(((CommandTreeNode)node).getOwner(), ((CommandTreeNode)node).getName());
        } else if (node instanceof ProcedureTreeNode) {
            this.openProcedureTree(((ProcedureTreeNode)node).getModuleName(), ((ProcedureTreeNode)node).getProcOwner(), ((ProcedureTreeNode)node).getProcName());
        } else if (node instanceof ScheduleTreeNode) {
            this.openScheduleTree(((ScheduleTreeNode)node).getRemoteDB());
        } else if (node instanceof ReplicationTreeNode) {
            if (parent != null && parent instanceof TableSubTreeNode) {
                DBATreeNode p2 = this.getTableSubTreeNode(((ReplicationTreeNode)node).getTableOwner(), ((ReplicationTreeNode)node).getTableName(), Integer.toString(4));
                this.openTreeNode(p2, ((ReplicationTreeNode)node).getTableOwner(), ((ReplicationTreeNode)node).getTableName(), ((ReplicationTreeNode)node).getReplicationName());
            } else {
                this.openReplicationTree(((ReplicationTreeNode)node).getTableOwner(), ((ReplicationTreeNode)node).getTableName(), ((ReplicationTreeNode)node).getReplicationName());
            }
        } else if (node instanceof UserTreeNode) {
            this.openUserTree(((UserTreeNode)node).getName());
        } else if (node instanceof GroupTreeNode) {
            this.openGroupTree(((GroupTreeNode)node).getName());
        } else if (node instanceof DatabaseTreeNode) {
            this.tree_valueChanged(null);
        }
    }

    public void refreshTree() {
        try {
            if (DbFrame.conn_DatabaseConnection == null) {
                return;
            }
            DBATreeNode node = (DBATreeNode)this.tree.getLastSelectedPathComponent();
            DBATreeNode parent = (DBATreeNode)node.getParent();
            if (this.authority.isAboveDba()) {
                this.refreshTableSpaceTree();
                this.refreshScheduleTree();
                this.refreshGroupTree();
            }
            this.refreshTableTree();
            this.refreshViewTree();
            this.refreshCommandTree();
            this.refreshProcedureTree();
            this.refreshReplicationTree(this.databaseNode);
            this.refreshTriggerTree();
            this.refreshUserTree();
            this.select(node, parent);
        }
        catch (OutOfMemoryError oome) {
            GuiUt.showOutOfMemoryErrorDlg(oome);
        }
    }

    public void refreshTableSubTree(TableTreeNode parent_node) {
        try {
            if (DbFrame.conn_DatabaseConnection == null) {
                return;
            }
            this.cleanTree(parent_node);
            this.fillTableSubTree(parent_node);
            if (!parent_node.getTableOwner().equalsIgnoreCase("SYSTEM")) {
                this.fillTriggerTree(parent_node);
                this.fillReplicationTree(parent_node);
            }
            this.treeModel.nodeStructureChanged(parent_node);
        }
        catch (OutOfMemoryError oome) {
            GuiUt.showOutOfMemoryErrorDlg(oome);
        }
    }

    public void refreshCommandTree() {
        try {
            if (DbFrame.conn_DatabaseConnection == null) {
                return;
            }
            this.cleanTree(this.commandNode);
            this.fillCommandTree();
            this.treeModel.nodeStructureChanged(this.commandNode);
            this.isCommandLoaded = true;
        }
        catch (OutOfMemoryError oome) {
            GuiUt.showOutOfMemoryErrorDlg(oome);
        }
    }

    public void refreshProcedureTree() {
        try {
            if (DbFrame.conn_DatabaseConnection == null) {
                return;
            }
            this.cleanTree(this.procNode);
            this.fillProcedureTree();
            this.treeModel.nodeStructureChanged(this.procNode);
            this.isProcedureLoaded = true;
        }
        catch (OutOfMemoryError oome) {
            GuiUt.showOutOfMemoryErrorDlg(oome);
        }
    }

    public void afterDropObject(int type) {
        DBATreeNode node = (DBATreeNode)this.tree.getLastSelectedPathComponent();
        switch (type) {
            case 0: {
                this.refreshTableSpaceTree();
                break;
            }
            case 1: {
                this.refreshTableTree();
                break;
            }
            case 2: {
                this.refreshViewTree();
                break;
            }
            case 8: {
                this.refreshUserTree();
                break;
            }
            case 9: {
                this.refreshGroupTree();
                break;
            }
            case 19: {
                this.refreshScheduleTree();
                break;
            }
            case 16: {
                this.refreshCommandTree();
                break;
            }
            case 17: {
                this.refreshProcedureTree();
            }
        }
        this.select(node);
    }

    public void afterDropTrigger(String owner, String name) {
        DBATreeNode node = (DBATreeNode)this.tree.getLastSelectedPathComponent();
        DBATreeNode parent = (DBATreeNode)node.getParent();
        this.refreshTriggerTree();
        DBATreeNode p = this.getTableSubTreeNode(owner, name, Integer.toString(3));
        if (p != null) {
            this.refreshTriggerTree(p);
        }
        this.select(node, parent);
    }

    public void afterDropReplication(String owner, String name) {
        DBATreeNode node = (DBATreeNode)this.tree.getLastSelectedPathComponent();
        DBATreeNode parent = (DBATreeNode)node.getParent();
        this.refreshReplicationTree();
        DBATreeNode p = this.getTableSubTreeNode(owner, name, Integer.toString(4));
        this.refreshReplicationTree(p);
        this.select(node, parent);
    }

    public void refreshReplicationTree() {
        this.cleanTree(this.replicationNode);
        this.fillReplicationTree();
        this.treeModel.nodeStructureChanged(this.replicationNode);
        this.isReplicationLoaded = true;
    }

    public void refreshReplicationTree(DefaultMutableTreeNode parent_node) {
        try {
            if (DbFrame.conn_DatabaseConnection == null) {
                return;
            }
            if (parent_node instanceof TableTreeNode) {
                DBATreeNode node = this.getTreeNode((TableTreeNode)parent_node, Integer.toString(4), null, null);
                this.cleanTree(node);
                this.fillReplicationTree((TableTreeNode)parent_node);
                this.treeModel.nodeStructureChanged(node);
            } else {
                this.refreshReplicationTree();
            }
        }
        catch (OutOfMemoryError oome) {
            GuiUt.showOutOfMemoryErrorDlg(oome);
        }
    }

    public void refreshGroupTree() {
        try {
            if (DbFrame.conn_DatabaseConnection == null) {
                return;
            }
            this.cleanTree(this.groupNode);
            this.fillGroupTree();
            this.treeModel.nodeStructureChanged(this.groupNode);
            this.isGroupLoaded = true;
        }
        catch (OutOfMemoryError oome) {
            GuiUt.showOutOfMemoryErrorDlg(oome);
        }
    }

    public void refreshScheduleTree() {
        try {
            if (DbFrame.conn_DatabaseConnection == null) {
                return;
            }
            this.cleanTree(this.scheduleNode);
            this.fillScheduleTree();
            this.treeModel.nodeStructureChanged(this.scheduleNode);
            this.isScheduleLoaded = true;
        }
        catch (OutOfMemoryError oome) {
            GuiUt.showOutOfMemoryErrorDlg(oome);
        }
    }

    public void refreshTableSpaceTree() {
        try {
            if (DbFrame.conn_DatabaseConnection == null) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.cleanTree(this.tableSpaceNode);
            if (this.authority.isAboveDba()) {
                this.fillTableSpaceTree();
            }
            this.treeModel.nodeStructureChanged(this.tableSpaceNode);
            this.setCursor(Cursor.getDefaultCursor());
            this.isTablespaceLoaded = true;
        }
        catch (OutOfMemoryError oome) {
            GuiUt.showOutOfMemoryErrorDlg(oome);
        }
    }

    public void refreshTableTree() {
        try {
            if (DbFrame.conn_DatabaseConnection == null) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.cleanTree(this.tableNode);
            this.fillTableTree();
            this.treeModel.nodeStructureChanged(this.tableNode);
            this.setCursor(Cursor.getDefaultCursor());
            this.isTableLoaded = true;
        }
        catch (OutOfMemoryError oome) {
            GuiUt.showOutOfMemoryErrorDlg(oome);
        }
    }

    public void refreshTriggerTree() {
        this.cleanTree(this.triggerNode);
        this.fillTriggerTree();
        this.treeModel.nodeStructureChanged(this.triggerNode);
        this.isTriggerLoaded = true;
    }

    public void refreshTriggerTree(DefaultMutableTreeNode parent_node) {
        if (DbFrame.conn_DatabaseConnection == null) {
            return;
        }
        try {
            if (parent_node instanceof TableTreeNode) {
                DBATreeNode node = this.getTreeNode((TableTreeNode)parent_node, Integer.toString(3), null, null);
                this.cleanTree(node);
                this.fillTriggerTree((TableTreeNode)parent_node);
                this.treeModel.nodeStructureChanged(node);
            } else {
                this.refreshTriggerTree();
            }
        }
        catch (OutOfMemoryError oome) {
            GuiUt.showOutOfMemoryErrorDlg(oome);
        }
    }

    public void refreshUserTree() {
        try {
            if (DbFrame.conn_DatabaseConnection == null) {
                return;
            }
            this.cleanTree(this.userNode);
            this.fillUserTree();
            this.treeModel.nodeStructureChanged(this.userNode);
            this.isUserLoaded = true;
        }
        catch (OutOfMemoryError oome) {
            GuiUt.showOutOfMemoryErrorDlg(oome);
        }
    }

    public void refreshViewTree() {
        try {
            if (DbFrame.conn_DatabaseConnection == null) {
                return;
            }
            this.cleanTree(this.viewNode);
            this.fillViewTree();
            this.treeModel.nodeStructureChanged(this.viewNode);
            this.isViewLoaded = true;
        }
        catch (OutOfMemoryError oome) {
            GuiUt.showOutOfMemoryErrorDlg(oome);
        }
    }

    private void fillGroupTree() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select GROUP_NAME from SYSAUTHGROUP order by GROUP_NAME";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                this.groupNode.add(new GroupTreeNode(rs.getString(1)));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(this, null, sqle);
        }
    }

    private void fillUserTree() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String query = "select USER_NAME, DBA from SYSAUTHUSER order by USER_NAME";
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                boolean isSysdba = rs.getShort(2) == 2;
                this.userNode.add(new UserTreeNode(rs.getString(1), isSysdba));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(this, null, sqle);
        }
    }

    private void fillScheduleTree() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String query = "select SVRNAME from SYSTEM.SYSTRPDEST order by SVRNAME";
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                this.scheduleNode.add(new ScheduleTreeNode(rs.getString(1)));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(this, null, sqle);
        }
    }

    private void fillCommandTree() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select MODULENAME, CMDOWNER, CMDNAME, NUM_PARM from SYSTEM.SYSCMDINFO where STATUS != 0 and CMDTYPE = 0 order by MODULENAME, CMDOWNER, CMDNAME";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                this.commandNode.add(new CommandTreeNode(rs.getString(1), GuiUt.rightTrim(rs.getString(2)), GuiUt.rightTrim(rs.getString(3)), rs.getInt(4)));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(this, null, sqle);
        }
    }

    private void fillProcedureTree() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String query = "select MODULENAME, PROC_OWNER, PROC_NAME from SYSTEM.SYSPROCINFO order by PROC_OWNER, PROC_NAME";
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                this.procNode.add(new ProcedureTreeNode(GuiUt.rightTrim(rs.getString(1)), GuiUt.rightTrim(rs.getString(2)), GuiUt.rightTrim(rs.getString(3))));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(this, null, sqle);
        }
    }

    private void fillTableSubTree(TableTreeNode parent_node) {
        parent_node.add(new TableSubTreeNode(0, parent_node));
        if (parent_node.getTableOwner().equalsIgnoreCase("SYSTEM")) {
            return;
        }
        parent_node.add(new TableSubTreeNode(1, parent_node));
        parent_node.add(new TableSubTreeNode(5, parent_node));
        parent_node.add(new TableSubTreeNode(2, parent_node));
        parent_node.add(new TableSubTreeNode(3, parent_node));
        parent_node.add(new TableSubTreeNode(4, parent_node));
    }

    private void fillTableTree() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            boolean insystbl = this.getOption("INSYSTBL");
            String query = "select TABLE_OWNER,TABLE_NAME, TABLE_TYPE from SYSTEM.SYSTABLE where ";
            if (this.tableNode.owner != null) {
                query = query + "TABLE_OWNER like '%" + this.tableNode.owner + "%' and ";
            }
            if (this.tableNode.name != null) {
                query = query + "TABLE_NAME like '%" + this.tableNode.name + "%' and ";
            }
            query = !insystbl ? query + "TABLE_TYPE = 'TABLE' ORDER BY TABLE_OWNER, TABLE_NAME" : query + " TABLE_TYPE in ('TABLE','SYSTEM TABLE') ORDER BY TABLE_TYPE, TABLE_OWNER, TABLE_NAME";
            rs = stmt.executeQuery(query);
            TableTreeNode newNode = null;
            String table_owner = null;
            String table_name = null;
            String table_type = null;
            while (rs.next()) {
                table_owner = rs.getString(1);
                table_name = rs.getString(2);
                table_type = rs.getString(3).trim();
                newNode = new TableTreeNode(table_owner, table_name, table_type);
                newNode.add(new DummyTreeNode());
                this.tableNode.add(newNode);
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(this, null, sqle);
        }
    }

    private void fillViewTree() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            boolean insystbl = this.getOption("INSYSTBL");
            boolean showAllViews = DbFrame.frame.px.getShowAllViews();
            String query = "";
            query = !insystbl ? (showAllViews ? "select tb.TABLE_OWNER, tb.TABLE_NAME from SYSTEM.SYSTABLE tb where tb.TABLE_TYPE = 'VIEW' ORDER BY tb.TABLE_OWNER, tb.TABLE_NAME" : "select tb.TABLE_OWNER, tb.TABLE_NAME from SYSTEM.SYSTABLE tb, SYSTEM.SYSVIEWDATA v where v.STATUS != 0 and tb.TABLE_TYPE = 'VIEW' and tb.TABLE_NAME = v.VIEW_NAME and tb.TABLE_OWNER = v.VIEW_OWNER ORDER BY tb.TABLE_OWNER, tb.TABLE_NAME") : (showAllViews ? "select tb.TABLE_OWNER, tb.TABLE_NAME from SYSTEM.SYSTABLE tb where tb.TABLE_TYPE in ('VIEW','SYSTEM VIEW') ORDER BY tb.TABLE_OWNER, tb.TABLE_NAME" : "select tb.TABLE_OWNER, tb.TABLE_NAME from SYSTEM.SYSTABLE tb, SYSTEM.SYSVIEWDATA v where v.STATUS != 0 and tb.TABLE_TYPE in ('VIEW','SYSTEM VIEW') and tb.TABLE_NAME = v.VIEW_NAME and tb.TABLE_OWNER = v.VIEW_OWNER ORDER BY tb.TABLE_OWNER, tb.TABLE_NAME");
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                this.viewNode.add(new ViewTreeNode(GuiUt.rightTrim(rs.getString(1)), GuiUt.rightTrim(rs.getString(2))));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(this, null, sqle);
        }
    }

    private void fillTableSpaceTree() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select TS_NAME from SYSTEM.SYSTABLESPACE";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                this.tableSpaceNode.add(new TableSpaceTreeNode(rs.getString(1)));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(this, null, sqle);
        }
    }

    private void fillTriggerTree(TableTreeNode table_node) {
        TableSubTreeNode trigger_node = (TableSubTreeNode)this.getTreeNode(table_node, Integer.toString(3), null, null);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select TRIGNAME from SYSTEM.SYSTRIGGER where MODE != 0 and RESERVE1 != 1 and TBOWNER = '" + table_node.getTableOwner() + "' and TBNAME = '" + table_node.getTableName() + "' order by TRIGNAME";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                trigger_node.add(new TriggerTreeNode(rs.getString(1), table_node));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(this, null, sqle);
        }
    }

    private void fillTriggerTree() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select TBOWNER, TBNAME, TRIGNAME from SYSTEM.SYSTRIGGER where MODE != 0 and RESERVE1 != 1 order by TRIGNAME";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                this.triggerNode.add(new TriggerTreeNode(rs.getString(1), rs.getString(2), rs.getString(3)));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(this, null, sqle);
        }
    }

    private void fillReplicationTree(TableTreeNode table_node) {
        TableSubTreeNode replication_node = (TableSubTreeNode)this.getTreeNode(table_node, Integer.toString(4), null, null);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select REPLICATION_NAME, TYPE, TABLE_OWNER, TABLE_NAME, PROJECT from SYSTEM.SYSPUBLISH where TABLE_OWNER = '" + table_node.getTableOwner() + "' " + "and TABLE_NAME = '" + table_node.getTableName() + "' " + "order by REPLICATION_NAME";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                String proj = rs.getString(5);
                String newStr = "";
                if (proj != null && proj.length() > 0) {
                    int len = proj.length();
                    int i = 0;
                    while (i < len) {
                        String sub = proj.substring(i, 128 + i).trim();
                        String mark = "";
                        mark = (i += 128) == len / 128 * 128 ? "" : ", ";
                        newStr = newStr + sub + mark;
                    }
                }
                replication_node.add(new ReplicationTreeNode(GuiUt.rightTrim(rs.getString(1)), GuiUt.rightTrim(rs.getString(3)), GuiUt.rightTrim(rs.getString(4)), rs.getString(2), rs.getString(5), table_node));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(this, null, sqle);
        }
    }

    private void fillReplicationTree() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select REPLICATION_NAME, TYPE, TABLE_OWNER, TABLE_NAME, PROJECT from SYSTEM.SYSPUBLISH order by REPLICATION_NAME";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                String proj = rs.getString(5);
                String newStr = "";
                if (proj != null && proj.length() > 0) {
                    int len = proj.length();
                    int i = 0;
                    while (i < len) {
                        String sub = proj.substring(i, 128 + i).trim();
                        String mark = "";
                        mark = (i += 128) == len / 128 * 128 ? "" : ", ";
                        newStr = newStr + sub + mark;
                    }
                }
                this.replicationNode.add(new ReplicationTreeNode(GuiUt.rightTrim(rs.getString(1)), GuiUt.rightTrim(rs.getString(3)), GuiUt.rightTrim(rs.getString(4)), rs.getString(2), newStr, this.replicationNode));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(this, null, sqle);
        }
    }

    public void tree_valueChanged(TreeSelectionEvent e) {
        try {
            ViewDataPanel vP;
            ViewTreeNode vN;
            ViewInfo vInfo;
            DBATreeNode preNode;
            TreePath prePath;
            DbFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
            DBATreeNode node = (DBATreeNode)this.tree.getLastSelectedPathComponent();
            System.out.println("node=" + node);
            if (e != null && (prePath = e.getOldLeadSelectionPath()) != null && (preNode = (DBATreeNode)prePath.getLastPathComponent()) instanceof ViewTreeNode && (vInfo = (vN = (ViewTreeNode)preNode).getContentPanel()) != null && (vP = vInfo.getViewDataPanel()) != null) {
                vP.closeResultSet();
            }
            if (node == null) {
                return;
            }
            DbFrame.frame.setStatusDisc("  ");
            DbFrame.frame.setHelpID(this, node.getHelpID());
            node.displayObject();
            DbFrame.frame.setCursor(Cursor.getDefaultCursor());
        }
        catch (OutOfMemoryError oome) {
            GuiUt.showOutOfMemoryErrorDlg(oome);
        }
    }

    void tree_treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
        try {
            DBAResourceBundle res = DbFrame.frame.res;
            TreePath path = e.getPath();
            DBATreeNode node = (DBATreeNode)path.getLastPathComponent();
            if (node == null) {
                return;
            }
            if (node instanceof TableTreeNode && node.getChildCount() == 1) {
                this.refreshTableSubTree((TableTreeNode)node);
            } else if (node instanceof DatabaseTreeNode) {
                int type = ((DatabaseTreeNode)node).getType();
                String s = null;
                if (type == 1) {
                    if (!DbFrame.frame.px.getTreeviewRefresh() && this.isTableLoaded) {
                        return;
                    }
                    this.refreshTableTree();
                    s = res.getString("Tables_in_the_tree");
                } else if (type == 2) {
                    if (!DbFrame.frame.px.getTreeviewRefresh() && this.isViewLoaded) {
                        return;
                    }
                    this.refreshViewTree();
                    s = res.getString("Views_in_the_tree");
                } else if (type == 0) {
                    if (!DbFrame.frame.px.getTreeviewRefresh() && this.isTablespaceLoaded) {
                        return;
                    }
                    this.refreshTableSpaceTree();
                    s = res.getString("Tablespaces_in_the_tree");
                } else if (type == 15) {
                    if (!DbFrame.frame.px.getTreeviewRefresh() && this.isTriggerLoaded) {
                        return;
                    }
                    this.refreshTriggerTree();
                    s = res.getString("Triggers_in_the_tree");
                } else if (type == 17) {
                    if (!DbFrame.frame.px.getTreeviewRefresh() && this.isProcedureLoaded) {
                        return;
                    }
                    this.refreshProcedureTree();
                    s = res.getString("Stored_procedures_in_the_tree");
                } else if (type == 20) {
                    if (!DbFrame.frame.px.getTreeviewRefresh() && this.isReplicationLoaded) {
                        return;
                    }
                    this.refreshReplicationTree(node);
                    s = res.getString("Replications_in_the_tree");
                } else if (type == 19) {
                    if (!DbFrame.frame.px.getTreeviewRefresh() && this.isScheduleLoaded) {
                        return;
                    }
                    this.refreshScheduleTree();
                    s = res.getString("Schedule_in_the_tree");
                } else if (type == 16) {
                    if (!DbFrame.frame.px.getTreeviewRefresh() && this.isCommandLoaded) {
                        return;
                    }
                    this.refreshCommandTree();
                    s = res.getString("Stored_commands_in_the_tree");
                } else if (type == 8) {
                    if (!DbFrame.frame.px.getTreeviewRefresh() && this.isUserLoaded) {
                        return;
                    }
                    this.refreshUserTree();
                    s = res.getString("Users_in_the_tree");
                } else if (type == 9) {
                    if (!DbFrame.frame.px.getTreeviewRefresh() && this.isGroupLoaded) {
                        return;
                    }
                    this.refreshGroupTree();
                    s = res.getString("Groups_in_the_tree");
                }
                if (s == null) {
                    return;
                }
                s = GuiUt.mapStringForProperty(s, Integer.toString(node.getChildCount()));
                DbFrame.frame.setStatusDisc(s);
            }
        }
        catch (OutOfMemoryError oome) {
            GuiUt.showOutOfMemoryErrorDlg(oome);
        }
    }

    void tree_mousePressed(MouseEvent e) {
        if (!this.tree.isEnabled()) {
            return;
        }
        try {
            if (e.getModifiers() == 4) {
                TreePath path = this.tree.getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    return;
                }
                DBATreeNode node = (DBATreeNode)path.getLastPathComponent();
                if (node != null) {
                    this.tree.setSelectionPath(path);
                    node.displayMenu(e);
                }
            }
        }
        catch (OutOfMemoryError oome) {
            GuiUt.showOutOfMemoryErrorDlg(oome);
        }
    }

    public void removeTree() {
        this.getViewport().removeAll();
        if (this.tree != null) {
            Enumeration enum1 = LocaleManager.getLocaleManager().getLocaleChangedListener().elements();
            LocaleChangeListener obj = null;
            while (enum1.hasMoreElements()) {
                obj = (LocaleChangeListener)enum1.nextElement();
                if (!(obj instanceof DbaTree) && !(obj instanceof DBATreeNode)) continue;
                LocaleManager.getLocaleManager().removeLocaleChangeListener(obj);
            }
            this.tree.removeTreeSelectionListener(this.tslistener);
            this.tree.removeMouseListener(this.treeMouseAdapter);
            this.tree.removeTreeWillExpandListener(this.twelistener);
            this.tree.removeAll();
            this.tree = null;
            this.treeModel = null;
            this.tslistener = null;
            this.twelistener = null;
            this.treeMouseAdapter = null;
            this.databaseNode = null;
            this.tableSpaceNode = null;
            this.tableNode = null;
            this.viewNode = null;
            this.domainNode = null;
            this.userNode = null;
            this.groupNode = null;
            this.synonymNode = null;
            this.commandNode = null;
            this.procNode = null;
            this.dbmonitorNode = null;
            this.dblinkNode = null;
            this.scheduleNode = null;
            this.replicationNode = null;
            this.indexNode = null;
            this.tindexNode = null;
            this.foreignkeyNode = null;
            this.triggerNode = null;
            this.ivftindexNode = null;
            this.schemaNode = null;
            this.aclNode = null;
            this.isTablespaceLoaded = false;
            this.isTableLoaded = false;
            this.isViewLoaded = false;
            this.isTriggerLoaded = false;
            this.isProcedureLoaded = false;
            this.isCommandLoaded = false;
            this.isReplicationLoaded = false;
            this.isScheduleLoaded = false;
            this.isUserLoaded = false;
            this.isGroupLoaded = false;
        }
    }

    private void laodAllNodes() {
        try {
            if (DbFrame.conn_DatabaseConnection == null) {
                return;
            }
            if (this.authority.isAboveDba()) {
                this.fillTableSpaceTree();
                this.fillScheduleTree();
                this.fillGroupTree();
                this.treeModel.nodeStructureChanged(this.tableSpaceNode);
                this.treeModel.nodeStructureChanged(this.scheduleNode);
                this.treeModel.nodeStructureChanged(this.groupNode);
                this.isTablespaceLoaded = true;
                this.isScheduleLoaded = true;
                this.isGroupLoaded = true;
            }
            this.fillTableTree();
            this.fillViewTree();
            this.fillCommandTree();
            this.fillProcedureTree();
            this.refreshReplicationTree(this.databaseNode);
            this.fillTriggerTree();
            this.fillUserTree();
            this.treeModel.nodeStructureChanged(this.tableNode);
            this.treeModel.nodeStructureChanged(this.viewNode);
            this.treeModel.nodeStructureChanged(this.commandNode);
            this.treeModel.nodeStructureChanged(this.procNode);
            this.treeModel.nodeStructureChanged(this.triggerNode);
            this.treeModel.nodeStructureChanged(this.userNode);
            this.isTableLoaded = true;
            this.isViewLoaded = true;
            this.isCommandLoaded = true;
            this.isProcedureLoaded = true;
            this.isTriggerLoaded = true;
            this.isUserLoaded = true;
        }
        catch (OutOfMemoryError oome) {
            GuiUt.showOutOfMemoryErrorDlg(oome);
        }
    }

    public boolean getOption(String option_keyword) {
        if (option_keyword.equals("INSYSTBL")) {
            return DbFrame.frame.px.getShowSystemTable();
        }
        return false;
    }

    private class Transfer
    extends TransferHandler {
        private TreePath oldPath = null;
        private String currentSpaceName;

        private Transfer() {
        }

        public void setPath(TreePath oldPath) {
            this.oldPath = oldPath;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            DbFrame.frame.treePanel.setMoveTableFlag(true);
            boolean isTargetNode = false;
            DbaTree tree = (DbaTree)support.getComponent();
            if (this.oldPath == null) {
                this.oldPath = tree.getSelectionPath();
            }
            String currentPathName = tree.getSelectionPath().getLastPathComponent().toString();
            this.currentSpaceName = this.oldPath.getLastPathComponent().toString();
            isTargetNode = tree.getLastSelectedPathComponent() instanceof TableSpaceTreeNode ? !(currentPathName.equals("SYSTABLESPACE") || currentPathName.equals("TMPTABLESPACE") || currentPathName.equals(this.currentSpaceName)) : false;
            support.setShowDropLocation(true);
            return isTargetNode;
        }

        @Override
        public boolean importData(final JComponent comp, Transferable t) {
            DbFrame.frame.treePanel.setMoveTableFlag(false);
            final TreePath path = ((DbaTree)comp).getSelectionPath();
            DataFlavor[] df = t.getTransferDataFlavors();
            ArrayList data = null;
            try {
                data = (ArrayList)t.getTransferData(df[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            final ArrayList data1 = data;
            DbaTreePane.this.freezeTreeSelection(true);
            new Thread(){

                @Override
                public void run() {
                    int selectedIndex = ((DbaTabbedPane)DbFrame.frame.getContentPanel()).getSelectedIndex();
                    boolean isIndex = false;
                    if (selectedIndex == 2) {
                        isIndex = true;
                    }
                    new MoveTableSpaceDialog(DbFrame.frame, Transfer.this.currentSpaceName, data1, path.getLastPathComponent().toString(), isIndex);
                    ((DbaTree)comp).setSelectionPath(Transfer.this.oldPath);
                    ((DbaTabbedPane)DbFrame.frame.getContentPanel()).setSelectedIndex(selectedIndex);
                    DbaTreePane.this.freezeTreeSelection(false);
                    Transfer.this.oldPath = null;
                }
            }.start();
            return true;
        }
    }
}

