/*
 * Decompiled with CFR 0.152.
 */
package controller;

import controller.ParserManager;
import java.io.Reader;
import reporter.Reporter;
import ui.JsqlUI;

public class UIManager {
    private UIManager uiManager = null;
    private JsqlUI ui = null;
    private Reporter reporter = null;
    private ParserManager pM = null;

    public UIManager(JsqlUI ui) {
        this.ui = ui;
        this.reporter = new Reporter(this);
        this.pM = new ParserManager(this);
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    public UIManager getUIManager() {
        return this.uiManager;
    }

    public JsqlUI getUI() {
        return this.ui;
    }

    public void openWriter() {
        if (this.ui == null) {
            return;
        }
        this.ui.openWriter();
    }

    public void closeWriter() {
        if (this.ui == null) {
            return;
        }
        this.ui.closeWriter();
    }

    public void process(Reader reader) {
        this.pM.parse(reader);
    }

    public void process(String cmd) {
        this.pM.parse(cmd);
    }
}

