/*
 * Decompiled with CFR 0.152.
 */
package ServerMgr;

import ServerMgr.SmFrame;
import dbaut.preference.CorePreferences;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PreferencesXml
extends CorePreferences {
    private Point position = new Point(0, 0);
    private short start_database_option = 0;
    private short start_database_ask_again_option = 0;
    private short create_database_option = 0;
    private short create_database_ask_again_option = 0;
    private String selected_directory = null;
    private Element syscom = null;
    public String orString = null;
    public boolean isWindows = true;
    public String user_dir = null;
    public String file_separator = null;
    public static final int START_DATABASE_OPTION = 0;
    public static final int START_DATABASE_ASK_AGAIN_OPTION = 1;
    public static final int CREATE_DATABASE_OPTION = 2;
    public static final int CREATE_DATABASE_ASK_AGAIN_OPTION = 3;
    public static final int SELECTED_DIRECTORY = 4;
    private static PreferencesXml self = null;

    public static void initPreferencesXml() {
        if (self == null) {
            self = new PreferencesXml();
        }
    }

    public static PreferencesXml getPreferencesXml() {
        if (self == null) {
            self = new PreferencesXml();
        }
        return self;
    }

    public PreferencesXml() {
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.file_separator = System.getProperty("file.separator");
        this.user_dir = System.getProperty("user.dir");
        this.isWindows = this.file_separator.equals("\\");
        this.init(CorePreferences.getConfigName());
    }

    private void init(String fileName) throws Exception {
        File f = new File(fileName);
        if (!f.exists()) {
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(fileName);
        Transformer serializer = TransformerFactory.newInstance().newTransformer();
        serializer.setOutputProperty("omit-xml-declaration", "yes");
        String temp = null;
        Node node = null;
        this.resetDOM(doc);
        node = XPathAPI.selectSingleNode((Node)doc, (String)"/syscom/jsvrmgr");
        if (node != null && node.getNodeType() == 1 && (temp = ((Element)node).getAttribute("selected_directory")) != null && temp.length() > 0) {
            this.selected_directory = temp;
        }
        if ((node = XPathAPI.selectSingleNode((Node)doc, (String)"/syscom/jsvrmgr/frame")) != null && node.getNodeType() == 1) {
            Element elm = (Element)node;
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int xpos = 0;
            int ypos = 0;
            temp = elm.getAttribute("xpos");
            if (temp != null && temp.length() > 0 && ((xpos = Integer.parseInt(temp)) < 0 || (double)xpos > screenSize.getWidth())) {
                xpos = 0;
            }
            if ((temp = elm.getAttribute("ypos")) != null && temp.length() > 0 && ((ypos = Integer.parseInt(temp)) < 0 || (double)ypos > screenSize.getHeight())) {
                ypos = 0;
            }
            this.position = new Point(xpos, ypos);
        }
        if ((node = XPathAPI.selectSingleNode((Node)doc, (String)"/syscom/jsvrmgr/options")) != null && node.getNodeType() == 1) {
            temp = ((Element)node).getAttribute("start_database_option");
            if (temp != null && temp.length() > 0) {
                this.start_database_option = Short.parseShort(temp);
            }
            if ((temp = ((Element)node).getAttribute("start_database_ask_again_option")) != null && temp.length() > 0) {
                this.start_database_ask_again_option = Short.parseShort(temp);
            }
            if ((temp = ((Element)node).getAttribute("careate_database_option")) != null && temp.length() > 0) {
                this.create_database_option = Short.parseShort(temp);
            }
            if ((temp = ((Element)node).getAttribute("create_database_ask_again_option")) != null && temp.length() > 0) {
                this.create_database_ask_again_option = Short.parseShort(temp);
            }
        }
    }

    public void updateVariables(int options, String value) {
        switch (options) {
            case 0: {
                this.start_database_option = Short.parseShort(value);
                break;
            }
            case 1: {
                this.start_database_ask_again_option = Short.parseShort(value);
                break;
            }
            case 2: {
                this.create_database_option = Short.parseShort(value);
                break;
            }
            case 3: {
                this.create_database_ask_again_option = Short.parseShort(value);
                break;
            }
            case 4: {
                this.selected_directory = value;
            }
        }
    }

    public Point getLocation() {
        return this.position;
    }

    public short getStartDatabaseOptionSetting() {
        return this.start_database_option;
    }

    public short getStartDatabaseAskAgainOptionSetting() {
        return this.start_database_ask_again_option;
    }

    public short getCreateDatabaseOptionSetting() {
        return this.create_database_option;
    }

    public short getCreateDatabaseAskAgainOptionSetting() {
        return this.create_database_ask_again_option;
    }

    public String getSelectedDirectory() {
        return this.selected_directory;
    }

    @Override
    public void save() {
        this.save(CorePreferences.getConfigName());
    }

    private void save(String fileName) {
        this.position = SmFrame.frame.getLocationOnScreen();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Document doc = null;
        Element jsvrmgr2 = null;
        File file = new File(fileName);
        if (file.exists()) {
            try {
                doc = builder.parse(fileName);
            }
            catch (Exception pe) {
                doc = builder.newDocument();
            }
        } else {
            doc = builder.newDocument();
        }
        this.setDOM(doc);
        this.syscom = doc.getDocumentElement();
        if (this.syscom == null) {
            System.out.println("CorePreferences fails to save <syscom>");
        }
        jsvrmgr2 = doc.createElement("jsvrmgr");
        if (this.selected_directory != null && this.selected_directory.length() > 0) {
            jsvrmgr2.setAttribute("selected_directory", this.selected_directory);
        }
        Element frame = doc.createElement("frame");
        frame.setAttribute("xpos", Integer.toString((int)this.position.getX()));
        frame.setAttribute("ypos", Integer.toString((int)this.position.getY()));
        Element options = doc.createElement("options");
        options.setAttribute("start_database_option", Short.toString(this.start_database_option));
        options.setAttribute("start_database_ask_again_option", Short.toString(this.start_database_ask_again_option));
        options.setAttribute("create_database_option", Short.toString(this.create_database_option));
        options.setAttribute("create_database_ask_again_option", Short.toString(this.create_database_ask_again_option));
        jsvrmgr2.appendChild(frame);
        jsvrmgr2.appendChild(options);
        Node orig = null;
        try {
            orig = XPathAPI.selectSingleNode((Node)this.syscom, (String)"jsvrmgr");
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        if (orig != null && orig.getNodeType() == 1) {
            this.syscom.replaceChild(jsvrmgr2, orig);
        } else {
            this.syscom.appendChild(jsvrmgr2);
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            StreamResult result = new StreamResult(out);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            out.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }
}

