/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.dx.dataset.CustomPaintSite;
import com.borland.jbcl.model.BasicSingletonContainer;
import com.borland.jbcl.model.BasicViewManager;
import com.borland.jbcl.model.ItemEditSite;
import com.borland.jbcl.model.ItemEditor;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.model.SingletonModel;
import com.borland.jbcl.model.SingletonModelEvent;
import com.borland.jbcl.model.SingletonModelListener;
import com.borland.jbcl.model.SingletonModelMulticaster;
import com.borland.jbcl.model.SingletonViewManager;
import com.borland.jbcl.model.ToggleItemEditor;
import com.borland.jbcl.model.WritableSingletonModel;
import com.borland.jbcl.util.KeyMulticaster;
import com.borland.jbcl.view.BeanPanel;
import com.borland.jbcl.view.CustomItemEditor;
import com.borland.jbcl.view.CustomItemListener;
import com.borland.jbcl.view.CustomItemPainter;
import com.borland.jbcl.view.DataToolTip;
import com.borland.jbcl.view.FocusableItemPainter;
import com.borland.jbcl.view.Res;
import com.borland.jbcl.view.SelectableItemPainter;
import com.borland.jbcl.view.SingletonView;
import com.borland.jbcl.view.TextItemEditor;
import com.borland.jbcl.view.TextItemPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public class FieldView
extends BeanPanel
implements SingletonView,
SingletonModelListener,
ItemEditSite,
KeyListener,
FocusListener,
Serializable {
    private static final long serialVersionUID = 200L;
    private transient SingletonModel model;
    private transient WritableSingletonModel writeModel;
    private transient SingletonViewManager viewManager;
    private boolean readOnly;
    private ItemEditor editor;
    private Point editClickPoint;
    private boolean selectable = false;
    private boolean postOnEndEdit = true;
    private boolean autoEdit = true;
    private boolean growEditor = true;
    private boolean editInPlace = true;
    private boolean showFocus = true;
    private boolean showRollover = false;
    private DataToolTip toolTip = new DataToolTip(this);
    private boolean flat = false;
    private int state;
    private Insets margins = new Insets(2, 2, 2, 2);
    private int alignment = 33;
    private int preferredHeight = 20;
    private int preferredWidth = 100;
    private boolean endEditFailed = false;
    private transient KeyMulticaster keyMulticaster = new KeyMulticaster();
    private transient SingletonModelMulticaster modelMulticaster = new SingletonModelMulticaster();
    protected boolean postOnFocusLost = true;
    private transient CustomItemPainter customPainter = new CustomItemPainter();
    private transient CustomItemEditor customEditor = new CustomItemEditor();
    private transient Vector customizeListeners;

    public FieldView() {
        super(null);
        super.setBackground(UIManager.getColor("TextField.background"));
        super.setForeground(UIManager.getColor("TextField.foreground"));
        super.setBorder(UIManager.getBorder("TextField.border"));
        super.addKeyListener(this.keyMulticaster);
        this.setModel(this.createDefaultModel());
        this.setViewManager(this.createDefaultViewManager());
    }

    public void updateUI() {
        super.updateUI();
        super.setBackground(UIManager.getColor("TextField.background"));
        super.setForeground(UIManager.getColor("TextField.foreground"));
        super.setBorder(UIManager.getBorder("TextField.border"));
    }

    protected SingletonModel createDefaultModel() {
        return new BasicSingletonContainer();
    }

    protected SingletonViewManager createDefaultViewManager() {
        return new BasicViewManager(new FocusableItemPainter(new SelectableItemPainter(new TextItemPainter())), new TextItemEditor());
    }

    public SingletonModel getModel() {
        return this.model;
    }

    public void setModel(SingletonModel sm) {
        this.safeEndEdit();
        if (this.model != null) {
            this.model.removeModelListener(this);
            this.model.removeModelListener(this.modelMulticaster);
        }
        this.model = sm;
        if (this.model != null) {
            this.model.addModelListener(this);
            this.model.addModelListener(this.modelMulticaster);
        }
        this.writeModel = this.model instanceof WritableSingletonModel ? (WritableSingletonModel)this.model : null;
        this.repaint(100L);
    }

    public WritableSingletonModel getWriteModel() {
        return this.readOnly ? null : this.writeModel;
    }

    public void addModelListener(SingletonModelListener l) {
        this.modelMulticaster.add(l);
    }

    public void removeModelListener(SingletonModelListener l) {
        this.modelMulticaster.remove(l);
    }

    public void setReadOnly(boolean ro) {
        this.readOnly = ro;
    }

    public boolean isReadOnly() {
        return this.readOnly ? true : this.writeModel == null;
    }

    public void setEditInPlace(boolean editInPlace) {
        this.editInPlace = editInPlace;
    }

    public boolean isEditInPlace() {
        return this.editInPlace;
    }

    public boolean isPostOnEndEdit() {
        return this.postOnEndEdit;
    }

    public void setPostOnEndEdit(boolean post) {
        this.postOnEndEdit = post;
    }

    public void setAutoEdit(boolean edit) {
        this.autoEdit = edit;
    }

    public boolean isAutoEdit() {
        return this.autoEdit;
    }

    public void setGrowEditor(boolean growEditor) {
        this.growEditor = growEditor;
    }

    public boolean isGrowEditor() {
        return this.growEditor;
    }

    public boolean isEditing() {
        return this.editor != null;
    }

    public ItemEditor getEditor() {
        return this.editor;
    }

    public boolean isPostOnFocusLost() {
        return this.postOnFocusLost;
    }

    public void setPostOnFocusLost(boolean post) {
        this.postOnFocusLost = post;
    }

    public void setShowFocus(boolean visible) {
        if (this.showFocus != visible) {
            this.showFocus = visible;
            this.repaint(100L);
        }
    }

    public boolean isShowFocus() {
        return this.showFocus;
    }

    public void setFlat(boolean flat) {
        if (flat != this.flat) {
            this.flat = flat;
            if (flat) {
                this.setBorder(null);
            } else {
                this.setBorder(UIManager.getBorder("TextField.border"));
            }
            this.invalidate();
            this.repaint(100L);
        }
    }

    public boolean isFlat() {
        return this.flat;
    }

    public Insets getItemMargins() {
        return this.margins;
    }

    public void setItemMargins(Insets margins) {
        this.margins = margins;
        this.repaint(100L);
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int align) {
        this.alignment = align;
    }

    public void setViewManager(SingletonViewManager viewManager) {
        this.safeEndEdit();
        this.viewManager = viewManager;
        this.repaint();
    }

    public SingletonViewManager getViewManager() {
        return this.viewManager;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean select) {
        this.selectable = select;
        if (!this.selectable) {
            this.state &= 0xFFFFFFFC;
            this.repaint(100L);
        }
    }

    public void setDataToolTip(boolean dataTip) {
        this.toolTip.active = dataTip;
        ToolTipManager ttm = ToolTipManager.sharedInstance();
        if (this.toolTip.active) {
            ttm.registerComponent(this);
        } else if (this.getToolTipText() == null) {
            ttm.unregisterComponent(this);
        }
    }

    public boolean isDataToolTip() {
        return this.toolTip.active;
    }

    public boolean isSelected() {
        return this.selectable && (this.state & 4) != 0;
    }

    public void setSelected(boolean selected) {
        this.state = this.selectable && selected ? (this.state |= 4) : (this.state &= 0xFFFFFFFB);
        this.repaint(100L);
    }

    public void setShowRollover(boolean showRollover) {
        this.showRollover = showRollover;
    }

    public boolean isShowRollover() {
        return this.showRollover;
    }

    protected String paramString() {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(super.paramString()))).append(",selectable=").append(this.selectable).append(",state=").append(this.state)));
    }

    public void update(Graphics g2) {
        this.paint(g2);
    }

    public Point getEditClickPoint() {
        return this.editClickPoint;
    }

    public boolean isTransparent() {
        return this.texture != null ? true : !this.isOpaque();
    }

    public Graphics getSiteGraphics() {
        Graphics g2 = this.getGraphics();
        if (g2 != null) {
            g2.setFont(this.getFont());
        }
        return g2;
    }

    public Component getSiteComponent() {
        return this;
    }

    public void startEdit() {
        if (this.model == null || this.viewManager == null || !this.editInPlace || this.isReadOnly() || !this.writeModel.canSet(true)) {
            return;
        }
        Object data = this.model.get();
        this.editor = this.getEditor(data);
        if (this.editor != null) {
            Component editorComponent = this.editor.getComponent();
            if (editorComponent != null) {
                editorComponent.setVisible(false);
                this.add(editorComponent);
            }
            Rectangle r = this.getEditorRect();
            this.editor.addKeyListener(this);
            this.editor.addKeyListener(this.keyMulticaster);
            this.editor.startEdit(data, r, this);
            this.resyncEditor();
            if (this.editor != null && this.editor.getComponent() != null) {
                this.editor.getComponent().addFocusListener(this);
            }
            this.editClickPoint = null;
        }
    }

    protected Rectangle getEditorRect() {
        Component c2;
        Rectangle rect = null;
        if (this.editor != null && (rect = this.outerRect()) != null && this.growEditor && (c2 = this.editor.getComponent()) != null) {
            Dimension ps = c2.getPreferredSize();
            if (ps.height > rect.height) {
                rect.height = ps.height;
            }
        }
        return rect;
    }

    protected void resyncEditor() {
        if (this.editor != null) {
            Rectangle er = this.getEditorRect();
            this.editor.changeBounds(er != null ? er : new Rectangle());
        }
    }

    private boolean isToggleItem() {
        if (this.model == null || this.viewManager == null || !this.editInPlace) {
            return false;
        }
        Object data = this.model.get();
        ItemEditor ie = this.getEditor(data);
        if (ie instanceof ToggleItemEditor) {
            return !this.isReadOnly() && ((ToggleItemEditor)ie).isToggle(data, new Rectangle(0, 0, this.getSize().width, this.getSize().height), this) && this.writeModel.canSet(false);
        }
        return false;
    }

    public void endEdit() throws Exception {
        this.endEdit(this.postOnEndEdit);
    }

    public void endEdit(boolean post) throws Exception {
        this.endEditFailed = false;
        ItemEditor editor = this.editor;
        this.editor = null;
        if (editor != null) {
            boolean okToEnd = true;
            try {
                if (!post || (okToEnd = editor.canPost())) {
                    if (post && okToEnd) {
                        this.writeModel.set(editor.getValue());
                    }
                    if (okToEnd && editor != null) {
                        Component editorComponent = editor.getComponent();
                        editor.endEdit(post);
                        editor.removeKeyListener(this);
                        editor.removeKeyListener(this.keyMulticaster);
                        if (editorComponent != null) {
                            this.remove(editorComponent);
                            editorComponent.removeFocusListener(this);
                        }
                        this.editClickPoint = null;
                        editor = null;
                        this.requestFocus();
                    }
                }
            }
            catch (Exception x) {
                this.endEditFailed = true;
                this.editor = editor;
                throw x;
            }
        }
        this.editor = editor;
    }

    public void safeEndEdit() {
        this.safeEndEdit(this.postOnEndEdit);
    }

    public void safeEndEdit(boolean post) {
        try {
            this.endEdit(post);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Rectangle getInnerRect(Graphics g2) {
        return this.getInnerRect();
    }

    public Rectangle getInnerRect() {
        if (this.flat) {
            return this.outerRect();
        }
        Dimension outerSz = this.getSize();
        Insets bin = this.getBorder() != null ? this.getBorder().getBorderInsets(this) : new Insets(0, 0, 0, 0);
        Dimension innerSz = new Dimension(outerSz.width - bin.left - bin.right, outerSz.height - bin.top - bin.bottom);
        return new Rectangle(bin.left, bin.top, innerSz.width, innerSz.height);
    }

    private Rectangle outerRect() {
        Dimension outerSz = this.getSize();
        return new Rectangle(0, 0, outerSz.width, outerSz.height);
    }

    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        Dimension outerSz = this.getSize();
        Object data = this.model != null ? this.model.get() : null;
        ItemPainter painter = this.getPainter(data);
        Rectangle r = this.getInnerRect();
        if (painter != null) {
            g2.setColor(this.getBackground());
            g2.setFont(this.getFont());
            painter.paint(data, g2, r, this.state, this);
        } else {
            g2.setColor(Color.red);
            g2.fillRect(r.x, r.y, r.width, r.height);
        }
    }

    public void keyTyped(KeyEvent e2) {
    }

    public void keyPressed(KeyEvent e2) {
        if (this.editor == null) {
            return;
        }
        switch (e2.getKeyCode()) {
            case 10: {
                this.safeEndEdit(true);
                if (this.endEditFailed) break;
                e2.consume();
                this.fireActionEvent();
                break;
            }
            case 27: {
                this.safeEndEdit(false);
                e2.consume();
                break;
            }
            case 9: {
                Component c2;
                if (e2.isConsumed() || (c2 = this.getNextFocusableComponent()) == null) break;
                c2.requestFocus();
            }
        }
    }

    public void keyReleased(KeyEvent e2) {
    }

    protected void processKeyPressed(KeyEvent e2) {
        switch (e2.getKeyCode()) {
            case 10: {
                if (!e2.isControlDown() || this.editor != null || this.isReadOnly() || !this.writeModel.canSet(false)) break;
                this.startEdit();
                break;
            }
            case 113: {
                if (this.editor != null || this.isToggleItem() || this.isReadOnly() || !this.writeModel.canSet(false)) break;
                this.startEdit();
                break;
            }
            case 32: {
                if (!this.isToggleItem()) break;
                this.startEdit();
                e2.consume();
                break;
            }
            case 25: 
            case 229: {
                if (this.editor != null || this.isReadOnly() || !this.writeModel.canSet(false)) break;
                this.startEdit();
            }
        }
    }

    protected void processKeyTyped(KeyEvent e2) {
        Component eComp;
        char kChar = e2.getKeyChar();
        if (this.editor != null || !this.autoEdit || e2.isConsumed() || this.isReadOnly() || kChar == '\u0000' || kChar == '\t' || kChar == '\r' || kChar == '\n' || kChar == ' ' || kChar == '\u001b' || this.isToggleItem() || e2.isAltDown() ^ e2.isControlDown() || !this.writeModel.canSet(false)) {
            return;
        }
        this.startEdit();
        if (this.editor != null && (eComp = this.editor.getComponent()) != null) {
            eComp.dispatchEvent(e2);
        }
    }

    public void focusGained(FocusEvent e2) {
    }

    public void focusLost(FocusEvent e2) {
        this.state &= 0xFFFFFFFD;
        if (this.postOnFocusLost) {
            this.safeEndEdit(this.postOnEndEdit);
        }
    }

    protected void processFocusEvent(FocusEvent e2) {
        super.processFocusEvent(e2);
        switch (e2.getID()) {
            case 1004: {
                if (this.showFocus) {
                    this.state |= 2;
                }
                if (this.editor != null && this.editor.getComponent() != null) {
                    this.editor.getComponent().requestFocus();
                }
                this.state &= 0xFFFFFF7F;
                this.repaint();
                break;
            }
            case 1005: {
                this.state &= 0xFFFFFFFD;
                this.state |= 0x80;
                this.repaint();
            }
        }
    }

    protected void processMousePressed(MouseEvent e2) {
        super.processMousePressed(e2);
        if (e2.isConsumed()) {
            return;
        }
        this.state &= 0xFFFFFFBF;
        if (!e2.isMetaDown()) {
            if (this.selectable) {
                this.state = this.isSelected() ? (this.state &= 0xFFFFFFFC) : (this.state |= 4);
            }
            if ((this.state & 2) != 0 && this.editor == null && !this.isReadOnly() && this.writeModel.canSet(false)) {
                this.editClickPoint = new Point(e2.getX(), e2.getY());
                this.startEdit();
                return;
            }
            this.state |= 2;
            if (this.isToggleItem()) {
                this.editClickPoint = new Point(e2.getX(), e2.getY());
                this.startEdit();
            }
        }
        this.repaint();
    }

    protected Dimension getPreferredInnerSize(Object data) {
        Graphics g2 = this.getSiteGraphics();
        ItemPainter painter = this.getPainter(data);
        Dimension size = new Dimension(0, 0);
        if (painter != null) {
            size = painter.getPreferredSize(data, g2, this.state, this);
        }
        return size;
    }

    public JToolTip createToolTip() {
        return this.toolTip;
    }

    protected void processMouseEntered(MouseEvent e2) {
        if (this.showRollover) {
            this.state |= 0x40;
            this.repaint();
        }
        if (this.toolTip.active) {
            Object data = this.model != null ? this.model.get() : null;
            Dimension size = this.getPreferredInnerSize(data);
            Rectangle r = this.getInnerRect();
            if (!r.contains(size.width, size.height)) {
                String text = data != null ? data.toString() : Res._NullData;
                this.setToolTipText(text);
                this.toolTip.data = data;
                this.toolTip.painter = this.getPainter(data);
                this.toolTip.state = this.state;
                return;
            }
            this.toolTip.painter = null;
            this.setToolTipText(null);
        }
    }

    public Point getToolTipLocation(MouseEvent e2) {
        Rectangle r;
        if (this.toolTip.active && this.getToolTipText(e2) != null && (r = this.getInnerRect()) != null && this.model != null) {
            Object data;
            this.toolTip.data = data = this.model.get();
            this.toolTip.painter = this.getPainter(data);
            this.toolTip.state = this.state;
            return new Point(r.x, r.y);
        }
        this.toolTip.painter = null;
        return null;
    }

    protected void processMouseExited(MouseEvent e2) {
        if (this.showRollover) {
            this.state &= 0xFFFFFFBF;
            this.repaint();
        }
    }

    public boolean isEnabled() {
        return (this.state & 1) == 0;
    }

    public void setEnabled(boolean enabled) {
        this.state = enabled ? (this.state &= 0xFFFFFFFE) : (this.state |= 1);
        super.setEnabled(enabled);
    }

    protected ItemPainter getPainter(Object data) {
        ItemPainter painter;
        ItemPainter itemPainter = painter = this.viewManager != null ? this.viewManager.getPainter(data, this.state) : null;
        if (painter != null && this.customizeListeners != null) {
            this.customPainter.setPainter(painter);
            this.fireCustomizeItemEvent(data, this.state, this.customPainter);
            return this.customPainter;
        }
        return painter;
    }

    protected ItemEditor getEditor(Object data) {
        ItemEditor editor;
        ItemEditor itemEditor = editor = this.viewManager != null ? this.viewManager.getEditor(data, this.state) : null;
        if (editor != null && this.customizeListeners != null) {
            this.customEditor.setEditor(editor);
            this.fireCustomizeItemEvent(data, this.state, this.customEditor);
            return this.customEditor;
        }
        return editor;
    }

    public void modelContentChanged(SingletonModelEvent e2) {
        if (this.editor != null) {
            this.safeEndEdit(false);
        }
        this.repaint();
    }

    public Dimension getPreferredSize() {
        Graphics g2 = this.getSiteGraphics();
        Object data = this.model != null ? this.model.get() : null;
        ItemPainter painter = this.getPainter(data);
        Dimension size = painter != null ? painter.getPreferredSize(data, g2, this.state, this) : new Dimension(0, 0);
        Insets bin = this.getBorder() != null ? this.getBorder().getBorderInsets(this) : new Insets(0, 0, 0, 0);
        size.width += bin.left + bin.right;
        size.height += bin.top + bin.bottom;
        if (this.preferredHeight > size.height) {
            size.height = this.preferredHeight;
        }
        if (this.preferredWidth > size.width) {
            size.width = this.preferredWidth;
        }
        return size;
    }

    public void doLayout() {
        if (this.editor != null) {
            Rectangle r = this.outerRect();
            this.editor.changeBounds(r);
        }
    }

    public void setPreferredHeight(int preferredHeight) {
        this.preferredHeight = preferredHeight;
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    public void setPreferredWidth(int preferredWidth) {
        this.preferredWidth = preferredWidth;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public void addKeyListener(KeyListener l) {
        this.keyMulticaster.add(l);
    }

    public void removeKeyListener(KeyListener l) {
        this.keyMulticaster.remove(l);
    }

    private void fireActionEvent() {
        Object item = this.model != null ? this.model.get() : null;
        String action = item != null ? item.toString() : "";
        this.processActionEvent(new ActionEvent(this, 1001, action));
    }

    protected void fireCustomizeItemEvent(Object data, int state, CustomPaintSite cps) {
        if (this.customizeListeners != null) {
            cps.reset();
            for (int i2 = 0; i2 < this.customizeListeners.size(); ++i2) {
                ((CustomItemListener)this.customizeListeners.elementAt(i2)).customizeItem(null, data, state, cps);
            }
        }
    }

    public synchronized void addCustomItemListener(CustomItemListener l) {
        if (this.customizeListeners == null) {
            this.customizeListeners = new Vector();
        }
        this.customizeListeners.addElement(l);
    }

    public synchronized void removeCustomItemListener(CustomItemListener l) {
        if (this.customizeListeners != null) {
            this.customizeListeners.removeElement(l);
        }
        if (this.customizeListeners.size() == 0) {
            this.customizeListeners = null;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Hashtable<String, Object> hash = new Hashtable<String, Object>(2);
        if (this.model instanceof Serializable) {
            hash.put("m", this.model);
        }
        if (this.viewManager instanceof Serializable) {
            hash.put("v", this.viewManager);
        }
        s.writeObject(hash);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        Hashtable hash = (Hashtable)s.readObject();
        Object data = hash.get("m");
        if (data instanceof SingletonModel) {
            this.model = (SingletonModel)data;
        }
        if (this.model instanceof WritableSingletonModel) {
            this.writeModel = (WritableSingletonModel)this.model;
        }
        if ((data = hash.get("v")) instanceof SingletonViewManager) {
            this.viewManager = (SingletonViewManager)data;
        }
    }

    static {
        serialVersionUID = 200L;
    }
}

