/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.BevelPanel;
import com.borland.jbcl.control.ButtonControl;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.util.ActionMulticaster;
import com.borland.jbcl.util.BlackBox;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.util.MouseMotionMulticaster;
import com.borland.jbcl.util.MouseMulticaster;
import com.borland.jbcl.util.SerializableImage;
import com.borland.jbcl.view.BorderItemPainter;
import com.borland.jbcl.view.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.MediaTracker;
import java.awt.SystemColor;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class ButtonBar
extends BevelPanel
implements BlackBox,
Serializable {
    private static final long serialVersionUID = 200L;
    public static final int TEXT_ONLY = 1;
    public static final int IMAGE_ONLY = 2;
    public static final int TEXT_AND_IMAGE = 3;
    private transient Image[] images;
    private int buttonType = 3;
    private int buttonOrient = 1;
    private int buttonAlign = 34;
    private boolean imageFirst = true;
    private boolean showRollover = false;
    private String imageBase;
    private String[] labels = new String[0];
    private String[] imageNames = new String[0];
    private Vector buttons = new Vector();
    private boolean[] enabledState = new boolean[0];
    private boolean[] visibleState = new boolean[0];
    private MediaTracker mt;
    protected transient ActionMulticaster actionMulticaster = new ActionMulticaster();
    protected transient MouseMulticaster mouseMulticaster = new MouseMulticaster();
    protected transient MouseMotionMulticaster mouseMotionMulticaster = new MouseMotionMulticaster();
    protected BorderItemPainter border = new BorderItemPainter(2);
    protected boolean needsRebuild;

    public ButtonBar() {
        super.setLayout(new FlowLayout(0, 0, 0));
        super.setBackground(SystemColor.control);
        this.setMargins(new Insets(2, 2, 2, 2));
    }

    public void setLabels(String[] labels) {
        int i2;
        if (labels == null) {
            labels = new String[]{};
        }
        String[] s = new String[labels.length];
        System.arraycopy(labels, 0, s, 0, s.length);
        if (labels.length != this.enabledState.length) {
            boolean[] es = new boolean[labels.length];
            for (i2 = 0; i2 < labels.length; ++i2) {
                es[i2] = true;
            }
            this.enabledState = es;
        }
        if (labels.length != this.visibleState.length) {
            boolean[] vs = new boolean[labels.length];
            for (i2 = 0; i2 < labels.length; ++i2) {
                vs[i2] = true;
            }
            this.visibleState = vs;
        }
        this.labels = s;
        this.invalidateButtons();
    }

    public String[] getLabels() {
        String[] s = new String[this.labels.length];
        System.arraycopy(this.labels, 0, s, 0, s.length);
        return s;
    }

    public void setImageBase(String ib) {
        this.imageBase = ib;
        if (this.buttonType == 2 || this.buttonType == 3) {
            this.invalidateImages();
            this.invalidateButtons();
        }
    }

    public String getImageBase() {
        return this.imageBase;
    }

    public void setImageNames(String[] imageNames) {
        if (imageNames != null) {
            String[] s = new String[imageNames.length];
            System.arraycopy(imageNames, 0, s, 0, s.length);
            this.imageNames = s;
            if (this.buttonType == 2 || this.buttonType == 3) {
                this.invalidateImages();
                this.invalidateButtons();
            }
        }
    }

    public String[] getImageNames() {
        String[] s = new String[this.imageNames.length];
        System.arraycopy(this.imageNames, 0, s, 0, s.length);
        return s;
    }

    public void setButtonType(int buttonType) {
        if (buttonType == 1 || buttonType == 2 || buttonType == 3) {
            if (buttonType != this.buttonType) {
                this.buttonType = buttonType;
                this.invalidateButtons();
            }
        } else {
            throw new IllegalArgumentException(Res.bundle.format(36, String.valueOf(buttonType)));
        }
    }

    public int getButtonType() {
        return this.buttonType;
    }

    public void setButtonOrientation(int o) {
        this.buttonOrient = o;
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            ((ButtonControl)this.getComponent(i2)).setOrientation(this.buttonOrient);
            this.getComponent(i2).invalidate();
        }
    }

    public int getButtonOrientation() {
        return this.buttonOrient;
    }

    public void setOpaque(boolean opaque) {
        super.setOpaque(opaque);
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            ((ButtonControl)this.getComponent(i2)).setOpaque(opaque);
        }
    }

    public void setButtonAlignment(int a2) {
        this.buttonAlign = a2;
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            ((ButtonControl)this.getComponent(i2)).setAlignment(this.buttonAlign);
            this.getComponent(i2).invalidate();
        }
    }

    public int getButtonAlignment() {
        return this.buttonAlign;
    }

    public void setImageFirst(boolean first) {
        this.imageFirst = first;
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            ((ButtonControl)this.getComponent(i2)).setImageFirst(this.imageFirst);
        }
    }

    public boolean isImageFirst() {
        return this.imageFirst;
    }

    public void setShowRollover(boolean showRollover) {
        this.showRollover = showRollover;
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            ((ButtonControl)this.getComponent(i2)).setShowRollover(showRollover);
        }
    }

    public boolean isShowRollover() {
        return this.showRollover;
    }

    public int getAlignment() {
        LayoutManager layout = this.getLayout();
        if (layout instanceof FlowLayout) {
            return ((FlowLayout)layout).getAlignment();
        }
        return 0;
    }

    public void setAlignment(int alignment) {
        LayoutManager layout = this.getLayout();
        if (layout instanceof FlowLayout) {
            ((FlowLayout)layout).setAlignment(alignment);
        }
    }

    public int getHgap() {
        LayoutManager layout = this.getLayout();
        if (layout instanceof FlowLayout) {
            return ((FlowLayout)layout).getHgap();
        }
        if (layout instanceof GridLayout) {
            return ((GridLayout)layout).getHgap();
        }
        return 0;
    }

    public void setHgap(int gap) {
        LayoutManager layout = this.getLayout();
        if (layout instanceof FlowLayout) {
            ((FlowLayout)layout).setHgap(gap);
        } else if (layout instanceof GridLayout) {
            ((GridLayout)layout).setHgap(gap);
        }
    }

    public int getVgap() {
        LayoutManager layout = this.getLayout();
        if (layout instanceof FlowLayout) {
            return ((FlowLayout)layout).getVgap();
        }
        if (layout instanceof GridLayout) {
            return ((GridLayout)layout).getVgap();
        }
        return 0;
    }

    public void setVgap(int gap) {
        LayoutManager layout = this.getLayout();
        if (layout instanceof FlowLayout) {
            ((FlowLayout)layout).setVgap(gap);
        } else if (layout instanceof GridLayout) {
            ((GridLayout)layout).setVgap(gap);
        }
    }

    public void setButtonEnabled(int index, boolean enabled) {
        Object object;
        if (index < 0 || index >= this.enabledState.length) {
            throw new IllegalArgumentException();
        }
        if (!this.needsRebuild && this.isEnabled() && (object = this.buttons.elementAt(index)) instanceof ButtonControl) {
            ((ButtonControl)object).setEnabled(enabled);
        }
        this.enabledState[index] = enabled;
    }

    public boolean isButtonEnabled(int index) {
        Object object;
        if (index < 0 || index >= this.enabledState.length) {
            throw new IllegalArgumentException();
        }
        if (!this.needsRebuild && (object = this.buttons.elementAt(index)) instanceof ButtonControl) {
            return ((ButtonControl)object).isEnabled();
        }
        return false;
    }

    public void setButtonVisible(int index, boolean visible) {
        Object object;
        if (index < 0 || index >= this.visibleState.length) {
            throw new IllegalArgumentException();
        }
        if (!this.needsRebuild && (object = this.buttons.elementAt(index)) instanceof ButtonControl) {
            ((ButtonControl)object).setVisible(visible);
        }
        this.visibleState[index] = visible;
    }

    public boolean isButtonVisible(int index) {
        Object object;
        if (index < 0 || index >= this.visibleState.length) {
            throw new IllegalArgumentException();
        }
        if (!this.needsRebuild && (object = this.buttons.elementAt(index)) instanceof ButtonControl) {
            return ((ButtonControl)object).isVisible();
        }
        return false;
    }

    public void setButtonEnabled(String label, boolean enabled) {
        for (int i2 = 0; i2 < this.labels.length; ++i2) {
            if (!this.labels[i2].equals(label)) continue;
            this.setButtonEnabled(i2, enabled);
            return;
        }
    }

    public boolean isButtonEnabled(String label) {
        for (int i2 = 0; i2 < this.labels.length; ++i2) {
            if (!this.labels[i2].equals(label)) continue;
            return this.isButtonEnabled(i2);
        }
        return false;
    }

    public void setButtonVisible(String label, boolean visible) {
        for (int i2 = 0; i2 < this.labels.length; ++i2) {
            if (!this.labels[i2].equals(label)) continue;
            this.setButtonVisible(i2, visible);
            return;
        }
    }

    public boolean isButtonVisible(String label) {
        for (int i2 = 0; i2 < this.labels.length; ++i2) {
            if (!this.labels[i2].equals(label)) continue;
            return this.isButtonVisible(i2);
        }
        return false;
    }

    public synchronized void addActionListener(ActionListener l) {
        this.actionMulticaster.add(l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.actionMulticaster.remove(l);
    }

    protected void invalidateButtons() {
        this.needsRebuild = true;
        this.invalidate();
    }

    protected void invalidateImages() {
        if (this.images != null) {
            this.images = null;
        }
        if (this.imageNames.length > 0) {
            this.images = new Image[this.imageNames.length];
            this.mt = new MediaTracker(this);
            String prefix = this.imageBase;
            if (prefix != null && prefix.length() > 0 && !prefix.endsWith("/") && !prefix.endsWith(File.separator)) {
                prefix = String.valueOf(String.valueOf(prefix)).concat("/");
            }
            for (int i2 = 0; i2 < this.imageNames.length; ++i2) {
                String name = prefix != null ? String.valueOf(String.valueOf(prefix)).concat(String.valueOf(String.valueOf(this.imageNames[i2]))) : this.imageNames[i2];
                this.images[i2] = ImageLoader.loadFromResource(name, this);
                if (this.images[i2] != null) continue;
                try {
                    this.images[i2] = ImageLoader.load(new URL(name), (Component)this, true);
                }
                catch (MalformedURLException e2) {
                    this.images[i2] = ImageLoader.load(name, (Component)this, true);
                }
                if (this.images[i2] == null) continue;
                this.mt.addImage(this.images[i2], i2);
            }
            this.mt.checkAll(true);
            try {
                this.mt.waitForAll(0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void assureImages() {
        if (this.mt != null) {
            try {
                this.mt.waitForAll(0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mt = null;
        }
    }

    protected void rebuild() {
        if (this.needsRebuild) {
            this.removeAll();
            this.assureImages();
            this.buttons.removeAllElements();
            for (int i2 = 0; i2 < this.labels.length; ++i2) {
                if (this.labels[i2] != null && this.labels[i2].length() > 0) {
                    if (this.buttonType == 1 || this.imageNames == null || i2 >= this.imageNames.length) {
                        this.addTextButton(this.labels[i2], this.labels[i2]);
                    } else if (this.buttonType == 3) {
                        this.addImageButton(this.images[i2], this.labels[i2], this.labels[i2]);
                    } else {
                        this.addImageButton(this.images[i2], null, this.labels[i2]);
                    }
                    if (this.isEnabled()) {
                        ((ButtonControl)this.buttons.elementAt(i2)).setEnabled(this.enabledState[i2]);
                    } else {
                        ((ButtonControl)this.buttons.elementAt(i2)).setEnabled(false);
                    }
                    ((ButtonControl)this.buttons.elementAt(i2)).setVisible(this.visibleState[i2]);
                    continue;
                }
                this.addSpace();
            }
            this.needsRebuild = false;
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.needsRebuild = true;
        this.doLayout();
    }

    public void doLayout() {
        this.rebuild();
        super.doLayout();
    }

    public Dimension getPreferredSize() {
        this.rebuild();
        Dimension d2 = super.getPreferredSize();
        if (d2.height == 150) {
            d2.height = 32;
        }
        return d2;
    }

    public void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        this.mouseMulticaster.add(l);
    }

    public void removeMouseListener(MouseListener l) {
        super.removeMouseListener(l);
        this.mouseMulticaster.remove(l);
    }

    public void addMouseMotionListener(MouseMotionListener l) {
        super.addMouseMotionListener(l);
        this.mouseMotionMulticaster.add(l);
    }

    public void removeMouseMotionListener(MouseMotionListener l) {
        super.removeMouseMotionListener(l);
        this.mouseMotionMulticaster.remove(l);
    }

    protected Component addImageButton(Image image, String label, String command) {
        ButtonControl button = new ButtonControl(image);
        if (label != null) {
            button.setLabel(label);
        }
        button.setActionCommand(command);
        button.addActionListener(this.actionMulticaster);
        button.addMouseListener(this.mouseMulticaster);
        button.addMouseMotionListener(this.mouseMotionMulticaster);
        button.setFocusAware(false);
        button.setShowRollover(this.showRollover);
        button.setOrientation(this.buttonOrient);
        button.setAlignment(this.buttonAlign);
        button.setOpaque(this.isOpaque());
        button.setImageFirst(this.imageFirst);
        this.buttons.addElement(button);
        this.invalidate();
        return this.add(button);
    }

    protected Component addTextButton(String label, String command) {
        ButtonControl button = new ButtonControl();
        button.setLabel(label);
        button.setActionCommand(command);
        button.addActionListener(this.actionMulticaster);
        button.addMouseListener(this.mouseMulticaster);
        button.addMouseMotionListener(this.mouseMotionMulticaster);
        button.setFocusAware(false);
        button.setShowRollover(this.showRollover);
        button.setOrientation(this.buttonOrient);
        button.setAlignment(this.buttonAlign);
        button.setOpaque(this.isOpaque());
        button.setImageFirst(this.imageFirst);
        this.buttons.addElement(button);
        this.invalidate();
        return this.add(button);
    }

    protected Component addSpace() {
        this.invalidate();
        return this.addSpace(5);
    }

    protected Component addSpace(int gap) {
        Spacer space = new Spacer(gap);
        this.buttons.addElement(space);
        this.repaint(100L);
        this.invalidate();
        return super.add(space);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.images != null && this.images.length > 0) {
            SerializableImage[] si = new SerializableImage[this.images.length];
            for (int i2 = 0; i2 < this.images.length; ++i2) {
                si[i2] = SerializableImage.create(this.images[i2]);
            }
            s.writeObject(si);
        } else {
            s.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        Object data = s.readObject();
        if (data instanceof SerializableImage[]) {
            SerializableImage[] si = (SerializableImage[])data;
            this.images = new Image[si.length];
            for (int i2 = 0; i2 < si.length; ++i2) {
                this.images[i2] = si[i2].getImage();
            }
        }
    }

    static {
        serialVersionUID = 200L;
        TEXT_ONLY = 1;
        IMAGE_ONLY = 2;
        TEXT_AND_IMAGE = 3;
    }
}

