/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.ut;

import com.syscom.ut.Address_array;
import com.syscom.ut.DbaUtDef;
import com.syscom.ut.Logical_file;
import com.syscom.ut.String_array;
import dbaut.dbalib;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;

public class JdmConfig {
    public static final String CONFIG_FILE = "dmconfig.ini";
    public static final String DEFAULT_BACKUP_DIR = "backup";
    public static final String USER_DIR = System.getProperty("user.dir");
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final int FILE_SEPARATOR_LEN = FILE_SEPARATOR.length();
    public static final String OFFLINE_DIR = "offline";
    private dbalib cfun = new dbalib();
    private long[] handle = null;
    private static final int LEN_FNAME = 256;
    private static final int DB_MAX_NMSTR = 8;
    public static String localHostName = null;
    public static String localIpAddress = null;
    public static boolean isFileLock = false;

    public JdmConfig() {
        if (localHostName == null && localIpAddress == null) {
            this.initialLocalHostInfo();
        }
    }

    public static synchronized int copyDBSection(String string, String string2, String string3) {
        dbalib dbalib2 = new dbalib();
        int n = dbalib2.procCopySection(string.getBytes(), string2.getBytes(), string3.getBytes());
        if (n != 0) {
            System.out.println("Copy database section failed! rc=" + n);
        }
        return n;
    }

    public static synchronized String getDBDir(String string) {
        if (string == null) {
            return "";
        }
        JdmConfig jdmConfig = new JdmConfig();
        int n = jdmConfig.fileOpen(CONFIG_FILE, string, "r");
        if (n != 0) {
            return "";
        }
        String string2 = (String)jdmConfig.getPara("DB_DBDIR", 4096);
        jdmConfig.fileClose();
        if (string2 != null && string2.length() > 0) {
            return string2.trim();
        }
        return "";
    }

    public static synchronized String getOfflineBackupDir(String string) {
        String string2 = null;
        JdmConfig jdmConfig = new JdmConfig();
        int n = jdmConfig.fileOpen(CONFIG_FILE, string, "r");
        if (n != DbaUtDef.RTN_OK) {
            System.out.println("Open dmconfig.ini error " + n);
            return null;
        }
        String_array string_array = (String_array)jdmConfig.getPara("DB_BKDIR", 53504);
        if (string_array != null && string_array.content.length > 0) {
            string2 = string_array.content[0].toString().trim();
            if (!string2.startsWith("/") && !string2.startsWith("\\\\") && string2.indexOf(":") <= 0) {
                String string3 = (String)jdmConfig.getPara("DB_DBDIR", 4096);
                if (string3 == null || string3.length() == 0) {
                    string3 = USER_DIR;
                }
                string2 = string3.endsWith(FILE_SEPARATOR) ? string3 + string2 : string3 + FILE_SEPARATOR + string2;
            }
        } else {
            String string4 = (String)jdmConfig.getPara("DB_DBDIR", 4096);
            if (string4 == null || string4.length() == 0) {
                string4 = USER_DIR;
            }
            string2 = string4.endsWith(FILE_SEPARATOR) ? string4 + DEFAULT_BACKUP_DIR : string4 + FILE_SEPARATOR + DEFAULT_BACKUP_DIR;
        }
        jdmConfig.fileClose();
        string2 = string2.endsWith(FILE_SEPARATOR) ? string2 + OFFLINE_DIR : string2 + FILE_SEPARATOR + OFFLINE_DIR;
        return string2;
    }

    public static synchronized String getOnlineBackupDir(String string) {
        String string2 = null;
        JdmConfig jdmConfig = new JdmConfig();
        int n = jdmConfig.fileOpen(CONFIG_FILE, string, "r");
        if (n != DbaUtDef.RTN_OK) {
            System.out.println("Open dmconfig.ini error " + n);
            return null;
        }
        String_array string_array = (String_array)jdmConfig.getPara("DB_BKDIR", 53504);
        if (string_array != null && string_array.content.length > 0) {
            string2 = string_array.content[0].toString().trim();
            if (!string2.startsWith("/") && !string2.startsWith("\\\\") && string2.indexOf(":") <= 0) {
                String string3 = (String)jdmConfig.getPara("DB_DBDIR", 4096);
                if (string3 == null || string3.length() == 0) {
                    string3 = USER_DIR;
                }
                string2 = string3.endsWith(FILE_SEPARATOR) ? string3 + string2 : string3 + FILE_SEPARATOR + string2;
            }
        } else {
            String string4 = (String)jdmConfig.getPara("DB_DBDIR", 4096);
            if (string4 == null || string4.length() == 0) {
                string4 = USER_DIR;
            }
            string2 = string4.endsWith(FILE_SEPARATOR) ? string4 + DEFAULT_BACKUP_DIR : string4 + FILE_SEPARATOR + DEFAULT_BACKUP_DIR;
        }
        jdmConfig.fileClose();
        return string2;
    }

    public static synchronized String getOnlineBackupDir(String string, String string2) {
        String string3 = null;
        JdmConfig jdmConfig = new JdmConfig();
        int n = jdmConfig.fileOpen(string, string2, "r");
        if (n != DbaUtDef.RTN_OK) {
            System.out.println("Open " + string + " error " + n);
            return null;
        }
        String_array string_array = (String_array)jdmConfig.getPara("DB_BKDIR", 53504);
        if (string_array != null && string_array.content.length > 0) {
            string3 = string_array.content[0].toString().trim();
            if (!string3.startsWith("/") && !string3.startsWith("\\\\") && string3.indexOf(":") <= 0) {
                String string4 = (String)jdmConfig.getPara("DB_DBDIR", 4096);
                if (string4 == null || string4.length() == 0) {
                    string4 = USER_DIR;
                }
                string3 = string4.endsWith(FILE_SEPARATOR) ? string4 + string3 : string4 + FILE_SEPARATOR + string3;
            }
        } else {
            String string5 = (String)jdmConfig.getPara("DB_DBDIR", 4096);
            if (string5 == null || string5.length() == 0) {
                string5 = USER_DIR;
            }
            string3 = string5.endsWith(FILE_SEPARATOR) ? string5 + DEFAULT_BACKUP_DIR : string5 + FILE_SEPARATOR + DEFAULT_BACKUP_DIR;
        }
        jdmConfig.fileClose();
        return string3;
    }

    public static synchronized String getOnlineBackupDir(String string, Connection connection) throws SQLException {
        String string2 = null;
        CallableStatement callableStatement = connection.prepareCall("{call GETSYSTEMOPTION('bkdir', ?)}");
        callableStatement.registerOutParameter(1, 12);
        callableStatement.executeQuery();
        string2 = callableStatement.getString(1);
        callableStatement.close();
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim()).length() == 0) {
            return null;
        }
        char c = string2.charAt(0);
        if (c == '\"') {
            String string3 = string2.substring(1);
            if (string3.startsWith("/") || string3.startsWith("\\\\") || string3.indexOf(":") == 1) {
                int n = string3.indexOf("\"");
                if (n != -1) {
                    string2 = string2.substring(1, n + 1);
                }
            } else {
                JdmConfig jdmConfig;
                int n;
                int n2 = string3.indexOf("\"");
                if (n2 != -1) {
                    string2 = string2.substring(1, n2 + 1);
                }
                if ((n = (jdmConfig = new JdmConfig()).fileOpen(CONFIG_FILE, string, "r")) != DbaUtDef.RTN_OK) {
                    System.out.println("Open dmconfig.ini error " + n);
                    return null;
                }
                String string4 = (String)jdmConfig.getPara("DB_DBDIR", 4096);
                if (string4 == null || string4.length() == 0) {
                    string4 = USER_DIR;
                }
                string2 = string4.endsWith(FILE_SEPARATOR) ? string4 + string2 : string4 + FILE_SEPARATOR + string2;
            }
        } else if (string2.startsWith("/") || string2.startsWith("\\\\") || string2.indexOf(":") == 1) {
            int n = string2.indexOf(" ");
            if (n != -1) {
                string2 = string2.substring(0, n);
            }
        } else {
            JdmConfig jdmConfig;
            int n;
            int n3 = string2.indexOf(" ");
            if (n3 != -1) {
                string2 = string2.substring(0, n3);
            }
            if ((n = (jdmConfig = new JdmConfig()).fileOpen(CONFIG_FILE, string, "r")) != DbaUtDef.RTN_OK) {
                System.out.println("Open dmconfig.ini error " + n);
                return null;
            }
            String string5 = (String)jdmConfig.getPara("DB_DBDIR", 4096);
            if (string5 == null || string5.length() == 0) {
                string5 = USER_DIR;
            }
            string2 = string5.endsWith(FILE_SEPARATOR) ? string5 + string2 : string5 + FILE_SEPARATOR + string2;
        }
        if (string2 != null && string2.indexOf(":") != 1 && string2.endsWith(FILE_SEPARATOR)) {
            string2 = string2.substring(0, string2.lastIndexOf(FILE_SEPARATOR));
        }
        return string2;
    }

    public static synchronized String getDefaultUser(String string) {
        String string2 = JdmConfig.getUserId(string);
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        return "SYSADM";
    }

    public static synchronized Vector getDatabaseNames(String string, boolean bl) {
        return JdmConfig.getDatabaseNames(string, bl, false);
    }

    public static synchronized Vector getDatabaseNames(String string, boolean bl, boolean bl2) {
        int n;
        JdmConfig jdmConfig = new JdmConfig();
        Vector vector = jdmConfig.fileScan(string);
        if (vector == null) {
            return new Vector();
        }
        int n2 = 0;
        int n3 = -1;
        while (n2 < vector.size()) {
            String string2 = (String)vector.elementAt(n2);
            if (bl && !jdmConfig.isLocalHost(string, string2)) {
                vector.removeElementAt(n2);
                continue;
            }
            if (bl2 && jdmConfig.isTerminalServer(string, string2)) {
                vector.removeElementAt(n2);
                continue;
            }
            while ((n3 = vector.indexOf(string2, n2 + 1)) > 0) {
                vector.removeElementAt(n3);
            }
            ++n2;
        }
        String string3 = null;
        for (int i = n = vector.size(); i >= 1; --i) {
            for (int j = 1; j < i; ++j) {
                String string4 = (String)vector.elementAt(j - 1);
                if (string4.compareToIgnoreCase(string3 = (String)vector.elementAt(j)) <= 0) continue;
                vector.setElementAt(string3, j - 1);
                vector.setElementAt(string4, j);
            }
        }
        return vector;
    }

    public void initialLocalHostInfo() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            String string = inetAddress.toString();
            int n = string.indexOf("/");
            int n2 = string.length();
            if (n > 0) {
                localHostName = string.substring(0, n);
                localIpAddress = string.substring(n + 1, n2);
            } else {
                int n3 = string.indexOf(".");
                if (n3 > 0) {
                    localHostName = "";
                    localIpAddress = string;
                } else {
                    localHostName = string;
                    localIpAddress = "";
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println(unknownHostException.getMessage());
        }
    }

    public synchronized boolean isLocalHost(String string) {
        return this.isLocalHost(CONFIG_FILE, string);
    }

    public synchronized boolean isLocalHost(String string, String string2) {
        int n = this.fileOpen(string, string2, "r");
        if (n != 0) {
            return false;
        }
        String string3 = (String)this.getPara("DB_SVADR", 4096);
        this.fileClose();
        return string3 == null || string3.equalsIgnoreCase(localHostName) || string3.equalsIgnoreCase("localhost") || string3.equalsIgnoreCase(localIpAddress) || string3.equalsIgnoreCase("127.0.0.1");
    }

    public synchronized boolean isTerminalServer(String string) {
        return this.isTerminalServer(CONFIG_FILE, string);
    }

    public synchronized boolean isTerminalServer(String string, String string2) {
        int n = this.fileOpen(string, string2, "r");
        if (n != 0) {
            return true;
        }
        String string3 = (String)this.getPara("DB_SVADR", 4096);
        this.fileClose();
        return string3 == null || string3.length() <= 0;
    }

    public synchronized String filePath(String string) {
        byte[] byArray = new byte[2048];
        int n = this.cfun.procFilePath(string.getBytes(), byArray);
        return new String(byArray).trim();
    }

    public synchronized Vector fileScan(String string) {
        int[] nArray = new int[1];
        byte[] byArray = null;
        int n = 100;
        int n2 = 0;
        while (true) {
            nArray[0] = n;
            byArray = new byte[n * 129];
            n2 = this.cfun.procFileScan(string.getBytes(), byArray, nArray, 0);
            if (n2 != 0) {
                return null;
            }
            if (nArray[0] == 0) {
                return null;
            }
            if (nArray[0] != n) break;
            n *= 10;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < nArray[0]; ++i) {
            String string2 = new String(byArray, i * 129, 129).trim();
            if (string2.compareTo("DM_COMMON_OPTION") == 0) continue;
            vector.addElement(string2.trim());
        }
        return vector;
    }

    public synchronized int create(String string, String string2) {
        int n = this.cfun.procCreate(string.getBytes(), string2.getBytes());
        if (n != 0) {
            System.out.println("Error procCreate new section " + string2 + " in config file " + string);
        }
        return n;
    }

    public static synchronized String getUserId(String string) {
        JdmConfig jdmConfig = new JdmConfig();
        int n = jdmConfig.fileOpen(CONFIG_FILE, string, "r");
        String string2 = null;
        if (n == 0) {
            string2 = (String)jdmConfig.getPara("DB_USRID", 4096);
            jdmConfig.fileClose();
        } else {
            System.out.println("Error open dmconfig.ini via JdmConfig");
        }
        return string2;
    }

    public synchronized int fileOpen(String string, String string2, String string3) {
        this.handle = new long[2];
        byte[] byArray = new byte[2048];
        if (string3.equals("r+") && isFileLock) {
            return -1;
        }
        int n = this.cfun.procFileOpen(this.handle, byArray, string.getBytes(), string2.getBytes(), string3.getBytes());
        if (n != 0) {
            System.out.println("Error procFileOpen section " + string2 + " in config file " + string);
        } else if (string3.equals("r+")) {
            isFileLock = true;
        }
        return n;
    }

    public synchronized Object getPara(String string, int n) {
        return this.getPara(string, n, 0);
    }

    public synchronized Object getPara(String string, int n, int n2) {
        if (this.handle == null) {
            System.out.println("handle is null, fileOpen is required.");
            return null;
        }
        Object object = null;
        int n3 = 0;
        switch (n) {
            case 53760: {
                byte[] byArray = new byte[256];
                byte[] byArray2 = new byte[256];
                int[] nArray = new int[1];
                n3 = this.cfun.procGetParaFile(this.handle, string.getBytes(), byArray, byArray2, nArray);
                if (n3 != 0) break;
                object = new Logical_file(string, new String(byArray, 0, 256).trim(), new String(byArray2, 0, 256).trim(), nArray[0]);
                break;
            }
            case 8192: 
            case 40960: 
            case 50176: {
                int[] nArray = new int[1];
                n3 = this.cfun.procGetParaInt(this.handle, string.getBytes(), nArray, n);
                if (n3 == 0) {
                    if (n == 8192) {
                        object = new Integer(nArray[0]);
                        break;
                    }
                    if (n == 40960) {
                        object = new Boolean(nArray[0] == 1);
                        break;
                    }
                    if (n != 50176) break;
                    object = new Integer(nArray[0]);
                    break;
                }
                System.out.println("procGetParaInt return rc = " + n3);
                break;
            }
            case 45056: {
                long[] lArray = new long[1];
                n3 = this.cfun.procGetParaLong(this.handle, string.getBytes(), lArray, n);
                if (n3 != 0) break;
                object = new Long(lArray[0]);
                break;
            }
            case 37120: {
                byte[] byArray = new byte[65536];
                int[] nArray = new int[256];
                n3 = this.cfun.procGetParaAdrArray(this.handle, string.getBytes(), byArray, nArray);
                if (n3 != 0) break;
                String[] stringArray = new String[256];
                for (int i = 0; i < 256; ++i) {
                    stringArray[i] = new String(byArray, i * 256, 256).trim();
                }
                object = new Address_array(stringArray, nArray);
                break;
            }
            case 49152: 
            case 49408: 
            case 49664: {
                if (n2 <= 0) {
                    n2 = 256;
                }
                byte[] byArray = new byte[n2];
                n3 = this.cfun.procGetPara(this.handle, string.getBytes(), byArray, n, n2);
                if (n3 != 0) break;
                object = new String(byArray, 0, n2).trim();
                break;
            }
            case 51200: {
                if (n2 <= 0) {
                    n2 = 1024;
                }
                byte[] byArray = new byte[n2];
                n3 = this.cfun.procGetPara(this.handle, string.getBytes(), byArray, n, n2);
                if (n3 != 0) break;
                object = new String(byArray, 0, n2).trim();
                break;
            }
            case 53504: {
                int n4 = 8;
                if (string.equalsIgnoreCase("DB_BKDIR") || string.equalsIgnoreCase("DB_BKODR")) {
                    n2 = 16384;
                    n4 = 64;
                } else {
                    n2 = 2048;
                    n4 = 8;
                }
                byte[] byArray = new byte[n2];
                n3 = this.cfun.procGetPara(this.handle, string.getBytes(), byArray, n, n2);
                if (n3 != 0) break;
                String[] stringArray = new String[n4];
                for (int i = 0; i < n4; ++i) {
                    stringArray[i] = new String(byArray, i * 256, 256).trim();
                }
                object = new String_array(stringArray);
                break;
            }
            default: {
                if (n2 <= 0) {
                    n2 = 1024;
                }
                byte[] byArray = new byte[n2];
                n3 = this.cfun.procGetPara(this.handle, string.getBytes(), byArray, 4096, n2);
                if (n3 != 0) break;
                object = new String(byArray, 0, n2).trim();
            }
        }
        if (n3 != 0) {
            return null;
        }
        return object;
    }

    public synchronized int fileClose() {
        int n = this.cfun.procFileClose(this.handle);
        this.handle = null;
        isFileLock = false;
        return n;
    }

    public synchronized int insertPara(String string, Object object, int n) {
        if (this.handle == null) {
            System.out.println("handle is null, fileOpen is required.");
            return -1;
        }
        if (object == null) {
            System.out.println("insert parameter value is null");
            return -2;
        }
        int n2 = 0;
        switch (n) {
            case 8192: {
                Integer n3 = new Integer(object.toString());
                int n4 = n3;
                n2 = this.cfun.procInsertInt(this.handle, string.getBytes(), n4, n);
                break;
            }
            case 40960: {
                int n5 = (Boolean)object != false ? 1 : 0;
                n2 = this.cfun.procInsertInt(this.handle, string.getBytes(), n5, 8192);
                break;
            }
            case 53760: {
                String string2 = ((Logical_file)object).getFilename();
                if (string2.indexOf(" ") > 0 && !string2.startsWith("\"")) {
                    string2 = "\"" + string2 + "\"";
                }
                String string3 = ((Logical_file)object).getPagenum();
                int n6 = ((Logical_file)object).getOffset();
                n2 = this.cfun.procInsertFile(this.handle, string.getBytes(), string2.getBytes(), string3.getBytes(), n6);
                break;
            }
            case 53504: {
                if (!(object instanceof String_array)) break;
                String_array string_array = (String_array)object;
                byte[] byArray = string_array.toBytes();
                int n7 = string_array.sizeInByte();
                n2 = this.cfun.procInsert(this.handle, string.getBytes(), byArray, 53504, ((String_array)object).size());
                break;
            }
            default: {
                String string4 = object.toString();
                byte[] byArray = string4.getBytes();
                n2 = this.cfun.procInsert(this.handle, string.getBytes(), byArray, n, byArray.length);
            }
        }
        return n2;
    }

    public synchronized String getFormatBackupName(String string, int n, String string2, int n2) {
        byte[] byArray = new byte[256];
        byte[] byArray2 = string.getBytes();
        int n3 = byArray2.length;
        int n4 = this.cfun.getFormatBackupName(byArray2, n3, n, string2.getBytes(), byArray, n2);
        String string3 = new String(byArray).trim();
        if (n4 == 0) {
            return new String(byArray).trim();
        }
        return null;
    }

    public synchronized int procDelete(String string, int n) {
        if (this.handle == null) {
            return -1;
        }
        int n2 = this.cfun.procDelete(this.handle, string.getBytes(), n);
        return n2;
    }

    public static void setTerminalServer(boolean bl, String string, String string2, Integer n) {
        JdmConfig jdmConfig = new JdmConfig();
        if (bl) {
            int n2 = jdmConfig.fileOpen(CONFIG_FILE, string, "r+");
            if (n2 != 0) {
                return;
            }
            jdmConfig.procDelete("DB_SVADR", 0);
            jdmConfig.procDelete("DB_PTNUM", 0);
            jdmConfig.fileClose();
            System.out.println("set terminal server on!");
        } else {
            int n3 = jdmConfig.fileOpen(CONFIG_FILE, string, "r+");
            if (n3 != 0) {
                return;
            }
            jdmConfig.insertPara("DB_SVADR", string2, 4096);
            jdmConfig.insertPara("DB_PTNUM", n, 8192);
            jdmConfig.fileClose();
            System.out.println("set terminal server off!");
        }
    }

    public static String[] getBkdirStringArray(String string) {
        String[] stringArray = null;
        ArrayList arrayList = JdmConfig.parseBkdir(string);
        if (arrayList != null && arrayList.size() != 0) {
            stringArray = new String[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                stringArray[i] = String.valueOf(arrayList.get(i));
            }
        }
        return stringArray;
    }

    private static ArrayList parseBkdir(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (string.length() != 0) {
            int n = string.indexOf("\"");
            if (n == 0) {
                int n2 = string.indexOf("\"", 1);
                String string2 = string.substring(1, n2);
                arrayList.add(string2);
                string = string.substring(n2 + 1);
                continue;
            }
            if (n > 0) {
                String string3 = string.substring(0, n);
                String[] stringArray = string3.split("\\s");
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].trim().length() <= 0) continue;
                    arrayList.add(stringArray[i]);
                }
                string = string.substring(n);
                continue;
            }
            String[] stringArray = string.split("\\s");
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].trim().length() <= 0) continue;
                arrayList.add(stringArray[i]);
            }
            string = "";
        }
        return arrayList;
    }

    public static boolean isLegalBkdir(String string) {
        boolean bl = true;
        ArrayList arrayList = JdmConfig.parseBkdir(string);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (i % 2 == 0) {
                String string2 = (String)arrayList.get(i);
                File file = new File(string2);
                if (file.exists()) {
                    if (file.isDirectory()) {
                        bl = true;
                        continue;
                    }
                    bl = false;
                    continue;
                }
                bl = file.mkdirs();
                if (!bl) continue;
                file.delete();
                continue;
            }
            try {
                int n2 = Integer.parseInt((String)arrayList.get(i));
                if (n2 != -1 && n2 < 0) continue;
                bl = true;
                continue;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }
}

