/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoderImpl;
import com.sun.media.jai.codec.PNMEncodeParam;
import com.sun.media.jai.codecimpl.JaiI18N;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public class PNMImageEncoder
extends ImageEncoderImpl {
    private static final int PBM_ASCII = 49;
    private static final int PGM_ASCII = 50;
    private static final int PPM_ASCII = 51;
    private static final int PBM_RAW = 52;
    private static final int PGM_RAW = 53;
    private static final int PPM_RAW = 54;
    private static final int SPACE = 32;
    private static final String COMMENT = "# written by com.sun.media.jai.codecimpl.PNMImageEncoder";
    private byte[] lineSeparator;
    private int variant;
    private int maxValue;

    public PNMImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
        if (this.param == null) {
            this.param = new PNMEncodeParam();
        }
    }

    public void encode(RenderedImage renderedImage) throws IOException {
        int n;
        Object object;
        int n2 = renderedImage.getMinX();
        int n3 = renderedImage.getMinY();
        int n4 = renderedImage.getWidth();
        int n5 = renderedImage.getHeight();
        SampleModel sampleModel = renderedImage.getSampleModel();
        ColorModel colorModel = renderedImage.getColorModel();
        String string = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        this.lineSeparator = string.getBytes();
        int n6 = sampleModel.getTransferType();
        if (n6 == 4 || n6 == 5) {
            throw new RuntimeException(JaiI18N.getString("PNMImageEncoder0"));
        }
        int[] nArray = sampleModel.getSampleSize();
        int n7 = sampleModel.getNumBands();
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        if (n7 == 1) {
            if (colorModel instanceof IndexColorModel) {
                this.variant = 54;
                object = (IndexColorModel)colorModel;
                n = ((IndexColorModel)object).getMapSize();
                if (n < 1 << nArray[0]) {
                    throw new RuntimeException(JaiI18N.getString("PNMImageEncoder1"));
                }
                byArray = new byte[n];
                byArray2 = new byte[n];
                byArray3 = new byte[n];
                ((IndexColorModel)object).getReds(byArray);
                ((IndexColorModel)object).getGreens(byArray2);
                ((IndexColorModel)object).getBlues(byArray3);
            } else {
                this.variant = nArray[0] == 1 ? 52 : (nArray[0] <= 8 ? 53 : 50);
            }
        } else if (n7 == 3) {
            this.variant = nArray[0] <= 8 && nArray[1] <= 8 && nArray[2] <= 8 ? 54 : 51;
        } else {
            throw new RuntimeException(JaiI18N.getString("PNMImageEncoder2"));
        }
        if (((PNMEncodeParam)this.param).getRaw()) {
            if (!this.isRaw(this.variant)) {
                boolean bl = true;
                n = 0;
                while (n < nArray.length) {
                    if (nArray[n] > 8) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
                if (bl) {
                    this.variant += 3;
                }
            }
        } else if (this.isRaw(this.variant)) {
            this.variant -= 3;
        }
        this.maxValue = (1 << nArray[0]) - 1;
        this.output.write(80);
        this.output.write(this.variant);
        this.output.write(this.lineSeparator);
        this.output.write(COMMENT.getBytes());
        this.output.write(this.lineSeparator);
        this.writeInteger(this.output, n4);
        this.output.write(32);
        this.writeInteger(this.output, n5);
        if (this.variant != 52 && this.variant != 49) {
            this.output.write(this.lineSeparator);
            this.writeInteger(this.output, this.maxValue);
        }
        if (this.variant == 52 || this.variant == 53 || this.variant == 54) {
            this.output.write(10);
        }
        object = new int[8 * n4 * n7];
        byte[] byArray4 = byArray == null ? new byte[8 * n4 * n7] : new byte[8 * n4 * 3];
        int n8 = 0;
        int n9 = n3 + n5;
        int n10 = n3;
        while (n10 < n9) {
            int n11 = Math.min(8, n9 - n10);
            int n12 = n11 * n4 * n7;
            Raster raster = renderedImage.getData(new Rectangle(n2, n10, n4, n11));
            raster.getPixels(n2, n10, n4, n11, (int[])object);
            switch (this.variant) {
                case 49: 
                case 50: {
                    int n13 = 0;
                    while (n13 < n12) {
                        if (n8++ % 16 == 0) {
                            this.output.write(this.lineSeparator);
                        } else {
                            this.output.write(32);
                        }
                        this.writeInteger(this.output, (int)object[n13]);
                        ++n13;
                    }
                    this.output.write(this.lineSeparator);
                    break;
                }
                case 51: {
                    int n14;
                    if (byArray == null) {
                        n14 = 0;
                        while (n14 < n12) {
                            if (n8++ % 16 == 0) {
                                this.output.write(this.lineSeparator);
                            } else {
                                this.output.write(32);
                            }
                            this.writeInteger(this.output, (int)object[n14]);
                            ++n14;
                        }
                    } else {
                        n14 = 0;
                        while (n14 < n12) {
                            if (n8++ % 16 == 0) {
                                this.output.write(this.lineSeparator);
                            } else {
                                this.output.write(32);
                            }
                            this.writeInteger(this.output, byArray[object[n14]] & 0xFF);
                            this.output.write(32);
                            this.writeInteger(this.output, byArray2[object[n14]] & 0xFF);
                            this.output.write(32);
                            this.writeInteger(this.output, byArray3[object[n14]] & 0xFF);
                            ++n14;
                        }
                    }
                    this.output.write(this.lineSeparator);
                    break;
                }
                case 52: {
                    int n15;
                    int n16;
                    int n14 = 0;
                    int n17 = 0;
                    int n18 = 0;
                    while (n18 < n12 / 8) {
                        n16 = object[n17++] << 7 | object[n17++] << 6 | object[n17++] << 5 | object[n17++] << 4 | object[n17++] << 3 | object[n17++] << 2 | object[n17++] << 1 | object[n17++];
                        byArray4[n14++] = (byte)n16;
                        ++n18;
                    }
                    if (n12 % 8 > 0) {
                        n16 = 0;
                        n15 = 0;
                        while (n15 < n12 % 8) {
                            n16 |= object[n12 + n15] << 7 - n15;
                            ++n15;
                        }
                        byArray4[n14++] = (byte)n16;
                    }
                    this.output.write(byArray4, 0, (n12 + 7) / 8);
                    break;
                }
                case 53: {
                    int n16 = 0;
                    while (n16 < n12) {
                        byArray4[n16] = (byte)object[n16];
                        ++n16;
                    }
                    this.output.write(byArray4, 0, n12);
                    break;
                }
                case 54: {
                    int n15;
                    if (byArray == null) {
                        n15 = 0;
                        while (n15 < n12) {
                            byArray4[n15] = (byte)(object[n15] & 0xFF);
                            ++n15;
                        }
                    } else {
                        n15 = 0;
                        int n19 = 0;
                        while (n15 < n12) {
                            byArray4[n19++] = byArray[object[n15]];
                            byArray4[n19++] = byArray2[object[n15]];
                            byArray4[n19++] = byArray3[object[n15]];
                            ++n15;
                        }
                    }
                    this.output.write(byArray4, 0, byArray4.length);
                }
            }
            n10 += 8;
        }
        this.output.flush();
    }

    private void writeInteger(OutputStream outputStream, int n) throws IOException {
        outputStream.write(Integer.toString(n).getBytes());
    }

    private void writeByte(OutputStream outputStream, byte by) throws IOException {
        outputStream.write(Byte.toString(by).getBytes());
    }

    private boolean isRaw(int n) {
        return n >= 52;
    }
}

