/*
 * Decompiled with CFR 0.152.
 */
package dbmaker.sql;

import dbmaker.sql.JdbcOdbcAPI;
import dbmaker.sql.JdbcOdbcConnection;
import dbmaker.sql.JdbcOdbcStatement;
import dbmaker.sql.LargeObjectAbstract;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ResourceBundle;

public class JdbcOdbcBlob
extends LargeObjectAbstract
implements Blob {
    protected long total_length;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcOdbcBlob(JdbcOdbcAPI jdbcOdbcAPI, JdbcOdbcConnection jdbcOdbcConnection, JdbcOdbcStatement jdbcOdbcStatement, int n) throws SQLException, SQLWarning {
        this.ODBCOBJ = jdbcOdbcAPI;
        this.myConnection = jdbcOdbcConnection;
        this.myStatement = jdbcOdbcStatement;
        JdbcOdbcConnection jdbcOdbcConnection2 = this.myConnection;
        synchronized (jdbcOdbcConnection2) {
            this.hBLOB = this.ODBCOBJ.jdbcGetBlobHandle(jdbcOdbcStatement.getHSTMT(), n);
            if (this.hBLOB == 0L) {
                this.wasNull = true;
            } else {
                this.total_length = this.ODBCOBJ.jdbcGetBlobSize(this.hBLOB);
            }
            this.isClose = false;
        }
    }

    public long length() throws SQLException {
        if (this.needTrace) {
            this.trace("JdbcOdbcBlob.length");
        }
        this.checkClosed(this.isClose);
        return this.total_length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(long l, int n) throws SQLException {
        if (this.needTrace) {
            this.trace("JdbcOdbcBlob.getBytes");
        }
        this.checkClosed(this.isClose);
        if (l < 1L) {
            this.JDBCError("JERR_INV_START_POS", null);
        }
        if (n < 0) {
            this.JDBCError("JERR_INV_GET_LENGTH", null);
        }
        if (l + (long)n > this.total_length) {
            n = (int)(this.total_length - l) + 1;
        }
        JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
        synchronized (jdbcOdbcConnection) {
            return this.ODBCOBJ.jdbcGetBlob(this.hBLOB, l - 1L, n);
        }
    }

    protected InputStream getBinaryStream(boolean bl) throws SQLException, SQLWarning {
        if (this.needTrace) {
            this.trace("JdbcOdbcBlob.getBinaryStream");
        }
        this.checkClosed(this.isClose);
        if (this.total_length == 0L) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new Stream(this, bl, 1L, this.total_length);
    }

    public InputStream getBinaryStream() throws SQLException, SQLWarning {
        if (this.needTrace) {
            this.trace("JdbcOdbcBlob.getBinaryStream");
        }
        this.checkClosed(this.isClose);
        return this.getBinaryStream(false);
    }

    public long position(byte[] byArray, long l) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "Blob.position(byte[], long)", null);
    }

    public long position(Blob blob, long l) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "Blob.position(Blob, long)", null);
    }

    public boolean isNull() throws SQLException {
        this.checkClosed(this.isClose);
        return this.wasNull;
    }

    public void free() throws SQLException {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (!this.isClose) {
            JdbcOdbcConnection jdbcOdbcConnection = this.myConnection;
            synchronized (jdbcOdbcConnection) {
                this.myConnection.unregisterLargeObject(this);
                if (this.hBLOB != 0L) {
                    this.ODBCOBJ.jdbcDropBlobHandle(this.hBLOB);
                }
            }
        }
        this.isClose = true;
    }

    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        if (this.needTrace) {
            this.trace("JdbcOdbcBlob.getBinaryStream");
        }
        this.checkClosed(this.isClose);
        return new Stream(this, false, l, l2);
    }

    protected ResourceBundle getResourceBundle() {
        return this.myConnection.getResourceBundle();
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "Blob.setBytes(long pos, byte[] bytes)", null);
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "Blob.setBytes(long pos, byte[] bytes, int offset, int len)", null);
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "Blob.setBinaryStream(long pos)", null);
    }

    public void truncate(long l) throws SQLException {
        throw this.JDBCError("JERR_UNSUPPORT_OPERATION", "Blob.truncate(long len)", null);
    }

    public class Stream
    extends InputStream {
        private JdbcOdbcBlob _blob = null;
        private long _blobPos = 0L;
        private long _blobLen = 0L;
        private boolean _freeBlobWhenClose = false;
        private byte[] ba = null;
        private int pos = 0;
        private int _readlimit = 0;
        private boolean isClose = false;

        Stream(JdbcOdbcBlob jdbcOdbcBlob2, boolean bl, long l, long l2) {
            this._blob = jdbcOdbcBlob2;
            this._blobLen = l2;
            this._blobPos = l;
            this._freeBlobWhenClose = bl;
        }

        public void close() {
            if (this.isClose || this._blob.isClose) {
                return;
            }
            this.isClose = true;
            if (!this._freeBlobWhenClose) {
                return;
            }
            try {
                this._blob.free();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }

        public int available() throws IOException {
            try {
                JdbcOdbcBlob.this.checkClosed(this._blob.isClose || this.isClose);
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
            if (this.ba == null) {
                return (int)this._blob.total_length;
            }
            return this.ba.length - this.pos + (int)(this._blobLen - this._blobPos + 1L);
        }

        public int read() throws IOException {
            try {
                JdbcOdbcBlob.this.checkClosed(this._blob.isClose || this.isClose);
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
            try {
                if (this.ba == null || this.pos == this.ba.length) {
                    if (this._blobPos > this._blobLen) {
                        return -1;
                    }
                    long l = this._blobLen - this._blobPos + 1L;
                    l = l < 1024L ? l : 1024L;
                    this.ba = this._blob.getBytes(this._blobPos, (int)l);
                    if (this.ba == null) {
                        return -1;
                    }
                    this._blobPos += l;
                    this.pos = 0;
                }
                return this.ba[this.pos++] & 0xFF;
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                return -1;
            }
        }

        public void mark(int n) {
            this._readlimit = n;
        }

        public void reset() throws IOException {
            this._blobPos = this._readlimit + 1;
            this.pos = 0;
            this.ba = null;
        }
    }
}

