/*
 * Decompiled with CFR 0.152.
 */
package tableCell;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ByteLookupTable;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.LookupOp;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class ImageDisplay
extends JComponent
implements MouseListener,
MouseMotionListener {
    protected PlanarImage source;
    protected SampleModel sampleModel;
    protected ColorModel colorModel;
    protected int minTileX;
    protected int maxTileX;
    protected int minTileY;
    protected int maxTileY;
    protected int tileWidth;
    protected int tileHeight;
    protected int tileGridXOffset;
    protected int tileGridYOffset;
    protected int originX = 0;
    protected int originY = 0;
    protected int shift_x = 0;
    protected int shift_y = 0;
    protected JLabel odometer = null;
    protected int componentWidth;
    protected int componentHeight;
    protected BufferedImageOp biop = null;
    protected boolean brightnessEnabled = false;
    protected int brightness = 0;
    protected byte[] lutData;

    private synchronized void initialize() {
        if (this.source == null) {
            return;
        }
        this.componentWidth = this.source.getWidth();
        this.componentHeight = this.source.getHeight();
        this.setPreferredSize(new Dimension(this.componentWidth, this.componentHeight));
        this.sampleModel = this.source.getSampleModel();
        this.colorModel = this.source.getColorModel();
        if (this.colorModel == null) {
            this.colorModel = PlanarImage.createColorModel((SampleModel)this.sampleModel);
            if (this.colorModel == null) {
                throw new IllegalArgumentException("no color model");
            }
        }
        this.minTileX = this.source.getMinTileX();
        this.maxTileX = this.source.getMinTileX() + this.source.getNumXTiles() - 1;
        this.minTileY = this.source.getMinTileY();
        this.maxTileY = this.source.getMinTileY() + this.source.getNumYTiles() - 1;
        this.tileWidth = this.source.getTileWidth();
        this.tileHeight = this.source.getTileHeight();
        this.tileGridXOffset = this.source.getTileGridXOffset();
        this.tileGridYOffset = this.source.getTileGridYOffset();
    }

    public ImageDisplay() {
        this.source = null;
        this.lutData = new byte[256];
        for (int i = 0; i < 256; ++i) {
            this.lutData[i] = (byte)i;
        }
        this.componentWidth = 64;
        this.componentHeight = 64;
        this.setPreferredSize(new Dimension(this.componentWidth, this.componentHeight));
        this.setOrigin(0, 0);
        this.setBrightnessEnabled(true);
    }

    public ImageDisplay(PlanarImage im) {
        this.source = im;
        this.initialize();
        this.lutData = new byte[256];
        for (int i = 0; i < 256; ++i) {
            this.lutData[i] = (byte)i;
        }
        this.setOrigin(0, 0);
        this.setBrightnessEnabled(true);
    }

    public ImageDisplay(int width, int height) {
        this.source = null;
        this.lutData = new byte[256];
        for (int i = 0; i < 256; ++i) {
            this.lutData[i] = (byte)i;
        }
        this.componentWidth = width;
        this.componentHeight = height;
        this.setPreferredSize(new Dimension(this.componentWidth, this.componentHeight));
        this.setOrigin(0, 0);
        this.setBrightnessEnabled(true);
    }

    public void set(PlanarImage im) {
        this.source = im;
        this.initialize();
        this.repaint();
    }

    public void set(PlanarImage im, int x, int y) {
        this.source = im;
        this.initialize();
        this.setOrigin(x, y);
    }

    public PlanarImage getImage() {
        return this.source;
    }

    public final JLabel getOdometer() {
        if (this.odometer == null) {
            this.odometer = new JLabel();
            this.odometer.setVerticalAlignment(0);
            this.odometer.setHorizontalAlignment(2);
            this.odometer.setText(" ");
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }
        return this.odometer;
    }

    public final void setOrigin(int x, int y) {
        this.originX = -x;
        this.originY = -y;
        this.repaint();
    }

    public int getXOrigin() {
        return this.originX;
    }

    public int getYOrigin() {
        return this.originY;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        int h;
        int w;
        Insets insets = this.getInsets();
        if (this.source == null) {
            w = width;
            h = height;
        } else {
            w = this.source.getWidth();
            h = this.source.getHeight();
            if (width < w) {
                w = width;
            }
            if (height < h) {
                h = height;
            }
        }
        this.componentWidth = w + insets.left + insets.right;
        this.componentHeight = h + insets.top + insets.bottom;
        super.setBounds(x + this.shift_x, y + this.shift_y, this.componentWidth, this.componentHeight);
    }

    @Override
    public void setLocation(int x, int y) {
        this.shift_x = x;
        this.shift_y = y;
        super.setLocation(x, y);
    }

    private final int XtoTileX(int x) {
        return (int)Math.floor((double)(x - this.tileGridXOffset) / (double)this.tileWidth);
    }

    private final int YtoTileY(int y) {
        return (int)Math.floor((double)(y - this.tileGridYOffset) / (double)this.tileHeight);
    }

    private final int TileXtoX(int tx) {
        return tx * this.tileWidth + this.tileGridXOffset;
    }

    private final int TileYtoY(int ty) {
        return ty * this.tileHeight + this.tileGridYOffset;
    }

    private static final void debug(String msg) {
        System.out.println(msg);
    }

    private final byte clampByte(int v) {
        if (v > 255) {
            return -1;
        }
        if (v < 0) {
            return 0;
        }
        return (byte)v;
    }

    private final void setBrightnessEnabled(boolean v) {
        this.brightnessEnabled = v;
        this.biop = this.brightnessEnabled ? new AffineTransformOp(new AffineTransform(), 1) : null;
    }

    public final boolean getBrightnessEnabled() {
        return this.brightnessEnabled;
    }

    public final void setBrightness(int b) {
        if (b != this.brightness && this.brightnessEnabled) {
            for (int i = 0; i < 256; ++i) {
                this.lutData[i] = this.clampByte(i + b);
            }
            this.repaint();
        }
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        Graphics2D g2D = null;
        if (!(g instanceof Graphics2D)) {
            return;
        }
        g2D = (Graphics2D)g;
        if (this.source == null) {
            g2D.setColor(this.getBackground());
            g2D.fillRect(0, 0, this.componentWidth, this.componentHeight);
            return;
        }
        int transX = -this.originX;
        int transY = -this.originY;
        Rectangle clipBounds = g.getClipBounds();
        if (clipBounds == null) {
            clipBounds = new Rectangle(0, 0, this.componentWidth, this.componentHeight);
        }
        if (transX > 0 || transY > 0 || transX < this.componentWidth - this.source.getWidth() || transY < this.componentHeight - this.source.getHeight()) {
            g2D.setColor(this.getBackground());
            g2D.fillRect(0, 0, this.componentWidth, this.componentHeight);
        }
        clipBounds.translate(-transX, -transY);
        int txmin = this.XtoTileX(clipBounds.x);
        txmin = Math.max(txmin, this.minTileX);
        txmin = Math.min(txmin, this.maxTileX);
        int txmax = this.XtoTileX(clipBounds.x + clipBounds.width - 1);
        txmax = Math.max(txmax, this.minTileX);
        txmax = Math.min(txmax, this.maxTileX);
        int tymin = this.YtoTileY(clipBounds.y);
        tymin = Math.max(tymin, this.minTileY);
        tymin = Math.min(tymin, this.maxTileY);
        int tymax = this.YtoTileY(clipBounds.y + clipBounds.height - 1);
        tymax = Math.max(tymax, this.minTileY);
        tymax = Math.min(tymax, this.maxTileY);
        Insets insets = this.getInsets();
        for (int tj = tymin; tj <= tymax; ++tj) {
            for (int ti = txmin; ti <= txmax; ++ti) {
                int tx = this.TileXtoX(ti);
                int ty = this.TileYtoY(tj);
                Raster tile = this.source.getTile(ti, tj);
                if (tile == null) continue;
                DataBuffer dataBuffer = tile.getDataBuffer();
                WritableRaster wr = Raster.createWritableRaster(this.sampleModel, dataBuffer, null);
                BufferedImage bi = new BufferedImage(this.colorModel, wr, this.colorModel.isAlphaPremultiplied(), null);
                if (this.brightnessEnabled) {
                    SampleModel sm = this.sampleModel.createCompatibleSampleModel(tile.getWidth(), tile.getHeight());
                    WritableRaster raster = RasterFactory.createWritableRaster((SampleModel)sm, null);
                    BufferedImage bimg = new BufferedImage(this.colorModel, raster, this.colorModel.isAlphaPremultiplied(), null);
                    ByteLookupTable lutTable = new ByteLookupTable(0, this.lutData);
                    LookupOp lookup = new LookupOp(lutTable, null);
                    lookup.filter(bi, bimg);
                    g2D.drawImage(bimg, this.biop, tx + transX + insets.left, ty + transY + insets.top);
                    continue;
                }
                AffineTransform transform = AffineTransform.getTranslateInstance(tx + transX + insets.left, ty + transY + insets.top);
                g2D.drawRenderedImage(bi, transform);
            }
        }
    }

    @Override
    public final void mouseEntered(MouseEvent e) {
    }

    @Override
    public final void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point p = e.getPoint();
        int mods = e.getModifiers();
        if (this.odometer != null) {
            String output = " (" + p.x + ", " + p.y + ")";
            this.odometer.setText(output);
        }
    }

    @Override
    public final void mouseReleased(MouseEvent e) {
        Point p = e.getPoint();
        if (this.odometer != null) {
            String output = " (" + p.x + ", " + p.y + ")";
            this.odometer.setText(output);
        }
    }

    @Override
    public final void mouseClicked(MouseEvent e) {
    }

    @Override
    public final void mouseMoved(MouseEvent e) {
        Point p = e.getPoint();
        if (this.odometer != null) {
            String output = " (" + p.x + ", " + p.y + ")";
            this.odometer.setText(output);
        }
    }

    @Override
    public final void mouseDragged(MouseEvent e) {
        this.mousePressed(e);
    }
}

