/*
 * Decompiled with CFR 0.152.
 */
package dbaut;

import dbaut.DbaUtDef;
import dbaut.IncBackupFile;
import dbaut.JBackupHistory;
import dbaut.JdmConfig;
import dbaut.svrmgrlib;
import java.util.Vector;

public class JRestore {
    private int[] h_rb = null;
    private String dbname;
    private String usrname;
    private String histfile;
    private int backup_id;
    public int lastrip = -1;
    private static String errstr = null;
    private static final int LEN_FNAME = 256;
    private svrmgrlib cfun = new svrmgrlib();

    public String geterrstr() {
        if (errstr == null) {
            return new String("");
        }
        return errstr.trim();
    }

    public int start(String dbname, String usrname, String histfile) {
        errstr = null;
        this.dbname = dbname;
        this.usrname = usrname;
        this.histfile = histfile;
        JdmConfig config = new JdmConfig();
        int rc = config.fileOpen("dmconfig.ini", dbname, "r+");
        if (rc != DbaUtDef.RTN_OK) {
            System.out.println("Error open config file");
            return rc;
        }
        rc = config.insertPara("DB_SMODE", new Integer(DbaUtDef.ENG_JNLOVER), 8192);
        rc = config.fileClose();
        this.h_rb = new int[1];
        int[] secid = new int[1];
        int[] bkid = new int[1];
        byte[] errmsg = new byte[1024];
        rc = this.cfun.cistart(this.h_rb, dbname.getBytes(), usrname.getBytes(), secid, DbaUtDef.ENG_BEG_ROV, bkid, errmsg);
        if (rc != DbaUtDef.RTN_OK && rc != DbaUtDef.ERR_ROV_NEED_MORE) {
            System.out.println("cistart error : " + rc);
            errstr = new String(errmsg);
            this.h_rb = null;
        } else {
            this.backup_id = bkid[0];
        }
        System.out.println("cistart rc=" + rc);
        return rc;
    }

    public int rollover(int rip, Vector v) {
        errstr = null;
        System.out.println("rollover rip=" + rip + " v is " + (v == null ? "null" : "not null and size=" + v.size()));
        this.lastrip = rip;
        if (this.h_rb == null) {
            return -1;
        }
        if (v == null && rip != DbaUtDef.ENG_END_ROV) {
            return -1;
        }
        int rc = 0;
        int size = 0;
        int[] bkid = new int[1];
        byte[] errmsg = new byte[1024];
        if ((v == null || v.size() == 0) && rip == DbaUtDef.ENG_END_ROV) {
            size = 0;
            byte[] jnlnames = new byte[2048];
            rc = this.cfun.cirollover(this.h_rb, this.dbname.getBytes(), rip, jnlnames, size, bkid, errmsg);
            if (rc != DbaUtDef.RTN_OK && rc != DbaUtDef.ERR_ROV_NEED_MORE) {
                System.out.println("cirollover error : " + rc);
                errstr = new String(errmsg);
                System.out.println("errstr = " + errstr);
            }
            return rc;
        }
        while (v.size() > 0) {
            size = v.size() > 8 ? 8 : v.size();
            byte[] jnlnames = new byte[2048];
            for (int i = 0; i < size; ++i) {
                Object obj = v.elementAt(0);
                String str = obj instanceof IncBackupFile ? ((IncBackupFile)v.elementAt((int)0)).filename : obj.toString();
                v.removeElementAt(0);
                byte[] bytes = str.getBytes();
                System.arraycopy(bytes, 0, jnlnames, i * 256, bytes.length);
                System.out.println("jnlnames = " + jnlnames.toString());
            }
            rc = this.cfun.cirollover(this.h_rb, this.dbname.getBytes(), rip, jnlnames, size, bkid, errmsg);
            if (rc != DbaUtDef.RTN_OK && rc != DbaUtDef.ERR_ROV_NEED_MORE) {
                errstr = new String(errmsg);
                System.out.println("cirollover error : " + rc);
                break;
            }
            this.backup_id = bkid[0];
        }
        return rc;
    }

    public Vector getIncBackupInfo(String btime) {
        if (this.dbname == null) {
            return null;
        }
        Vector v = new Vector();
        JBackupHistory backup = new JBackupHistory();
        int rc = backup.FileOpen(this.dbname, this.histfile, DbaUtDef.READ_ONLY);
        if (rc != DbaUtDef.RTN_OK) {
            return null;
        }
        v = backup.getIncBackupInfo(this.backup_id, btime);
        backup.FileClose();
        return v;
    }

    public int shutdown(int flag) {
        if (this.h_rb == null) {
            return -1;
        }
        byte[] errmsg = new byte[1024];
        int rc = this.cfun.cishut(this.h_rb, flag, errmsg);
        if (rc != DbaUtDef.RTN_OK) {
            System.out.println("cishut error : " + rc);
            errstr = new String(errmsg);
        }
        this.h_rb = null;
        return rc;
    }
}

