/*
 * Decompiled with CFR 0.152.
 */
package javassist.scopedpool;

import java.lang.ref.WeakReference;
import java.security.ProtectionDomain;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.scopedpool.ScopedClassPoolRepository;
import javassist.scopedpool.SoftValueHashMap;

public class ScopedClassPool
extends ClassPool {
    protected ScopedClassPoolRepository repository;
    protected WeakReference classLoader;
    protected LoaderClassPath classPath;
    protected SoftValueHashMap softcache = new SoftValueHashMap();
    private boolean a = true;

    /*
     * WARNING - void declaration
     */
    protected ScopedClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository) {
        this((ClassLoader)var1_1, (ClassPool)var2_2, (ScopedClassPoolRepository)var3_3, false);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected ScopedClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository, boolean isTemp) {
        super((ClassPool)var2_2);
        void var1_1;
        void var3_3;
        void var2_2;
        this.repository = var3_3;
        this.classLoader = new WeakReference<ClassLoader>(cl);
        if (cl != null) {
            this.classPath = new LoaderClassPath(cl);
            ScopedClassPool scopedClassPool = this;
            scopedClassPool.insertClassPath(scopedClassPool.classPath);
        }
        this.childFirstLookup = true;
        if (!isTemp && var1_1 == null) {
            this.a = true;
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        ClassLoader classLoader = this.getClassLoader0();
        if (classLoader == null && !this.a) {
            throw new IllegalStateException("ClassLoader has been garbage collected");
        }
        return classLoader;
    }

    protected ClassLoader getClassLoader0() {
        return (ClassLoader)this.classLoader.get();
    }

    public void close() {
        ScopedClassPool scopedClassPool = this;
        scopedClassPool.removeClassPath(scopedClassPool.classPath);
        this.classPath.close();
        this.classes.clear();
        this.softcache.clear();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void flushClass(String classname) {
        void var1_1;
        this.classes.remove(classname);
        this.softcache.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void soften(CtClass clazz) {
        void var1_1;
        if (this.repository.isPrune()) {
            clazz.prune();
        }
        this.classes.remove(clazz.getName());
        this.softcache.put(clazz.getName(), (Object)var1_1);
    }

    public boolean isUnloadedClassLoader() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected CtClass getCached(String classname) {
        Object object;
        Object object2;
        CtClass ctClass = this.getCachedLocally(classname);
        if (ctClass != null) return ctClass;
        int n2 = 0;
        Object object32 = this.getClassLoader0();
        if (object32 != null) {
            n2 = classname.lastIndexOf(36);
            object2 = n2 < 0 ? classname.replaceAll("[\\.]", "/") + ".class" : classname.substring(0, n2).replaceAll("[\\.]", "/") + classname.substring(n2) + ".class";
            int n3 = n2 = ((ClassLoader)object32).getResource((String)object2) != null ? 1 : 0;
        }
        if (n2 != 0) return ctClass;
        object2 = object = this.repository.getRegisteredCLs();
        synchronized (object) {
            for (Object object32 : object.values()) {
                if (((ScopedClassPool)object32).isUnloadedClassLoader()) {
                    this.repository.unregisterClassLoader(((ScopedClassPool)object32).getClassLoader());
                    continue;
                }
                ctClass = ((ScopedClassPool)object32).getCachedLocally(classname);
                if (ctClass == null) continue;
                // ** MonitorExit[var5_7] (shouldn't be in output)
                return ctClass;
            }
            // ** MonitorExit[var5_7] (shouldn't be in output)
            return ctClass;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void cacheCtClass(String classname, CtClass c2, boolean dynamic) {
        void var2_2;
        void var1_1;
        if (dynamic) {
            void var3_3;
            super.cacheCtClass(classname, c2, (boolean)var3_3);
            return;
        }
        if (this.repository.isPrune()) {
            c2.prune();
        }
        this.softcache.put((Object)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void lockInCache(CtClass c2) {
        void var1_1;
        super.cacheCtClass(c2.getName(), (CtClass)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    protected CtClass getCachedLocally(String classname) {
        Object object = (CtClass)this.classes.get(classname);
        if (object != null) {
            return object;
        }
        object = this.softcache;
        synchronized (object) {
            void var1_1;
            return (CtClass)this.softcache.get(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized CtClass getLocally(String classname) throws NotFoundException {
        this.softcache.remove(classname);
        CtClass ctClass = (CtClass)this.classes.get(classname);
        if (ctClass == null) {
            void var1_1;
            ctClass = this.createCtClass(classname, true);
            if (ctClass == null) {
                throw new NotFoundException(classname);
            }
            super.cacheCtClass((String)var1_1, ctClass, false);
        }
        return ctClass;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Class toClass(CtClass ct, ClassLoader loader, ProtectionDomain domain) throws CannotCompileException {
        void var3_3;
        void var1_1;
        this.lockInCache(ct);
        return super.toClass((CtClass)var1_1, this.getClassLoader0(), (ProtectionDomain)var3_3);
    }

    static {
        ClassPool.doPruning = false;
        ClassPool.releaseUnmodifiedClassFile = false;
    }
}

