/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.xtm.node;

import com.syscom.tree.AbstractDmTransferableTreeNode;
import com.syscom.ut.GuiUt;
import com.syscom.ut.comp.DmMenuItem;
import com.syscom.ut.locale.LocaleManager;
import com.syscom.ut.resource.DBAImageResource;
import com.syscom.xml.schema.node.TableNode;
import com.syscom.xml.xtm.Preferences;
import com.syscom.xml.xtm.XtmDef;
import com.syscom.xml.xtm.XtmInfo;
import com.syscom.xml.xtm.gui.XTMFrame;
import com.syscom.xml.xtm.gui.XTMMenubar;
import com.syscom.xml.xtm.node.AbstractXtmMutableTreeNode;
import com.syscom.xml.xtm.node.XslTemplateNode;
import com.syscom.xml.xtm.node.XtmPreparedStatementNode;
import com.syscom.xml.xtm.node.XtmTableNode;
import com.syscom.xml.xtm.treetable.XtmTreeTable;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Writer;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.undo.UndoableEdit;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XtmConnectNode
extends AbstractXtmMutableTreeNode {
    private String driver = null;
    private String datasource = null;
    private String user = null;
    private String password = null;
    private static ImageIcon icon = null;
    private static String imagefilename = "/images/tree/schema/database.gif";

    public XtmConnectNode(XtmInfo info) {
        this.driver = info.driver;
        this.datasource = info.datasource;
        this.user = info.user;
        this.password = info.password;
    }

    public static XtmConnectNode createDummyXtmConnectNode(Element elm) throws Exception {
        XtmConnectNode node = new XtmConnectNode();
        node.init(elm);
        return node;
    }

    private XtmConnectNode() {
    }

    public XtmConnectNode(Element elm) throws Exception {
        this.driver = elm.getAttribute("driver");
        this.datasource = elm.getAttribute("datasource");
        this.user = elm.getAttribute("user");
        this.password = elm.getAttribute("password");
        this.init(elm);
    }

    private void init(Element elm) throws Exception {
        AbstractXtmMutableTreeNode cNode = null;
        for (Node node = elm.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            cNode = null;
            String nodeURI = node.getNamespaceURI();
            if (nodeURI != null && nodeURI.compareTo(XtmDef.getXTMNAMESPACE()) == 0) {
                if (node.getLocalName().compareTo("preparedStatement") == 0) {
                    cNode = new XtmPreparedStatementNode((Element)node);
                } else if (node.getLocalName().compareTo("table") == 0) {
                    cNode = new XtmTableNode((Element)node);
                }
            }
            if (cNode == null) {
                ResourceBundle res = ResourceBundle.getBundle("com.syscom.xml.xtm.resource.Res", LocaleManager.getLocale());
                throw new Exception(GuiUt.mapStringForProperty(res.getString("conversion_fail_cannot_be_under_xtt_connect"), node.getNodeName()));
            }
            this.add(cNode);
        }
    }

    @Override
    public String getText() {
        if (this.datasource == null) {
            return "Unknown";
        }
        return this.datasource;
    }

    @Override
    public void setText(String str) {
    }

    @Override
    public String getXPath() {
        AbstractXtmMutableTreeNode p = (AbstractXtmMutableTreeNode)this.getParent();
        if (p instanceof XslTemplateNode) {
            return ((XslTemplateNode)p).getXPath();
        }
        return "";
    }

    @Override
    public void setXPath(String str) {
    }

    @Override
    public boolean isXPathEditable() {
        return false;
    }

    @Override
    public ImageIcon getImageIcon() {
        if (icon == null) {
            icon = DBAImageResource.getResource(this.getClass(), imagefilename);
        }
        return icon;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getDatasource() {
        return this.datasource;
    }

    public String getUesr() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public boolean isAcceptable(AbstractXtmMutableTreeNode node) {
        return node instanceof XtmTableNode || node instanceof XtmPreparedStatementNode;
    }

    @Override
    public boolean isAcceptable(AbstractDmTransferableTreeNode node) {
        return node instanceof TableNode;
    }

    @Override
    public UndoableEdit accept(AbstractDmTransferableTreeNode obj, XtmTreeTable treeTable) {
        if (!this.isAcceptable(obj)) {
            return null;
        }
        if (obj instanceof TableNode) {
            return this.acceptTableNode((TableNode)obj, treeTable);
        }
        return null;
    }

    @Override
    public void writeXtm(Writer out) throws IOException {
        XtmInfo info = XTMFrame.frame.getXtmInfo();
        Preferences pref = XTMFrame.frame.getPreferences();
        short choice = pref.getPrintConnectSection();
        if (choice != 2) {
            out.write("<xtm:connect");
            this.driver = info.driver;
            this.datasource = info.datasource;
            if (this.driver != null && this.driver.length() > 0) {
                Preferences.writeXmlAttribute(out, "driver", this.driver);
            }
            if (this.datasource != null && this.datasource.length() > 0) {
                Preferences.writeXmlAttribute(out, "datasource", this.datasource);
            }
            if (choice == 0) {
                if (this.user == null || this.user.length() == 0) {
                    this.user = info.user;
                }
                if (this.password == null || this.password.length() == 0) {
                    this.password = info.password;
                }
                if (this.user != null && this.user.length() > 0) {
                    Preferences.writeXmlAttribute(out, "user", this.user);
                }
                if (this.password != null && this.password.length() > 0) {
                    Preferences.writeXmlAttribute(out, "password", this.password);
                }
            }
            if (this.getChildCount() == 0) {
                out.write("/>\n");
            } else {
                out.write(">\n");
                for (AbstractXtmMutableTreeNode child = (AbstractXtmMutableTreeNode)this.getFirstChild(); child != null; child = (AbstractXtmMutableTreeNode)child.getNextSibling()) {
                    child.writeXtm(out);
                }
                out.write("</xtm:connect>\n");
            }
        } else if (this.getChildCount() > 0) {
            for (AbstractXtmMutableTreeNode child = (AbstractXtmMutableTreeNode)this.getFirstChild(); child != null; child = (AbstractXtmMutableTreeNode)child.getNextSibling()) {
                child.writeXtm(out);
            }
        }
    }

    @Override
    public void writeScript(Writer out, Node node) throws IOException, TransformerException {
        if (this.getChildCount() == 0) {
            return;
        }
        for (AbstractXtmMutableTreeNode child = (AbstractXtmMutableTreeNode)this.getFirstChild(); child != null; child = (AbstractXtmMutableTreeNode)child.getNextSibling()) {
            child.writeScript(out, node);
        }
    }

    @Override
    public boolean isAddible() {
        return true;
    }

    @Override
    public void showPopup(MouseEvent e) {
        XTMMenubar menubar = XTMFrame.frame.getXTMMenuBar();
        JPopupMenu qe_popupmenu = new JPopupMenu();
        DmMenuItem insertStmtMenuitem = new DmMenuItem(menubar.getAction((short)6));
        qe_popupmenu.add(insertStmtMenuitem);
        qe_popupmenu.show(e.getComponent(), e.getX(), e.getY());
    }
}

