/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.xtm.node;

import com.syscom.tree.AbstractDmTransferableTreeNode;
import com.syscom.ut.resource.DBAImageResource;
import com.syscom.xml.node.AbstractXmlMutableTreeNode;
import com.syscom.xml.xtm.Preferences;
import com.syscom.xml.xtm.node.AbstractXtmMutableTreeNode;
import com.syscom.xml.xtm.treetable.XtmTreeTable;
import com.syscom.xml.xtm.undo.UpdateNodeEdit;
import java.io.IOException;
import java.io.Writer;
import javax.swing.ImageIcon;
import javax.swing.undo.UndoableEdit;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XtmColumnNode
extends AbstractXtmMutableTreeNode {
    private int type = 1;
    private String name = null;
    private String select = null;
    private static ImageIcon icon = null;
    private static String imagefilename = "/images/tree/schema/column.gif";

    public XtmColumnNode(String name, int type) {
        this.name = name;
        this.type = type;
    }

    public XtmColumnNode(Element elm) {
        this.name = elm.getAttribute("name");
        this.select = elm.getAttribute("select");
    }

    @Override
    public String getText() {
        return this.name;
    }

    @Override
    public void setText(String str) {
    }

    @Override
    public String getXPath() {
        return this.select != null ? this.select : "";
    }

    @Override
    public void setXPath(String str) {
        this.select = str;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public ImageIcon getImageIcon() {
        if (icon == null) {
            icon = DBAImageResource.getResource(this.getClass(), imagefilename);
        }
        return icon;
    }

    @Override
    public boolean isAcceptable(AbstractDmTransferableTreeNode node) {
        return node instanceof AbstractXmlMutableTreeNode;
    }

    @Override
    public UpdateNodeEdit initXPath(AbstractXmlMutableTreeNode node, XtmTreeTable treeTable) {
        String xpath = this.getInitXPath(node);
        if (this.requireNormalizeSpace()) {
            xpath = this.isNumeric() && this.type != -5 ? "number(" + xpath + ")" : "normalize-space(" + xpath + ")";
        }
        String orig = this.getXPath();
        this.setXPath(xpath);
        return new UpdateNodeEdit(treeTable, this, orig, xpath, "xPath", true);
    }

    @Override
    public UndoableEdit accept(AbstractDmTransferableTreeNode obj, XtmTreeTable treeTable) {
        if (!this.isAcceptable(obj)) {
            return null;
        }
        if (obj instanceof AbstractXmlMutableTreeNode) {
            UpdateNodeEdit edit = this.initXPath((AbstractXmlMutableTreeNode)obj, treeTable);
            edit.end();
            return edit;
        }
        return null;
    }

    @Override
    public void writeXtm(Writer out) throws IOException {
        out.write("<xtm:column");
        if (this.name != null && this.name.length() > 0) {
            Preferences.writeXmlAttribute(out, "name", this.name);
        }
        if (this.select != null && this.select.length() > 0) {
            Preferences.writeXmlAttribute(out, "select", this.select);
        }
        out.write("/>\n");
    }

    public boolean isNumeric() {
        return super.isNumeric(this.type);
    }

    public boolean requireNormalizeSpace() {
        return super.requireNormalizeSpace(this.type);
    }

    @Override
    public void writeScript(Writer out, Node context) throws IOException, TransformerException {
        if (this.select == null || this.select.length() == 0) {
            out.write("NULL");
            return;
        }
        XObject obj = XPathAPI.eval((Node)context, (String)this.select);
        String value = obj.str();
        if (value == null) {
            out.write("NULL");
            return;
        }
        if (this.isNumeric()) {
            out.write(value);
        } else {
            out.write(39);
            out.write(value);
            out.write(39);
        }
    }
}

