/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.xtm.gui;

import com.syscom.ut.GuiUt;
import com.syscom.ut.WebBrowser;
import com.syscom.ut.comp.DbaFileChooser;
import com.syscom.ut.comp.DbaFileFilter;
import com.syscom.ut.comp.DbaMenu;
import com.syscom.ut.comp.DmMenuItem;
import com.syscom.ut.comp.ReflectionAction;
import com.syscom.ut.dialog.AboutBox;
import com.syscom.ut.locale.LocaleChangeEvent;
import com.syscom.ut.locale.LocaleChangeListener;
import com.syscom.ut.locale.LocaleManager;
import com.syscom.ut.resource.DBAImageResource;
import com.syscom.xml.treeBuilder.XtmTreeBuilder;
import com.syscom.xml.xtm.Preferences;
import com.syscom.xml.xtm.XtmInfo;
import com.syscom.xml.xtm.XtmUt;
import com.syscom.xml.xtm.gui.ExecuteXtmDlg;
import com.syscom.xml.xtm.gui.PreferencesDlg;
import com.syscom.xml.xtm.gui.WorkspaceDlg;
import com.syscom.xml.xtm.gui.XTMFrame;
import com.syscom.xml.xtm.gui.XtmNodeDlg;
import com.syscom.xml.xtm.jdbc.JdbcDriverDlg;
import com.syscom.xml.xtm.node.AbstractXtmMutableTreeNode;
import dbmaker.xml.XTM;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class XTMMenubar
extends JMenuBar
implements LocaleChangeListener {
    private ResourceBundle res = ResourceBundle.getBundle("com.syscom.xml.xtm.gui.resource.Res", LocaleManager.getLocale());
    public static final short NEW_FILE = 0;
    public static final short OPEN_FILE = 1;
    public static final short SAVE_FILE = 2;
    public static final short SAVEAS_FILE = 3;
    public static final short CLOSE_FILE = 4;
    public static final short EXIT = 5;
    public static final short INSERT = 6;
    public static final short REMOVE = 7;
    public static final short RUN = 8;
    public static final short REFRESH = 9;
    public static final short ABOUT = 10;
    public static final short WEBSITE = 11;
    public static final short UNDO = 12;
    public static final short REDO = 13;
    public static final short PREFERENCES = 14;
    public static final short DRIVERS = 15;
    private String[] names = new String[]{"New", "Open", "Save", "Save_as", "Close", "Exit", "Insert", "Remove", "Run", "Refresh", "About", "Website", "Undo", "Redo", "Preferences", "JDBC_Drivers"};
    private ReflectionAction[] actions = new ReflectionAction[]{new ReflectionAction(this, "newMenuitem_actionPerformed", this.res.getString("New"), DBAImageResource.getResource(this.getClass(), "/images/menu/new.gif")), new ReflectionAction(this, "openMenuitem_actionPerformed", this.res.getString("Open"), DBAImageResource.getResource(this.getClass(), "/images/menu/open.gif")), new ReflectionAction(this, "saveMenuitem_actionPerformed", this.res.getString("Save"), DBAImageResource.getResource(this.getClass(), "/images/menu/save.gif")), new ReflectionAction(this, "saveasMenuitem_actionPerformed", this.res.getString("Save_as"), DBAImageResource.getResource(this.getClass(), "/images/menu/saveas.gif")), new ReflectionAction(this, "closeMenuitem_actionPerformed", this.res.getString("Close"), DBAImageResource.getResource(this.getClass(), "/images/menu/close.gif")), new ReflectionAction(this, "exitMenuitem_actionPerformed", this.res.getString("Exit"), DBAImageResource.getResource(this.getClass(), "/images/menu/exit.gif")), new ReflectionAction(this, "insertStmtMenuitem_actionPerformed", this.res.getString("Insert"), DBAImageResource.getResource(this.getClass(), "/images/menu/table.gif")), new ReflectionAction(this, "removeMenuitem_actionPerformed", this.res.getString("Remove"), DBAImageResource.getResource(this.getClass(), "/images/menu/delete.gif")), new ReflectionAction(this, "runMenuitem_actionPerformed", this.res.getString("Run"), DBAImageResource.getResource(this.getClass(), "/images/menu/run.gif")), new ReflectionAction(this, "refreshMenuitem_actionPerformed", this.res.getString("Refresh"), DBAImageResource.getResource(this.getClass(), "/images/menu/refresh.gif")), new ReflectionAction(this, "aboutMenuitem_actionPerformed", this.res.getString("About"), DBAImageResource.getResource(this.getClass(), "/images/menu/about.gif")), new ReflectionAction(this, "websiteMenuitem_actionPerformed", this.res.getString("Website"), DBAImageResource.getResource(this.getClass(), "/images/menu/website.gif")), new ReflectionAction(this, "undoMenuitem_actionPerformed", this.res.getString("Undo"), DBAImageResource.getResource(this.getClass(), "/images/menu/undo.gif")), new ReflectionAction(this, "redoMenuitem_actionPerformed", this.res.getString("Redo"), DBAImageResource.getResource(this.getClass(), "/images/menu/redo.gif")), new ReflectionAction(this, "preferencesMenuitem_actionPerformed", this.res.getString("Preferences"), DBAImageResource.getResource(this.getClass(), "/images/menu/preferences.gif")), new ReflectionAction(this, "driversMenuitem_actionPerformed", this.res.getString("JDBC_Drivers"), DBAImageResource.getResource(this.getClass(), "/images/menu/jdbcdrivers.gif"))};
    JMenu fileMenu = new DbaMenu(this.res.getString("File"));
    JMenu operationsMenu = new DbaMenu(this.res.getString("Operations"));
    JMenu optionsMenu = new DbaMenu(this.res.getString("Options"));
    JMenu helpMenu = new DbaMenu(this.res.getString("Help"));
    private JMenuItem helpMenuitem = new JMenuItem(this.res.getString("Help"), DBAImageResource.getResource(this.getClass(), "/images/menu/help.gif"));
    JMenuItem[] previousFiles = new JMenuItem[4];
    DmMenuItem undoMenuitem = new DmMenuItem(this.actions[12]);
    DmMenuItem redoMenuitem = new DmMenuItem(this.actions[13]);
    private XtmUndoManager undoManager = new XtmUndoManager();
    private UndoableEditSupport undoSupport = new UndoableEditSupport();
    private UndoAdaptor undoAdaptor = new UndoAdaptor();
    private boolean separatorAdded = false;

    public ReflectionAction getAction(short key) {
        if (key >= 0 && key < this.actions.length) {
            return this.actions[key];
        }
        return null;
    }

    public XTMMenubar() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setActionStatus() {
        XtmInfo info = XTMFrame.frame.getXtmInfo();
        if (info == null) {
            this.actions[2].setEnabled(false);
            this.actions[3].setEnabled(false);
            this.actions[4].setEnabled(false);
            this.actions[6].setEnabled(false);
            this.actions[7].setEnabled(false);
            this.actions[9].setEnabled(false);
            this.actions[8].setEnabled(false);
        } else {
            this.actions[2].setEnabled(info.getDirty());
            this.actions[3].setEnabled(true);
            this.actions[4].setEnabled(true);
            this.actions[9].setEnabled(true);
            this.actions[8].setEnabled(true);
            AbstractXtmMutableTreeNode node = info.xtmTree.getLastSelectedPathComponent();
            if (node != null) {
                this.actions[6].setEnabled(node.isAddible());
                this.actions[7].setEnabled(node.isRemovabel());
            } else {
                this.actions[6].setEnabled(false);
                this.actions[7].setEnabled(false);
            }
        }
    }

    private void jbInit() throws Exception {
        DmMenuItem newMenuitem = new DmMenuItem(this.actions[0]);
        DmMenuItem openMenuitem = new DmMenuItem(this.actions[1]);
        DmMenuItem saveMenuitem = new DmMenuItem(this.actions[2]);
        DmMenuItem saveasMenuitem = new DmMenuItem(this.actions[3]);
        DmMenuItem closeMenuitem = new DmMenuItem(this.actions[4]);
        DmMenuItem exitMenuitem = new DmMenuItem(this.actions[5]);
        DmMenuItem insertStmtMenuitem = new DmMenuItem(this.actions[6]);
        DmMenuItem removeMenuitem = new DmMenuItem(this.actions[7]);
        DmMenuItem runMenuitem = new DmMenuItem(this.actions[8]);
        DmMenuItem refreshMenuitem = new DmMenuItem(this.actions[9]);
        DmMenuItem aboutMenuitem = new DmMenuItem(this.actions[10]);
        DmMenuItem websiteMenuitem = new DmMenuItem(this.actions[11]);
        DmMenuItem preferencesMenuitem = new DmMenuItem(this.actions[14]);
        DmMenuItem driversMenuitem = new DmMenuItem(this.actions[15]);
        removeMenuitem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        newMenuitem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        openMenuitem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        saveMenuitem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        closeMenuitem.setAccelerator(KeyStroke.getKeyStroke(115, 2));
        exitMenuitem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        insertStmtMenuitem.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        runMenuitem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.undoMenuitem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.redoMenuitem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        aboutMenuitem.setMnemonic('A');
        websiteMenuitem.setMnemonic('W');
        saveasMenuitem.setMnemonic('A');
        refreshMenuitem.setMnemonic('R');
        this.fileMenu.setMnemonic('F');
        this.operationsMenu.setMnemonic('O');
        this.optionsMenu.setMnemonic('P');
        this.helpMenu.setMnemonic('H');
        this.fileMenu.add(newMenuitem);
        this.fileMenu.add(openMenuitem);
        this.fileMenu.add(saveMenuitem);
        this.fileMenu.add(saveasMenuitem);
        this.fileMenu.add(closeMenuitem);
        this.fileMenu.addSeparator();
        for (int i = 0; i < this.previousFiles.length; ++i) {
            this.previousFiles[i] = new JMenuItem("");
            this.previousFiles[i].setMnemonic((char)(49 + i));
            this.previousFiles[i].setActionCommand(Integer.toString(i));
            this.previousFiles[i].addActionListener(new ReflectionAction(this, "previousFile_actionPerformed"));
            this.fileMenu.add(this.previousFiles[i]);
        }
        this.fileMenu.add(exitMenuitem);
        Preferences pref = XTMFrame.frame.getPreferences();
        this.initPreviousFiles(pref.getProjects());
        this.operationsMenu.add(this.undoMenuitem);
        this.operationsMenu.add(this.redoMenuitem);
        this.operationsMenu.addSeparator();
        this.operationsMenu.add(insertStmtMenuitem);
        this.operationsMenu.add(removeMenuitem);
        this.operationsMenu.addSeparator();
        this.operationsMenu.add(runMenuitem);
        this.operationsMenu.addSeparator();
        this.operationsMenu.add(refreshMenuitem);
        this.optionsMenu.add(preferencesMenuitem);
        this.optionsMenu.add(driversMenuitem);
        this.helpMenu.add(this.helpMenuitem);
        this.helpMenu.add(websiteMenuitem);
        this.helpMenu.add(aboutMenuitem);
        this.add(this.fileMenu);
        this.add(this.operationsMenu);
        this.add(this.optionsMenu);
        this.add(this.helpMenu);
        UIManager.put("AbstractUndoableEdit.undoText", this.res.getString("Undo"));
        UIManager.put("AbstractUndoableEdit.redoText", this.res.getString("Redo"));
        this.undoSupport.addUndoableEditListener(new UndoAdaptor());
        this.refreshUndoRedo();
        LocaleManager.getLocaleManager().addLocaleChangeListener(this);
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
        this.res = ResourceBundle.getBundle("com.syscom.xml.xtm.gui.resource.Res", LocaleManager.getLocale());
        int size = this.actions.length;
        for (int i = 0; i < size; ++i) {
            this.actions[i].putValue("Name", this.res.getString(this.names[i]));
        }
        this.fileMenu.setText(this.res.getString("File"));
        this.operationsMenu.setText(this.res.getString("Operations"));
        this.optionsMenu.setText(this.res.getString("Options"));
        this.helpMenu.setText(this.res.getString("Help"));
        this.helpMenuitem.setText(this.res.getString("Help"));
        UIManager.put("AbstractUndoableEdit.undoText", this.res.getString("Undo"));
        UIManager.put("AbstractUndoableEdit.redoText", this.res.getString("Redo"));
    }

    public JMenuItem getHelpButton() {
        return this.helpMenuitem;
    }

    public void initPreviousFiles(Vector v) {
        int i;
        XtmInfo info = null;
        int size = v.size();
        for (i = 0; i < size; ++i) {
            info = (XtmInfo)v.elementAt(i);
            this.previousFiles[i].setVisible(true);
            this.previousFiles[i].setText(i + 1 + " " + info.xtmfile);
        }
        for (i = size; i < 4; ++i) {
            this.previousFiles[i].setVisible(false);
        }
        if (!this.separatorAdded && size > 0) {
            this.fileMenu.insertSeparator(10);
            this.separatorAdded = true;
        }
    }

    public void exitMenuitem_actionPerformed(ActionEvent e) {
        int state = this.closeMenuitem_actionPerformed(e);
        if (state != 2 && state != 2) {
            XTMFrame.frame.exitOnClose(new WindowEvent(XTMFrame.frame, 201));
        }
    }

    public void previousFile_actionPerformed(ActionEvent e) {
        this.closeMenuitem_actionPerformed(null);
        if (XTMFrame.frame.getXtmInfo() != null) {
            return;
        }
        String cmd = e.getActionCommand();
        Preferences pref = XTMFrame.frame.getPreferences();
        int index = Integer.parseInt(cmd);
        if (index >= 0 && index < pref.getProjects().size()) {
            XtmInfo info = (XtmInfo)pref.getProjects().elementAt(index);
            this.open(info.xtmfile);
        }
    }

    public void newMenuitem_actionPerformed(ActionEvent e) {
        this.closeMenuitem_actionPerformed(null);
        if (XTMFrame.frame.getXtmInfo() != null) {
            return;
        }
        XtmInfo info = new XtmInfo();
        Preferences pref = XTMFrame.frame.getPreferences();
        XtmInfo last = pref.getLastProject();
        if (last != null) {
            info.driver = last.driver;
            info.datasource = last.datasource;
            info.user = last.user;
            info.password = last.password;
        }
        WorkspaceDlg dlg = WorkspaceDlg.createWorkspaceDlg(info);
        GuiUt.setCenterLocation(XTMFrame.frame, dlg);
        dlg.show();
        info = dlg.getXtmInfo();
        if (info == null) {
            return;
        }
        XTMFrame.frame.setXtmInfo(info);
        this.setActionStatus();
    }

    private void open(XtmInfo info) {
        File f = new File(info.xtmfile);
        if (!f.exists()) {
            GuiUt.showErrorDlg(XTMFrame.frame, GuiUt.mapStringForProperty(this.res.getString("not_exist_"), f.getAbsolutePath()));
            return;
        }
        try {
            info.xtmRoot = XtmTreeBuilder.getTree(info.xtmfile);
            XtmTreeBuilder.initConnectionDetail(info.xtmRoot, info);
            WorkspaceDlg dlg = WorkspaceDlg.createWorkspaceDlg(info);
            GuiUt.setCenterLocation(XTMFrame.frame, dlg);
            dlg.show();
            if (dlg.getXtmInfo() == null) {
                return;
            }
            XTMFrame.frame.setXtmInfo(info);
            this.setActionStatus();
        }
        catch (Exception e1) {
            e1.printStackTrace();
            GuiUt.showErrorDlg(XTMFrame.frame, e1.getMessage());
        }
    }

    private void open(String file) {
        Preferences pref = XTMFrame.frame.getPreferences();
        XtmInfo info = pref.searchProject(file);
        if (info == null) {
            info = new XtmInfo();
            info.xtmfile = file;
        }
        this.open(info);
    }

    public void openMenuitem_actionPerformed(ActionEvent e) {
        this.closeMenuitem_actionPerformed(null);
        if (XTMFrame.frame.getXtmInfo() != null) {
            return;
        }
        DbaFileChooser chooser = new DbaFileChooser();
        chooser.addChoosableFileFilter(new DbaFileFilter("xml", this.res.getString("XML_Document_Type")));
        chooser.addChoosableFileFilter(new DbaFileFilter("xsl", this.res.getString("XSL_Document_Type")));
        GuiUt.setCenterLocation(XTMFrame.frame, chooser);
        int state = chooser.showOpenDialog(this);
        if (state != 0) {
            return;
        }
        File f = chooser.getSelectedFile();
        this.open(f.getAbsolutePath());
    }

    private boolean save() {
        XtmInfo info = XTMFrame.frame.getXtmInfo();
        if (info.xtmfile.startsWith("untitle")) {
            return this.saveAs();
        }
        return this.save(new File(info.xtmfile));
    }

    private boolean save(File f) {
        try {
            XtmInfo info = XTMFrame.frame.getXtmInfo();
            XtmUt.writeXtm(f, info);
            info.setDirty(false);
            info.xtmTree.nodeChanged(info.xtmRoot.getFirstChild());
            this.setActionStatus();
            return true;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            GuiUt.showErrorDlg(XTMFrame.frame, e1.getMessage());
            return false;
        }
    }

    private boolean saveAs(File f) {
        boolean result = this.save(f);
        if (result) {
            XtmInfo info = XTMFrame.frame.getXtmInfo();
            info.xtmfile = f.getAbsolutePath();
            XTMFrame.frame.setXtmFilename();
            Preferences pref = XTMFrame.frame.getPreferences();
            pref.addProject(info);
            this.initPreviousFiles(pref.getProjects());
        }
        return result;
    }

    private boolean saveAs() {
        DbaFileChooser chooser = new DbaFileChooser();
        XtmInfo info = XTMFrame.frame.getXtmInfo();
        if (info.xtmfile != null && !info.xtmfile.startsWith("untitle")) {
            chooser.setCurrentDirectory(new File(info.xtmfile));
        }
        DbaFileFilter def = new DbaFileFilter("xsl", this.res.getString("XSL_Document_Type"));
        chooser.addChoosableFileFilter(def);
        chooser.addChoosableFileFilter(new DbaFileFilter("xml", this.res.getString("XML_Document_Type")));
        chooser.setFileFilter(def);
        GuiUt.setCenterLocation(XTMFrame.frame, chooser);
        int state = chooser.showDialog(this, this.res.getString("Save_as"));
        if (state != 0) {
            return false;
        }
        File f = chooser.getSelectedFile();
        if (f.exists()) {
            String s1 = this.res.getString("Do_you_want_to");
            String s2 = GuiUt.mapStringForProperty(s1, f.getAbsoluteFile().toString());
            int reply = GuiUt.showOptionDlg(XTMFrame.frame, this.res.getString("Question"), s2);
            if (reply != 0) {
                return false;
            }
        }
        return this.saveAs(f);
    }

    public void saveMenuitem_actionPerformed(ActionEvent e) {
        this.save();
    }

    public void saveasMenuitem_actionPerformed(ActionEvent e) {
        this.saveAs();
    }

    public int closeMenuitem_actionPerformed(ActionEvent e) {
        XtmInfo info = XTMFrame.frame.getXtmInfo();
        int state = 0;
        if (info != null && info.getDirty()) {
            state = GuiUt.showOption3Dlg(XTMFrame.frame, this.res.getString("Save_file"), this.res.getString("Save_changes_to") + info.xtmfile + " ?");
            if (state == 0) {
                boolean ret_save = this.save();
                if (!ret_save) {
                    state = 2;
                    return state;
                }
            } else if (state == 2) {
                return state;
            }
        }
        XTMFrame.frame.clear();
        return state;
    }

    public void runMenuitem_actionPerformed(ActionEvent e) {
        ExecuteXtmDlg dlg = ExecuteXtmDlg.createExecuteXtmDlg();
        GuiUt.setCenterLocation(XTMFrame.frame, dlg);
        dlg.show();
        int choice = dlg.getChoice();
        if (choice != ExecuteXtmDlg.AS_XTM) {
            if (choice != ExecuteXtmDlg.AS_SCRIPT) {
                return;
            }
        }
        XtmInfo info = XTMFrame.frame.getXtmInfo();
        if (choice == ExecuteXtmDlg.CANCEL) {
            return;
        }
        info.xmlfile = dlg.getXmlFilename();
        XTMFrame.frame.setCursor(Cursor.getPredefinedCursor(3));
        if (choice == ExecuteXtmDlg.AS_XTM) {
            info.xtmfile = dlg.getXtmFilename();
            if (!this.saveAs(new File(info.xtmfile))) {
                return;
            }
            XTM transfer = new XTM();
            transfer.setConnection(info.conn);
            int rc = transfer.run(info.xtmfile, info.xmlfile);
            if (rc == 0) {
                GuiUt.showInformationDlg(XTMFrame.frame, this.res.getString("Transformation"));
            } else {
                GuiUt.showErrorDlg(XTMFrame.frame, transfer.getError());
            }
        } else if (choice == ExecuteXtmDlg.AS_SCRIPT) {
            try {
                XtmUt.writeScript(info.xmlfile, dlg.getScriptFilename(), info);
                GuiUt.showInformationDlg(XTMFrame.frame, this.res.getString("Complete_SQL_script"));
            }
            catch (Exception e1) {
                e1.printStackTrace();
                GuiUt.showErrorDlg(XTMFrame.frame, e1.getMessage());
            }
        }
        XTMFrame.frame.setCursor(Cursor.getDefaultCursor());
    }

    public void removeMenuitem_actionPerformed(ActionEvent e) {
        XtmInfo info = XTMFrame.frame.getXtmInfo();
        if (info.xtmTree == null) {
            return;
        }
        info.xtmTree.removeSelectedNode();
    }

    public void refreshMenuitem_actionPerformed(ActionEvent e) {
        XTMFrame.frame.loadDataSource();
    }

    public void insertStmtMenuitem_actionPerformed(ActionEvent e) {
        XtmNodeDlg dlg = XtmNodeDlg.createXtmNodeDlg(null);
        GuiUt.setCenterLocation(XTMFrame.frame, dlg);
        dlg.show();
    }

    public void aboutMenuitem_actionPerformed(ActionEvent e) {
        AboutBox dlg = null;
        dlg = GuiUt.isWindows() ? new AboutBox((Frame)XTMFrame.frame, 6) : new AboutBox((Frame)XTMFrame.frame, "", true, 6);
        GuiUt.setCenterLocation(XTMFrame.frame, dlg);
        dlg.show();
        dlg = null;
        System.gc();
    }

    public void websiteMenuitem_actionPerformed(ActionEvent e) {
        if (LocaleManager.getLanguageChoice() == 1) {
            WebBrowser.displayURL(XTMFrame.frame, "http://www.dbmaker.com.tw");
        } else if (LocaleManager.getLanguageChoice() == 0 || LocaleManager.getLanguageChoice() == 3) {
            WebBrowser.displayURL(XTMFrame.frame, "http://www.dbmaker.com");
        } else {
            WebBrowser.displayURL(XTMFrame.frame, "http://www.dbmaker.co.jp");
        }
    }

    public void undoMenuitem_actionPerformed(ActionEvent e) {
        this.undoManager.undo();
        this.refreshUndoRedo();
    }

    public void redoMenuitem_actionPerformed(ActionEvent e) {
        this.undoManager.redo();
        this.refreshUndoRedo();
    }

    public void preferencesMenuitem_actionPerformed(ActionEvent e) {
        PreferencesDlg dlg = PreferencesDlg.createPreferencesDlg();
        GuiUt.setCenterLocation(XTMFrame.frame, dlg);
        dlg.show();
    }

    public void driversMenuitem_actionPerformed(ActionEvent e) {
        JdbcDriverDlg dlg = JdbcDriverDlg.createJdbcDriverDlg();
        GuiUt.setCenterLocation(XTMFrame.frame, dlg);
        dlg.show();
    }

    private void refreshUndoRedo() {
        this.undoMenuitem.setText(this.undoManager.getUndoPresentationName());
        this.actions[12].setEnabled(this.undoManager.canUndo());
        this.redoMenuitem.setText(this.undoManager.getRedoPresentationName());
        this.actions[13].setEnabled(this.undoManager.canRedo());
        XtmInfo info = XTMFrame.frame.getXtmInfo();
        if (info != null) {
            this.actions[2].setEnabled(true);
            info.setDirty(true);
        }
    }

    public void postEdit(UndoableEdit edit) {
        if (edit != null) {
            this.undoSupport.postEdit(edit);
        }
    }

    public UndoableEditListener getUndoableEditListener() {
        return this.undoAdaptor;
    }

    public void startDocumentEdit() {
        this.undoManager.startDocumentEdit();
    }

    public void endDocumentEdit() {
        this.undoManager.endDocumentEdit();
    }

    public void removeAllEdits() {
        this.undoManager.removeAllEdits();
        this.refreshUndoRedo();
    }

    private class XtmUndoManager
    extends UndoManager {
        private int from = -1;

        private XtmUndoManager() {
        }

        @Override
        public void undo() {
            UndoableEdit edit = super.editToBeUndone();
            super.undo();
            if (!(edit instanceof AbstractDocument.DefaultDocumentEvent)) {
                XTMFrame.frame.getXtmInfo().xtmTree.editingCanceled(null);
            }
        }

        @Override
        public void redo() {
            UndoableEdit edit = super.editToBeRedone();
            super.redo();
            if (!(edit instanceof AbstractDocument.DefaultDocumentEvent)) {
                XTMFrame.frame.getXtmInfo().xtmTree.editingCanceled(null);
            }
        }

        public void startDocumentEdit() {
            this.from = this.edits.size();
        }

        public void endDocumentEdit() {
            if (this.from < 0) {
                return;
            }
            int end = this.edits.size() - 1;
            if (end >= this.from) {
                super.trimEdits(this.from, end);
            }
            this.from = -1;
        }

        public void removeAllEdits() {
            super.trimEdits(0, this.edits.size() - 1);
        }
    }

    private class UndoAdaptor
    implements UndoableEditListener {
        private UndoAdaptor() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent evt) {
            UndoableEdit edit = evt.getEdit();
            XTMMenubar.this.undoManager.addEdit(edit);
            XTMMenubar.this.refreshUndoRedo();
        }
    }
}

