/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.xtm;

import com.syscom.xml.xtm.XtmInfo;
import com.syscom.xml.xtm.gui.XTMFrame;
import com.syscom.xml.xtm.jdbc.JdbcDriverDetail;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import org.apache.xalan.xsltc.runtime.DefaultSAXOutputHandler;
import org.apache.xml.utils.TreeWalker;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.ContentHandler;

public class Preferences
extends dbmaker.xml.Preferences {
    public static final short PRT_CONNECT_SEC_ALL = 0;
    public static final short PRT_CONNECT_SEC_WITHOUT_USER_PSW = 1;
    public static final short OMIT_CONNECT_SEC = 2;
    private short print_connect_sec_choice = 1;
    private int frame_width = 900;
    private int frame_height = 690;
    private int vertical = 600;
    private int horizontal = 320;
    private Point position = new Point(0, 0);
    private Vector projects = new Vector();
    private Vector jdbcDrivers = new Vector();
    private static Preferences myself = null;

    public static void initPreferences() {
        if (myself == null) {
            myself = new Preferences();
        }
    }

    public static Preferences getPreferences() {
        if (myself == null) {
            myself = new Preferences();
        }
        return myself;
    }

    private Preferences() {
        this.jdbcDrivers.add(new JdbcDriverDetail(JdbcDriverDetail.DBMAKER_JDBC_DRIVER, JdbcDriverDetail.DBMAKER_PREFIX, null));
        this.jdbcDrivers.add(new JdbcDriverDetail(JdbcDriverDetail.SUN_JDBC_ODBC_DRIVER, JdbcDriverDetail.SUN_PREFIX, null));
        try {
            this.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public XtmInfo getLastProject() {
        if (this.projects.size() > 0) {
            return (XtmInfo)this.projects.elementAt(0);
        }
        return null;
    }

    public void setPrintConnectSection(short choice) {
        this.print_connect_sec_choice = choice;
    }

    public short getPrintConnectSection() {
        return this.print_connect_sec_choice;
    }

    public Vector getProjects() {
        return this.projects;
    }

    public Point getLocation() {
        return this.position;
    }

    public int getFrameWidth() {
        return this.frame_width;
    }

    public int getFrameHeight() {
        return this.frame_height;
    }

    public int getVerticalDividerLocation() {
        return this.vertical;
    }

    public int getHorizontalDividerLocation() {
        return this.horizontal;
    }

    public Vector getJdbcDrivers() {
        return this.jdbcDrivers;
    }

    public void setJdbcDrivers(Vector drivers) {
        this.jdbcDrivers = drivers;
    }

    public XtmInfo searchProject(String xtmfile) {
        XtmInfo info = null;
        int size = this.projects.size();
        for (int i = 0; i < size; ++i) {
            info = (XtmInfo)this.projects.elementAt(i);
            if (info.xtmfile.compareTo(xtmfile) != 0) continue;
            return info;
        }
        return null;
    }

    public void addProject(XtmInfo project) {
        XtmInfo temp = this.searchProject(project.xtmfile);
        if (temp != null) {
            int index = this.projects.indexOf(temp);
            this.projects.remove(index);
        }
        this.projects.insertElementAt(project, 0);
        while (this.projects.size() > 4) {
            this.projects.remove(this.projects.size() - 1);
        }
    }

    public static void writeXmlAttribute(Writer out, String name, String str) throws IOException {
        if (str == null) {
            return;
        }
        out.write(" " + name + "=\"");
        char[] a = str.toCharArray();
        int size = a.length;
        block7: for (int i = 0; i < size; ++i) {
            switch (a[i]) {
                case '&': {
                    out.write("&amp;");
                    continue block7;
                }
                case '<': {
                    out.write("&lt;");
                    continue block7;
                }
                case '>': {
                    out.write("&gt;");
                    continue block7;
                }
                case '\'': {
                    out.write("&apos;");
                    continue block7;
                }
                case '\"': {
                    out.write("&quot;");
                    continue block7;
                }
                default: {
                    out.write(a[i]);
                }
            }
        }
        out.write("\"");
    }

    public void save() {
        this.save(dbmaker.xml.Preferences.getConfigName());
    }

    private void save(String filename) {
        this.frame_width = XTMFrame.frame.getWidth();
        this.frame_height = XTMFrame.frame.getHeight();
        this.vertical = XTMFrame.frame.getVerticalDividerLocation();
        this.horizontal = XTMFrame.frame.getHorizontalDividerLocation();
        this.position = XTMFrame.frame.getLocationOnScreen();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = null;
            Element syscom = null;
            File file = new File(filename);
            if (file.exists()) {
                try {
                    doc = builder.parse(file);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    doc = builder.newDocument();
                }
            } else {
                doc = builder.newDocument();
            }
            super.setDOM(doc);
            syscom = doc.getDocumentElement();
            if (syscom == null) {
                throw new Exception("CorePreferences fails to save <syscom>");
            }
            Element xtm2 = doc.createElement("xtm");
            Element frame = doc.createElement("frame");
            frame.setAttribute("width", Integer.toString(this.frame_width));
            frame.setAttribute("height", Integer.toString(this.frame_height));
            frame.setAttribute("vertical", Integer.toString(this.vertical));
            frame.setAttribute("horizontal", Integer.toString(this.horizontal));
            frame.setAttribute("xpos", Integer.toString((int)this.position.getX()));
            frame.setAttribute("ypos", Integer.toString((int)this.position.getY()));
            Element options = doc.createElement("options");
            options.setAttribute("connect_section", Short.toString(this.print_connect_sec_choice));
            xtm2.appendChild(frame);
            xtm2.appendChild(options);
            Element project = null;
            XtmInfo info = null;
            int size = this.projects.size();
            size = size > 4 ? 4 : size;
            for (int i = 0; i < size; ++i) {
                info = (XtmInfo)this.projects.elementAt(i);
                project = doc.createElement("project");
                project.setAttribute("xtmfile", info.xtmfile);
                project.setAttribute("xmlfile", info.schemafile);
                project.setAttribute("type", Short.toString(info.type));
                if (info.xmlRoot != null) {
                    project.setAttribute("xmlRootName", info.xmlRoot.getText());
                }
                project.setAttribute("driver", info.driver);
                project.setAttribute("datasource", info.datasource);
                project.setAttribute("user", info.user);
                project.setAttribute("password", info.password);
                xtm2.appendChild(project);
            }
            Element jdbc = null;
            JdbcDriverDetail detail = null;
            String classname = null;
            Enumeration enum1 = this.jdbcDrivers.elements();
            while (enum1.hasMoreElements()) {
                detail = (JdbcDriverDetail)enum1.nextElement();
                classname = detail.getClassname();
                if (classname.compareTo(JdbcDriverDetail.DBMAKER_JDBC_DRIVER) == 0 || classname.compareTo(JdbcDriverDetail.SUN_JDBC_ODBC_DRIVER) == 0) continue;
                jdbc = doc.createElement("jdbc");
                jdbc.setAttribute("name", detail.getClassname());
                jdbc.setAttribute("prefix", detail.getPrefix());
                jdbc.setAttribute("path", detail.getClasspath());
                xtm2.appendChild(jdbc);
            }
            Node orig = XPathAPI.selectSingleNode((Node)syscom, (String)"xtm");
            if (orig != null && orig.getNodeType() == 1) {
                syscom.replaceChild(xtm2, orig);
            } else {
                syscom.appendChild(xtm2);
            }
            FileOutputStream out = new FileOutputStream(file);
            DefaultSAXOutputHandler handler = new DefaultSAXOutputHandler((OutputStream)out, "UTF-8");
            TreeWalker tw = new TreeWalker((ContentHandler)handler);
            tw.traverse((Node)doc);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() {
        this.init(dbmaker.xml.Preferences.getConfigName());
    }

    private void init(String filename) {
        try {
            File file = new File(filename);
            if (!file.exists()) {
                return;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringElementContentWhitespace(true);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new File(filename));
            super.resetDOM(doc);
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("omit-xml-declaration", "yes");
            Node xtm2 = XPathAPI.selectSingleNode((Node)doc, (String)"/syscom/xtm");
            if (xtm2 == null || xtm2.getNodeType() != 1) {
                return;
            }
            String temp = null;
            Node node = XPathAPI.selectSingleNode((Node)xtm2, (String)"frame");
            if (node != null && node.getNodeType() == 1) {
                Element elm = (Element)node;
                temp = elm.getAttribute("width");
                if (temp != null && temp.length() > 0) {
                    this.frame_width = Integer.parseInt(temp);
                    if (this.frame_width < 0) {
                        this.frame_width = 900;
                    }
                }
                if ((temp = elm.getAttribute("height")) != null && temp.length() > 0) {
                    this.frame_height = Integer.parseInt(temp);
                    if (this.frame_height < 0) {
                        this.frame_height = 600;
                    }
                }
                if ((temp = elm.getAttribute("vertical")) != null && temp.length() > 0) {
                    this.vertical = Integer.parseInt(temp);
                    if (this.vertical < 0) {
                        this.vertical = 600;
                    }
                }
                if ((temp = elm.getAttribute("horizontal")) != null && temp.length() > 0) {
                    this.horizontal = Integer.parseInt(temp);
                    if (this.horizontal < 0) {
                        this.horizontal = 320;
                    }
                }
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                int xpos = 0;
                int ypos = 0;
                temp = elm.getAttribute("xpos");
                if (temp != null && temp.length() > 0 && ((xpos = Integer.parseInt(temp)) < 0 || (double)xpos > screenSize.getWidth())) {
                    xpos = 0;
                }
                if ((temp = elm.getAttribute("ypos")) != null && temp.length() > 0 && ((ypos = Integer.parseInt(temp)) < 0 || (double)ypos > screenSize.getHeight())) {
                    ypos = 0;
                }
                this.position = new Point(xpos, ypos);
            }
            if ((node = XPathAPI.selectSingleNode((Node)xtm2, (String)"options")) != null && node.getNodeType() == 1 && (temp = ((Element)node).getAttribute("connect_section")) != null && temp.length() > 0) {
                this.print_connect_sec_choice = Short.parseShort(temp);
            }
            XtmInfo project = null;
            NodeIterator nl = XPathAPI.selectNodeIterator((Node)xtm2, (String)"project");
            while ((node = nl.nextNode()) != null) {
                if (node.getNodeType() != 1) continue;
                project = new XtmInfo();
                project.xtmfile = ((Element)node).getAttribute("xtmfile");
                project.schemafile = ((Element)node).getAttribute("xmlfile");
                temp = ((Element)node).getAttribute("type");
                if (temp != null && temp.length() > 0) {
                    project.type = Short.parseShort(temp);
                }
                project.xmlRootName = ((Element)node).getAttribute("xmlRootName");
                project.driver = ((Element)node).getAttribute("driver");
                project.datasource = ((Element)node).getAttribute("datasource");
                project.user = ((Element)node).getAttribute("user");
                project.password = ((Element)node).getAttribute("password");
                this.projects.add(project);
            }
            String classpath = null;
            String classname = null;
            String prefix = null;
            boolean nlist_size = false;
            Object nlist = null;
            nl = XPathAPI.selectNodeIterator((Node)xtm2, (String)"jdbc");
            while ((node = nl.nextNode()) != null) {
                if (node.getNodeType() != 1) continue;
                classname = ((Element)node).getAttribute("name");
                prefix = ((Element)node).getAttribute("prefix");
                classpath = ((Element)node).getAttribute("path");
                this.jdbcDrivers.add(new JdbcDriverDetail(classname, prefix, classpath));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

