/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.treeBuilder;

import com.syscom.ut.GuiUt;
import com.syscom.ut.locale.LocaleManager;
import com.syscom.xml.node.AbstractXmlMutableTreeNode;
import com.syscom.xml.node.AttributeNode;
import com.syscom.xml.node.ElementNode;
import java.io.File;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDParser {
    public static final String STD_XSD_URI = "http://www.w3.org/2001/XMLSchema";
    static Stack stack = new Stack();

    public static void getXSDAttribute(DefaultMutableTreeNode parent, Element cur, Element root) {
        Object prefix = null;
        String localname = null;
        Object child = null;
        String temp = null;
        for (Node node = cur.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element ref;
            if (node.getNodeType() != 1) continue;
            localname = node.getLocalName();
            if (node.getNamespaceURI().compareTo(STD_XSD_URI) == 0 && localname != null && localname.compareTo("attribute") == 0) {
                Element refNode;
                temp = ((Element)node).getAttribute("name");
                if (temp != null) {
                    parent.add(new AttributeNode(temp));
                    continue;
                }
                temp = ((Element)node).getAttribute("ref");
                if (temp == null || (refNode = XSDParser.getXSDRef((Element)node, temp, root)) == null) continue;
                temp = ((Element)node).getAttribute("name");
                parent.add(new AttributeNode(temp));
                continue;
            }
            if (node.getNamespaceURI().compareTo(STD_XSD_URI) != 0 || localname == null || localname.compareTo("attributeGroup") != 0) continue;
            temp = ((Element)node).getAttribute("name");
            if (temp != null) {
                XSDParser.getXSDAttribute(parent, (Element)node, root);
                continue;
            }
            temp = ((Element)node).getAttribute("ref");
            if (temp == null || (ref = XSDParser.getXSDRefAttributeGroup(node, temp, root)) == null) continue;
            XSDParser.getXSDAttribute(parent, ref, root);
        }
    }

    public static Element getXSDType(Node e, String typeName, Node root) {
        String attValue = null;
        String localname = null;
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || node.getNamespaceURI().compareTo(STD_XSD_URI) != 0 || (localname = node.getLocalName()).compareTo("simpleType") != 0 && localname.compareTo("complexType") != 0 || (attValue = ((Element)node).getAttribute("name")) == null || attValue.length() <= 0 || attValue.compareTo(typeName) != 0) continue;
            return (Element)node;
        }
        return null;
    }

    public static void getXSDSequence(DefaultMutableTreeNode parent, Element cur, Element root) {
        String localname = null;
        for (Node node = cur.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || node.getNamespaceURI().compareTo(STD_XSD_URI) != 0) continue;
            localname = node.getLocalName();
            if (localname.compareTo("element") == 0) {
                XSDParser.getXSDElement(parent, (Element)node, root);
                continue;
            }
            if (localname.compareTo("group") == 0) {
                XSDParser.getXSDGroup(parent, (Element)node, root);
                continue;
            }
            if (localname.compareTo("choice") == 0) {
                XSDParser.getXSDChoice(parent, (Element)node, root);
                continue;
            }
            if (localname.compareTo("sequence") != 0) continue;
            XSDParser.getXSDSequence(parent, (Element)node, root);
        }
    }

    public static void getXSDSimpleContent(DefaultMutableTreeNode parent, Element curnode, Element root) {
        XSDParser.getXSDComplexContent(parent, curnode, root);
    }

    public static void getXSDComplexContent(DefaultMutableTreeNode parent, Element curnode, Element root) {
        XSDParser.getXSDAttribute(parent, curnode, root);
        String localname = null;
        for (Node node = curnode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || node.getNamespaceURI().compareTo(STD_XSD_URI) != 0) continue;
            localname = node.getLocalName();
            if (localname.compareTo("restriction") == 0) {
                XSDParser.getXSDRestriction(parent, (Element)node, root);
                continue;
            }
            if (localname.compareTo("extension") != 0) continue;
            XSDParser.getXSDExtension(parent, (Element)node, root);
        }
    }

    public static void getXSDRestriction(DefaultMutableTreeNode parent, Element curnode, Element root) {
        XSDParser.getXSDAttribute(parent, curnode, root);
        String localname = null;
        for (Node node = curnode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || node.getNamespaceURI().compareTo(STD_XSD_URI) != 0) continue;
            localname = node.getLocalName();
            if (localname.compareTo("all") == 0) {
                XSDParser.getXSDAll(parent, (Element)node, root);
                continue;
            }
            if (localname.compareTo("choice") == 0) {
                XSDParser.getXSDChoice(parent, (Element)node, root);
                continue;
            }
            if (localname.compareTo("sequence") == 0) {
                XSDParser.getXSDSequence(parent, (Element)node, root);
                continue;
            }
            if (localname.compareTo("group") != 0) continue;
            XSDParser.getXSDGroup(parent, (Element)node, root);
        }
    }

    public static void getXSDExtension(DefaultMutableTreeNode parent, Element curnode, Element root) {
        XSDParser.getXSDAttribute(parent, curnode, root);
        String localname = null;
        for (Node node = curnode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || node.getNamespaceURI().compareTo(STD_XSD_URI) != 0) continue;
            localname = node.getLocalName();
            if (localname.compareTo("all") == 0) {
                XSDParser.getXSDAll(parent, (Element)node, root);
                continue;
            }
            if (localname.compareTo("choice") == 0) {
                XSDParser.getXSDChoice(parent, (Element)node, root);
                continue;
            }
            if (localname.compareTo("sequence") != 0) continue;
            XSDParser.getXSDSequence(parent, (Element)node, root);
        }
    }

    public static void getXSDGroup(DefaultMutableTreeNode parent, Element curnode, Element root) {
        String localname = null;
        for (Node node = curnode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || node.getNamespaceURI().compareTo(STD_XSD_URI) != 0) continue;
            localname = node.getLocalName();
            if (localname.compareTo("all") == 0) {
                XSDParser.getXSDAll(parent, (Element)node, root);
                continue;
            }
            if (localname.compareTo("choice") == 0) {
                XSDParser.getXSDChoice(parent, (Element)node, root);
                continue;
            }
            if (localname.compareTo("sequence") != 0) continue;
            XSDParser.getXSDSequence(parent, (Element)node, root);
        }
    }

    public static void getXSDAll(DefaultMutableTreeNode parent, Element curnode, Element root) {
        Object attValue = null;
        for (Node node = curnode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || node.getNamespaceURI().compareTo(STD_XSD_URI) != 0 || node.getLocalName().compareTo("element") != 0) continue;
            XSDParser.getXSDElement(parent, (Element)node, root);
        }
    }

    public static void getXSDChoice(DefaultMutableTreeNode parent, Element curnode, Element root) {
        Element node = XSDParser.getSuitableFirstSubElement(curnode);
        if (node == null) {
            return;
        }
        if (node.getNamespaceURI().compareTo(STD_XSD_URI) != 0) {
            return;
        }
        String localname = node.getLocalName();
        if (localname.compareTo("element") == 0) {
            XSDParser.getXSDElement(parent, node, root);
        } else if (localname.compareTo("group") == 0) {
            XSDParser.getXSDGroup(parent, node, root);
        } else if (localname.compareTo("choice") == 0) {
            XSDParser.getXSDChoice(parent, node, root);
        } else if (localname.compareTo("sequence") == 0) {
            XSDParser.getXSDSequence(parent, node, root);
        }
    }

    public static Element getXSDRefAttributeGroup(Node e, String attributeGroupName, Node root) {
        String attValue = null;
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || node.getNamespaceURI().compareTo(STD_XSD_URI) != 0 || node.getLocalName().compareTo("attributeGroup") != 0 || (attValue = ((Element)node).getAttribute("name")) == null || attValue.length() <= 0 || attValue.compareTo(attributeGroupName) != 0) continue;
            return (Element)node;
        }
        return null;
    }

    public static Element getXSDRef(Element e, String refName, Element root) {
        String attValue = null;
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || node.getNamespaceURI().compareTo(STD_XSD_URI) != 0 || node.getLocalName().compareTo("element") != 0 || (attValue = ((Element)node).getAttribute("name")) == null || attValue.length() <= 0 || attValue.compareTo(refName) != 0) continue;
            return (Element)node;
        }
        return null;
    }

    public static Element getSuitableFirstSubElement(Element parent) {
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || node.getNamespaceURI().compareTo(STD_XSD_URI) != 0 || node.getLocalName().compareTo("annotation") == 0) continue;
            return (Element)node;
        }
        return null;
    }

    public static Element getFirstSubElement(Element parent) {
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    public static void getXSDElement(DefaultMutableTreeNode parent, Element cur, Element root) {
        block21: {
            String type;
            Element typeElement;
            ElementNode child;
            String localname;
            block22: {
                block20: {
                    localname = cur.getLocalName();
                    if (cur.getNamespaceURI().compareTo(STD_XSD_URI) != 0) {
                        return;
                    }
                    if (localname.compareTo("element") != 0) {
                        return;
                    }
                    String a_name = cur.getAttribute("name");
                    if (a_name == null || a_name.length() == 0) {
                        String a_ref = cur.getAttribute("ref");
                        if (a_ref == null || a_ref.length() == 0) {
                            return;
                        }
                        Element refNode = XSDParser.getXSDRef(cur, a_ref, root);
                        if (refNode == null) {
                            return;
                        }
                        a_name = refNode.getAttribute("name");
                        cur = refNode;
                    }
                    if (a_name == null || a_name.length() == 0) {
                        return;
                    }
                    if (stack.indexOf(a_name) >= 0) {
                        return;
                    }
                    child = new ElementNode(a_name);
                    parent.add(child);
                    stack.push(a_name);
                    String a_type = null;
                    a_type = cur.getAttribute("type");
                    typeElement = null;
                    if (a_type == null || a_type.length() <= 0) break block20;
                    if (a_type.startsWith("xsd:")) break block21;
                    typeElement = XSDParser.getXSDType(cur, a_type, root);
                    break block22;
                }
                typeElement = XSDParser.getSuitableFirstSubElement(cur);
            }
            if (typeElement != null && (type = typeElement.getLocalName()).compareTo("complexType") == 0) {
                XSDParser.getXSDAttribute(child, typeElement, root);
                Element e3 = XSDParser.getSuitableFirstSubElement(typeElement);
                String localname1 = e3.getLocalName();
                if (e3.getNamespaceURI().compareTo(STD_XSD_URI) == 0 && localname1 != null && localname.length() != 0) {
                    if (localname1.compareTo("simpleContent") == 0) {
                        XSDParser.getXSDSimpleContent(child, e3, root);
                    } else if (localname1.compareTo("complexContnet") == 0) {
                        XSDParser.getXSDComplexContent(child, e3, root);
                    } else if (localname1.compareTo("group") == 0) {
                        XSDParser.getXSDGroup(child, e3, root);
                    } else if (localname1.compareTo("all") == 0) {
                        XSDParser.getXSDAll(child, e3, root);
                    } else if (localname1.compareTo("choice") == 0) {
                        XSDParser.getXSDChoice(child, e3, root);
                    } else if (localname1.compareTo("sequence") == 0) {
                        XSDParser.getXSDSequence(child, e3, root);
                    }
                }
            }
        }
        stack.pop();
    }

    public static AbstractXmlMutableTreeNode getTree(String fileName) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new File(fileName));
        Element e = document.getDocumentElement();
        String schema_uri = e.getNamespaceURI();
        if (schema_uri == null || schema_uri == null || !schema_uri.equalsIgnoreCase(STD_XSD_URI)) {
            ResourceBundle res = ResourceBundle.getBundle("com.syscom.xml.xtm.resource.Res", LocaleManager.getLocale());
            throw new Exception(res.getString("xtm_just_accept"));
        }
        String localname = e.getLocalName();
        if (localname == null || localname == null || !localname.equalsIgnoreCase("schema")) {
            ResourceBundle res = ResourceBundle.getBundle("com.syscom.xml.xtm.resource.Res", LocaleManager.getLocale());
            throw new Exception(GuiUt.mapStringForProperty(res.getString("invalid_root_element"), localname));
        }
        ElementNode root = new ElementNode("dummy");
        for (Node node = e.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !node.getNamespaceURI().equalsIgnoreCase(schema_uri) || node.getLocalName().compareTo("element") != 0) continue;
            XSDParser.getXSDElement(root, (Element)node, e);
        }
        return root;
    }
}

