/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.treetable;

import com.syscom.datatransfer.XTTDatatransfer;
import com.syscom.misc.XMLImageResource;
import com.syscom.misc.XMLTreeCellRenderer;
import com.syscom.misc.XTTTabbedPane;
import com.syscom.misc.XTTUt;
import com.syscom.treetable.AbstractCellEditor;
import com.syscom.treetable.TreeTableModel;
import com.syscom.treetable.TreeTableModelAdapter;
import com.syscom.treetable.XTTTableModel;
import com.syscom.treetable.eDragSource;
import com.syscom.undo.DeleteNodeUndoEdit;
import com.syscom.undo.DnDDocumentUndoEdit;
import com.syscom.undo.DnDTreeTableUndoEdit;
import com.syscom.undo.InsertNodeEdit;
import com.syscom.undo.LinkDocumentUndoEdit;
import com.syscom.ut.GuiUt;
import com.syscom.ut.PlatformUtil;
import com.syscom.ut.locale.LocaleChangeEvent;
import com.syscom.ut.locale.LocaleChangeListener;
import com.syscom.ut.locale.LocaleManager;
import com.syscom.xml.node.Attribute;
import com.syscom.xml.node.QueryElement;
import com.syscom.xml.node.Template;
import com.syscom.xml.node.display.AbstractDisplayPanel;
import com.syscom.xml.schema.SchemaTreeNodeInterface;
import com.syscom.xml.schema.node.Column;
import com.syscom.xml.xtt.console.XTTFrame;
import com.syscom.xml.xtt.dlg.CheckNodeTreeDlg;
import com.syscom.xml.xtt.dlg.DropTargetLinkDlg;
import com.syscom.xml.xtt.tree.CheckNode;
import com.syscom.xml.xtt.tree.XTTTree;
import com.syscom.xml.xttinterface.XTTTreeNodeInterface;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.EventObject;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.metal.MetalTreeUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JTreeTable
extends JTable
implements DragGestureListener,
DropTargetListener,
DragSourceListener,
LocaleChangeListener {
    ResourceBundle res = ResourceBundle.getBundle("com.syscom.treetable.resource.Res", LocaleManager.getLocale());
    protected TreeTableCellRenderer tree;
    protected DragSource dragSource = new eDragSource();
    protected DropTarget dropTarget;
    protected DragSourceContext dragSourceContext = null;
    public XTTTableModel treeTableModel;
    private Vector queryObjectVector = new Vector();
    protected TreePath selectedTreePath = null;
    private boolean freezeTree = false;
    private boolean resetTree = false;
    public int pre_sel_row = 0;

    public JTreeTable(XTTTableModel treeTableModel) {
        this.treeTableModel = treeTableModel;
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        this.dropTarget = new DropTarget(this, this);
        this.tree = new TreeTableCellRenderer(treeTableModel);
        TreeUI treeUI = this.tree.getUI();
        if (treeUI instanceof MetalTreeUI) {
            MetalTreeUI mTreeUI = (MetalTreeUI)treeUI;
            ImageIcon icon = XMLImageResource.getResource(this.tree.getClass(), "/xmlimages/minus.gif");
            mTreeUI.setExpandedIcon(icon);
            icon = XMLImageResource.getResource(this.tree.getClass(), "/xmlimages/plus.gif");
            mTreeUI.setCollapsedIcon(icon);
        }
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new XMLTreeCellRenderer());
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                JTreeTable.this.tree_valueChanged(e);
            }
        });
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
                JTreeTable.this.tree_treeWillExpand(e);
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent e) {
                JTreeTable.this.tree_treeWillCollapse(e);
            }
        });
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        this.setSelectionMode(0);
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.getTableHeader().setReorderingAllowed(false);
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.tree.getRowHeight() < 1) {
            this.setRowHeight(18);
        }
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    JTreeTable.this.treeTable_keyReleased(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                JTreeTable.this.treeTable_keyReleased(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                JTreeTable.this.treeTable_mouseReleased(e);
            }
        });
    }

    public void tree_treeWillCollapse(TreeExpansionEvent e) {
        try {
            TreePath path = e.getPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node == null) {
                return;
            }
            XTTTreeNodeInterface xtt2 = (XTTTreeNodeInterface)node.getUserObject();
            xtt2.setExpand(false);
        }
        catch (OutOfMemoryError oome) {
            GuiUt.showOutOfMemoryErrorDlg(oome);
        }
    }

    public void tree_treeWillExpand(TreeExpansionEvent e) {
        try {
            TreePath path = e.getPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node == null) {
                return;
            }
            XTTTreeNodeInterface xtt2 = (XTTTreeNodeInterface)node.getUserObject();
            xtt2.setExpand(true);
        }
        catch (OutOfMemoryError oome) {
            GuiUt.showOutOfMemoryErrorDlg(oome);
        }
    }

    public void treeTable_mouseReleased(MouseEvent e) {
        if (e.getModifiers() == 4) {
            Object obj = this.getValueAt(this.getSelectedRow(), 0);
            TreePath path = new TreePath(((DefaultMutableTreeNode)obj).getPath());
            if (path == null) {
                return;
            }
            XTTTreeNodeInterface xtt2 = (XTTTreeNodeInterface)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            xtt2.showPopup(e);
        }
    }

    public void treeTable_keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            XTTFrame.frame.Remove_MenuItem_actionPerformed(null);
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        Object sourceObj = this.getValueAt(this.getSelectedRow(), 0);
        TreePath tPath = new TreePath(((DefaultMutableTreeNode)sourceObj).getPath());
        if (tPath == null) {
            GuiUt.showErrorDlg(XTTFrame.frame, this.res.getString("Please_select_a_tree"), null);
            return;
        }
        this.tree.setSelectionPath(tPath);
        this.selectedTreePath = tPath;
        int dragTreeNodeLevel = ((DefaultMutableTreeNode)this.selectedTreePath.getLastPathComponent()).getLevel();
        if (dragTreeNodeLevel == 0 || dragTreeNodeLevel == 1) {
            return;
        }
        Cursor cursor = DragSource.DefaultMoveDrop;
        int action = e.getDragAction();
        Transferable transferable = null;
        Object obj = null;
        if (this.selectedTreePath != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.selectedTreePath.getLastPathComponent();
            obj = node.getUserObject();
            String[] sa = new String[]{"/xmlimages/add_child_cursor.gif", "/xmlimages/add_sibling_cursor.gif", "/xmlimages/link_cursor.gif"};
            int choice = 0;
            choice = XTTFrame.frame.px.getAddModeSettingForBoolean() ? (XTTFrame.frame.px.getNodeAsChildSettingForBoolean() ? 0 : 1) : 2;
            Image image = XMLImageResource.getResource(this.getClass(), sa[choice]).getImage();
            Point offset = new Point(0, 0);
            Cursor cursors = Toolkit.getDefaultToolkit().createCustomCursor(image, offset, "");
            if (obj instanceof QueryElement || obj instanceof Attribute) {
                transferable = (Transferable)obj;
            }
            if (obj instanceof Transferable) {
                this.dragSource.startDrag(e, cursors, transferable, this);
            }
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dsde) {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void drop(DropTargetDropEvent e) {
        block81: {
            action = e.getDropAction();
            v0 = copyAction = action == 1;
            if (copyAction) {
                e.acceptDrop(1);
            } else {
                e.acceptDrop(2);
            }
            try {
                block83: {
                    block85: {
                        block84: {
                            block82: {
                                tr = e.getTransferable();
                                if (!tr.isDataFlavorSupported(XTTDatatransfer.XTT_FLAVOR)) {
                                    e.rejectDrop();
                                }
                                obj = tr.getTransferData(XTTDatatransfer.XTT_FLAVOR);
                                targetObj = this.getValueAt(this.getSelectedRow(), 0);
                                targetTreePath = new TreePath(((DefaultMutableTreeNode)targetObj).getPath());
                                if (targetTreePath == null) {
                                    GuiUt.showErrorDlg(XTTFrame.frame, this.res.getString("Please_select_a_node"), null);
                                    return;
                                }
                                target_dmtn = (DefaultMutableTreeNode)targetTreePath.getLastPathComponent();
                                target_XTT = (XTTTreeNodeInterface)target_dmtn.getUserObject();
                                target_row = this.getSelectedRow();
                                targetNodeLevel = target_dmtn.getLevel();
                                if (targetNodeLevel == 0) {
                                    if (target_XTT.getChildren() != null) {
                                        if (target_XTT.getChildren().size() == 1) {
                                            if (XTTFrame.frame.px.getNodeAsChildSettingForBoolean()) {
                                                s1 = this.res.getString("Only_one_sub_element");
                                                s2 = GuiUt.mapStringForProperty(s1, target_XTT.toString());
                                                GuiUt.showErrorDlg(XTTFrame.frame, s2, null);
                                                return;
                                            }
                                            GuiUt.showErrorDlg(XTTFrame.frame, this.res.getString("XTT_template_node"), null);
                                            return;
                                        }
                                    } else if (!XTTFrame.frame.px.getNodeAsChildSettingForBoolean()) {
                                        GuiUt.showErrorDlg(XTTFrame.frame, this.res.getString("XTT_template_node"), null);
                                        return;
                                    }
                                }
                                if (targetNodeLevel == 1 && !XTTFrame.frame.px.getNodeAsChildSettingForBoolean() && XTTFrame.frame.px.getAddModeSettingForBoolean()) {
                                    s1 = this.res.getString("Only_one_sub_element");
                                    s2 = GuiUt.mapStringForProperty(s1, target_XTT.toString());
                                    GuiUt.showErrorDlg(XTTFrame.frame, s2, null);
                                    return;
                                }
                                if (!(target_XTT instanceof Attribute) || !XTTFrame.frame.px.getNodeAsChildSettingForBoolean()) break block82;
                                if (!(obj instanceof SchemaTreeNodeInterface)) ** GOTO lbl53
                                stni_obj = (SchemaTreeNodeInterface)obj;
                                if (stni_obj instanceof Column) {
                                    if (XTTFrame.frame.px.getAddModeSettingForBoolean() && XTTFrame.frame.px.getNodeAsChildSettingForBoolean()) {
                                        GuiUt.showErrorDlg(XTTFrame.frame, this.res.getString("Tree_ATTRIBUTE_node"), null);
                                        return;
                                    }
                                } else {
                                    if (!XTTFrame.frame.px.getAddModeSettingForBoolean()) {
                                        GuiUt.showErrorDlg(XTTFrame.frame, this.res.getString("Tree_ATTRIBUTE_node1"), null);
                                        return;
                                    }
                                    GuiUt.showErrorDlg(XTTFrame.frame, this.res.getString("Tree_ATTRIBUTE_node"), null);
                                    return;
lbl53:
                                    // 1 sources

                                    if (XTTFrame.frame.px.getAddModeSettingForBoolean()) {
                                        if (XTTFrame.frame.px.getNodeAsChildSettingForBoolean()) {
                                            GuiUt.showErrorDlg(XTTFrame.frame, this.res.getString("Tree_ATTRIBUTE_node"), null);
                                            return;
                                        }
                                    } else {
                                        GuiUt.showErrorDlg(XTTFrame.frame, this.res.getString("Please_change_tree"), null);
                                        return;
                                    }
                                }
                            }
                            if (!(obj instanceof SchemaTreeNodeInterface)) break block83;
                            stni = (SchemaTreeNodeInterface)obj;
                            if (!(stni instanceof Column)) break block84;
                            column = (Column)stni;
                            edit = new DnDDocumentUndoEdit(null, "command", null, false);
                            XTTFrame.frame.from = XTTFrame.frame.undoManager.getUndoQueueSize();
                            suitable_dmtn = XTTUt.searchSuitableElement(target_dmtn, column, edit);
                            if (suitable_dmtn == null) {
                                return;
                            }
                            suitable_qe = (QueryElement)suitable_dmtn.getUserObject();
                            if (XTTFrame.frame.px.getAddModeSettingForBoolean()) {
                                this.setCursor(Cursor.getPredefinedCursor(3));
                                columnQE = null;
                                columnATT = null;
                                column_dmtn = null;
                                if (XTTFrame.frame.px.getDndAsElementSettingForBoolean()) {
                                    columnQE = new QueryElement();
                                    columnQE.setLocalName(column.getColumnName());
                                    if (column.getColumnAliasName() != null) {
                                        columnQE.setTextValue("$" + suitable_qe.getQueryName() + "." + column.getColumnAliasName());
                                    } else {
                                        columnQE.setTextValue("$" + suitable_qe.getQueryName() + "." + column.getColumnName());
                                    }
                                    column_dmtn = new DefaultMutableTreeNode(columnQE);
                                    columnQE.setDefaultMutableTreeNode(column_dmtn);
                                } else {
                                    columnATT = new Attribute();
                                    columnATT.setName(column.getColumnName());
                                    if (column.getColumnAliasName() != null) {
                                        columnATT.setAttributeValue("$" + suitable_qe.getQueryName() + "." + column.getColumnAliasName());
                                    } else {
                                        columnATT.setAttributeValue("$" + suitable_qe.getQueryName() + "." + column.getColumnName());
                                    }
                                    column_dmtn = new DefaultMutableTreeNode(columnATT);
                                    columnATT.setDefaultMutableTreeNode(column_dmtn);
                                }
                                if (XTTFrame.frame.px.getNodeAsChildSettingForBoolean()) {
                                    break_line = 0;
                                    child_size = 0;
                                    if (target_XTT.getChildren() != null) {
                                        break_line = child_size = target_XTT.getChildren().size();
                                    }
                                    for (i = 0; i < child_size; ++i) {
                                        if (!(target_XTT.getChildren().elementAt(i) instanceof QueryElement)) continue;
                                        break_line = i;
                                        break;
                                    }
                                    if (!XTTFrame.frame.px.getDndAsElementSettingForBoolean()) {
                                        qe = (QueryElement)target_XTT;
                                        qe.addChildAt(columnATT, break_line);
                                        dnd_edit = new DnDTreeTableUndoEdit(this, target_row, columnATT);
                                        dnd_edit.addUndo(edit);
                                        XTTFrame.frame.undoSupport.postEdit(dnd_edit);
                                        XTTFrame.frame.menubar.setUndoEnabled(true);
                                        XTTFrame.frame.from = XTTFrame.frame.undoManager.getUndoQueueSize();
                                    } else {
                                        if (break_line == 0 && target_XTT.getChildren() != null) {
                                            break_line = target_XTT.getChildren().size();
                                        }
                                        target_XTT.addChild(columnQE);
                                        dnd_edit = new DnDTreeTableUndoEdit(this, target_row, columnQE);
                                        dnd_edit.addUndo(edit);
                                        XTTFrame.frame.undoSupport.postEdit(dnd_edit);
                                        XTTFrame.frame.menubar.setUndoEnabled(true);
                                        XTTFrame.frame.from = XTTFrame.frame.undoManager.getUndoQueueSize();
                                    }
                                    ((DefaultTreeModel)this.getTree().getModel()).insertNodeInto(column_dmtn, target_dmtn, break_line);
                                    p = new TreePath(column_dmtn.getPath());
                                    this.getTree().makeVisible(p);
                                    row = this.getTree().getRowForPath(p);
                                    this.getSelectionModel().setSelectionInterval(row, row);
                                    ((AbstractTableModel)this.getModel()).fireTableChanged(new TableModelEvent(this.getModel()));
                                } else {
                                    parentNode = (DefaultMutableTreeNode)target_dmtn.getParent();
                                    parentXTT = (XTTTreeNodeInterface)parentNode.getUserObject();
                                    if (parentXTT instanceof Template && parentXTT.getChildren() != null && parentXTT.getChildren().size() >= 1) {
                                        s1 = this.res.getString("Only_one_sub_element");
                                        s2 = GuiUt.mapStringForProperty(s1, target_XTT.toString());
                                        GuiUt.showWarningDlg(this, this.res.getString("Warning"), s2);
                                        return;
                                    }
                                    if (target_XTT.getParent() == null) {
                                        target_XTT.setParent(parentXTT);
                                    }
                                    if (XTTFrame.frame.px.getDndAsElementSettingForBoolean()) {
                                        columnQE.setParent(parentXTT);
                                        target_XTT.addNextSibling(columnQE);
                                        item_pos = parentXTT.getChildren().indexOf(columnQE);
                                        dnd_edit = new DnDTreeTableUndoEdit(this, target_row, columnQE);
                                        dnd_edit.addUndo(edit);
                                        XTTFrame.frame.undoSupport.postEdit(dnd_edit);
                                        XTTFrame.frame.menubar.setUndoEnabled(true);
                                        XTTFrame.frame.from = XTTFrame.frame.undoManager.getUndoQueueSize();
                                    } else {
                                        columnATT.setParent(parentXTT);
                                        target_XTT.addNextSibling(columnATT);
                                        item_pos = parentXTT.getChildren().indexOf(columnATT);
                                        dnd_edit = new DnDTreeTableUndoEdit(this, target_row, columnATT);
                                        dnd_edit.addUndo(edit);
                                        XTTFrame.frame.undoSupport.postEdit(dnd_edit);
                                        XTTFrame.frame.menubar.setUndoEnabled(true);
                                        XTTFrame.frame.from = XTTFrame.frame.undoManager.getUndoQueueSize();
                                    }
                                    ((DefaultTreeModel)this.getTree().getModel()).insertNodeInto(column_dmtn, parentNode, item_pos);
                                    p = new TreePath(column_dmtn.getPath());
                                    this.getTree().makeVisible(p);
                                    row = this.getTree().getRowForPath(p);
                                    this.getSelectionModel().setSelectionInterval(row, row);
                                    ((AbstractTableModel)this.getModel()).fireTableChanged(new TableModelEvent(this.getModel()));
                                }
                                this.setCursor(Cursor.getPredefinedCursor(0));
                            } else {
                                this.setCursor(Cursor.getPredefinedCursor(3));
                                if (target_XTT instanceof QueryElement) {
                                    qee = (QueryElement)target_XTT;
                                    old_data = qee.getTextValue();
                                    if (column.getColumnAliasName() != null) {
                                        qee.setTextValue("$" + suitable_qe.getQueryName() + "." + column.getColumnAliasName());
                                    } else {
                                        qee.setTextValue("$" + suitable_qe.getQueryName() + "." + column.getColumnName());
                                    }
                                    qee.setLinkTextValue(qee.getTextValue());
                                    if (XTTFrame.frame.from >= 0) {
                                        XTTFrame.frame.undoManager.trimEdits(XTTFrame.frame.from, XTTFrame.frame.undoManager.getUndoQueueSize() - 1);
                                    } else {
                                        XTTFrame.frame.undoManager.trimEdits(0, XTTFrame.frame.undoManager.getUndoQueueSize() - 1);
                                    }
                                    edits = new DnDDocumentUndoEdit(qee, "textValue", old_data, true);
                                    XTTFrame.frame.undoSupport.postEdit(edits);
                                    XTTFrame.frame.menubar.setUndoEnabled(true);
                                    XTTFrame.frame.from = XTTFrame.frame.undoManager.getUndoQueueSize();
                                    XTTFrame.frame.setSelectedNode(qee.getDefaultMutableTreeNode());
                                } else {
                                    attb = (Attribute)target_XTT;
                                    old_data = attb.getValue();
                                    if (column.getColumnAliasName() != null) {
                                        attb.setAttributeValue("$" + suitable_qe.getQueryName() + "." + column.getColumnAliasName());
                                    } else {
                                        attb.setAttributeValue("$" + suitable_qe.getQueryName() + "." + column.getColumnName());
                                    }
                                    attb.setLinkValue(attb.getValue());
                                    if (XTTFrame.frame.from >= 0) {
                                        XTTFrame.frame.undoManager.trimEdits(XTTFrame.frame.from, XTTFrame.frame.undoManager.getUndoQueueSize() - 1);
                                    } else {
                                        XTTFrame.frame.undoManager.trimEdits(0, XTTFrame.frame.undoManager.getUndoQueueSize() - 1);
                                    }
                                    undo_edit = new DnDDocumentUndoEdit(attb, "attributeValue", old_data, true);
                                    XTTFrame.frame.undoSupport.postEdit(undo_edit);
                                    XTTFrame.frame.menubar.setUndoEnabled(true);
                                    XTTFrame.frame.from = XTTFrame.frame.undoManager.getUndoQueueSize();
                                    XTTFrame.frame.setSelectedNode(attb.getDefaultMutableTreeNode());
                                }
                                this.setCursor(Cursor.getPredefinedCursor(0));
                                XTTFrame.frame.refreshTree(target_dmtn, (DefaultMutableTreeNode)target_dmtn.getParent());
                                this.tree.setSelectionPath(new TreePath(target_XTT.getDefaultMutableTreeNode().getPath()));
                            }
                            break block85;
                        }
                        if (!XTTFrame.frame.px.getAddModeSettingForBoolean()) ** GOTO lbl258
                        selectedNode = (CheckNode)XTTFrame.frame.tree1.getLastSelectedPathComponent();
                        dlg = new CheckNodeTreeDlg((Frame)XTTFrame.frame, selectedNode, target_dmtn);
                        GuiUt.setCenterLocation(XTTFrame.frame, dlg);
                        dlg.setModal(true);
                        dlg.setSize(400, 480);
                        if (XTTFrame.frame.px.getShowCustomizedNodeForBoolean()) {
                            dlg.queryObjectNameTextField.requestFocus();
                            dlg.show();
                        } else {
                            this.setCursor(Cursor.getPredefinedCursor(3));
                            dlg.okButton_actionPerformed(null);
                            this.setCursor(Cursor.getPredefinedCursor(0));
                        }
                        result = dlg.getResult();
                        if (result != null) {
                            this.setCursor(Cursor.getPredefinedCursor(3));
                            cn = XTTTree.getShortTree(result);
                            result.setDefaultMutableTreeNode(cn);
                            if (XTTFrame.frame.px.getNodeAsChildSettingForBoolean()) {
                                target_dmtn.add(cn);
                                target_XTT.addChild(result);
                                p = new TreePath(cn.getPath());
                                this.getTree().makeVisible(p);
                                row = this.getTree().getRowForPath(p);
                                this.getSelectionModel().setSelectionInterval(row, row);
                                ((AbstractTableModel)this.getModel()).fireTableChanged(new TableModelEvent(this.getModel()));
                                this.setCursor(Cursor.getPredefinedCursor(0));
                                XTTFrame.frame.refreshTree(target_dmtn, (DefaultMutableTreeNode)target_dmtn.getParent());
                                XTTFrame.frame.setAfterActionTreePath(target_dmtn, result);
                                edit = new InsertNodeEdit(this, target_row, result);
                                XTTFrame.frame.undoSupport.postEdit(edit);
                                XTTFrame.frame.menubar.setUndoEnabled(true);
                                XTTFrame.frame.from = XTTFrame.frame.undoManager.getUndoQueueSize();
                            } else {
                                parentNode = (DefaultMutableTreeNode)target_dmtn.getParent();
                                parentXTT = (XTTTreeNodeInterface)parentNode.getUserObject();
                                if (target_XTT.getParent() == null) {
                                    target_XTT.setParent(parentXTT);
                                }
                                target_XTT.addNextSibling(result);
                                item_pos = parentXTT.getChildren().indexOf(result);
                                ((DefaultTreeModel)this.getTree().getModel()).insertNodeInto(cn, parentNode, item_pos);
                                p = new TreePath(cn.getPath());
                                this.getTree().makeVisible(p);
                                row = this.getTree().getRowForPath(p);
                                this.getSelectionModel().setSelectionInterval(row, row);
                                ((AbstractTableModel)this.getModel()).fireTableChanged(new TableModelEvent(this.getModel()));
                                this.setCursor(Cursor.getPredefinedCursor(0));
                                edit = new InsertNodeEdit(this, target_row, result);
                                XTTFrame.frame.undoSupport.postEdit(edit);
                                XTTFrame.frame.menubar.setUndoEnabled(true);
                                XTTFrame.frame.from = XTTFrame.frame.undoManager.getUndoQueueSize();
                            }
                            dlg.dispose();
                        } else {
                            dlg.dispose();
                            return;
lbl258:
                            // 1 sources

                            selectedNode = (CheckNode)XTTFrame.frame.tree1.getLastSelectedPathComponent();
                            if (target_dmtn.isLeaf()) {
                                GuiUt.showErrorDlg(XTTFrame.frame, this.res.getString("The_target_tree_node"), null);
                                return;
                            }
                            link_edit = new LinkDocumentUndoEdit(target_row);
                            dlg = new DropTargetLinkDlg((Frame)XTTFrame.frame, selectedNode, target_dmtn, link_edit);
                            GuiUt.setCenterLocation(XTTFrame.frame, dlg);
                            dlg.setSize(400, 480);
                            dlg.show();
                            XTTFrame.frame.refreshTree(target_dmtn, (DefaultMutableTreeNode)target_dmtn.getParent());
                            row = this.getTree().getRowForPath(targetTreePath);
                            this.getSelectionModel().setSelectionInterval(row, row);
                            ((AbstractTableModel)this.getModel()).fireTableChanged(new TableModelEvent(this.getModel()));
                            XTTFrame.frame.undoSupport.postEdit(link_edit);
                            XTTFrame.frame.menubar.setUndoEnabled(true);
                            XTTFrame.frame.from = XTTFrame.frame.undoManager.getUndoQueueSize();
                            dlg.dispose();
                        }
                    }
                    XTTFrame.setXTTModified(true);
                    XTTFrame.frame.refresh_XTTCombo();
                    break block81;
                }
                msg = this.testDropTarget(targetTreePath, this.selectedTreePath);
                if (msg != null) {
                    e.rejectDrop();
                    GuiUt.showErrorDlg(XTTFrame.frame, msg, null);
                    return;
                }
                root_dmtn = (DefaultMutableTreeNode)this.tree.getPathForRow(0).getLastPathComponent();
                source_dmtn = (DefaultMutableTreeNode)this.selectedTreePath.getLastPathComponent();
                source_XTT = (XTTTreeNodeInterface)source_dmtn.getUserObject();
                source_dmtn_parent = (DefaultMutableTreeNode)source_dmtn.getParent();
                source_XTT_parent = (XTTTreeNodeInterface)source_dmtn_parent.getUserObject();
                target_dmtn_parents = (DefaultMutableTreeNode)target_dmtn.getParent();
                target_XTT_parents = (XTTTreeNodeInterface)target_dmtn_parents.getUserObject();
                if (source_XTT instanceof Attribute && !source_XTT_parent.equals(target_XTT_parents)) {
                    source_XTT_att = (Attribute)source_XTT;
                    if (XTTFrame.frame.px.getNodeAsChildSettingForBoolean()) {
                        if (XTTUt.isDuplicateAttributeNameInDropAction(source_XTT_att.getName(), target_XTT)) {
                            GuiUt.showErrorDlg(XTTFrame.frame, this.res.getString("This_attribute_name"), null);
                            return;
                        }
                    } else {
                        if (target_XTT.getParent() == null) {
                            target_XTT.setParent(target_XTT_parents);
                        }
                        if (XTTUt.isDuplicateAttributeNameInDropAction(source_XTT_att.getName(), target_XTT.getParent())) {
                            GuiUt.showErrorDlg(XTTFrame.frame, this.res.getString("This_attribute_name"), null);
                            return;
                        }
                    }
                }
                node = (XTTTreeNodeInterface)obj;
                target_dmtn_parent = null;
                target_XTT_parent = null;
                drop_dmtn = null;
                try {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    d_edit = null;
                    if (XTTFrame.frame.px.getNodeAsChildSettingForBoolean()) {
                        if (!copyAction) {
                            dmtn_pos = source_dmtn_parent.getIndex(source_dmtn);
                            xtt_pos = source_XTT_parent.getChildren().indexOf(source_XTT);
                            source_dmtn.removeFromParent();
                            source_XTT_parent.remove(node);
                            d_edit = new DeleteNodeUndoEdit(this, node, source_XTT_parent, dmtn_pos, xtt_pos);
                        }
                        break_line = 0;
                        child_size = 0;
                        if (target_XTT.getChildren() != null) {
                            break_line = child_size = target_XTT.getChildren().size();
                        }
                        if (node instanceof Attribute) {
                            for (i = 0; i < child_size; ++i) {
                                if (!(target_XTT.getChildren().elementAt(i) instanceof QueryElement)) continue;
                                break_line = i;
                                break;
                            }
                        }
                        qe = (QueryElement)target_XTT;
                        qe.addChildAt(node, break_line);
                        drop_dmtn = copyAction != false ? XTTTree.getShortTree(node) : node.getDefaultMutableTreeNode();
                        node.setDefaultMutableTreeNode(drop_dmtn);
                        ((DefaultTreeModel)this.getTree().getModel()).insertNodeInto(drop_dmtn, target_dmtn, break_line);
                        p = new TreePath(drop_dmtn.getPath());
                        this.getTree().makeVisible(p);
                        row = this.getTree().getRowForPath(p);
                        this.getSelectionModel().setSelectionInterval(row, row);
                        ((AbstractTableModel)this.getModel()).fireTableChanged(new TableModelEvent(this.getModel()));
                    } else {
                        target_dmtn_parent = (DefaultMutableTreeNode)target_dmtn.getParent();
                        target_XTT_parent = (XTTTreeNodeInterface)target_dmtn_parent.getUserObject();
                        if (target_XTT_parent instanceof Template && target_XTT_parent.getChildren() != null && target_XTT_parent.getChildren().size() >= 1) {
                            s1 = this.res.getString("Only_one_sub_element");
                            s2 = GuiUt.mapStringForProperty(s1, target_XTT.toString());
                            GuiUt.showWarningDlg(this, this.res.getString("Warning"), s2);
                            return;
                        }
                        if (!copyAction) {
                            dmtn_pos = source_dmtn_parent.getIndex(source_dmtn);
                            xtt_pos = source_XTT_parent.getChildren().indexOf(source_XTT);
                            source_dmtn.removeFromParent();
                            source_XTT_parent.remove(node);
                            d_edit = new DeleteNodeUndoEdit(this, node, source_XTT_parent, dmtn_pos, xtt_pos);
                        }
                        if (target_XTT.getParent() == null) {
                            target_XTT.setParent(target_XTT_parent);
                        }
                        target_XTT.addNextSibling(node);
                        item_pos = target_XTT_parent.getChildren().indexOf(node);
                        drop_dmtn = copyAction != false ? XTTTree.getShortTree(node) : node.getDefaultMutableTreeNode();
                        node.setDefaultMutableTreeNode(drop_dmtn);
                        ((DefaultTreeModel)this.getTree().getModel()).insertNodeInto(drop_dmtn, target_dmtn_parent, item_pos);
                        p = new TreePath(drop_dmtn.getPath());
                        this.getTree().makeVisible(p);
                        row = this.getTree().getRowForPath(p);
                        this.getSelectionModel().setSelectionInterval(row, row);
                        ((AbstractTableModel)this.getModel()).fireTableChanged(new TableModelEvent(this.getModel()));
                    }
                    edit = new InsertNodeEdit(this, target_row, node, true);
                    if (d_edit != null) {
                        edit.addUndo(d_edit);
                    }
                    XTTFrame.frame.undoSupport.postEdit(edit);
                    XTTFrame.frame.menubar.setUndoEnabled(true);
                    XTTFrame.frame.from = XTTFrame.frame.undoManager.getUndoQueueSize();
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
                catch (IllegalStateException ils) {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    GuiUt.showErrorDlg(XTTFrame.frame, ils.getMessage(), null);
                    e.rejectDrop();
                }
                e.getDropTargetContext().dropComplete(true);
                this.selectedTreePath = targetTreePath;
                if (XTTFrame.frame.px.getNodeAsChildSettingForBoolean()) {
                    XTTFrame.frame.refreshTree(source_dmtn_parent, null);
                    XTTFrame.frame.refreshTree(source_dmtn, source_dmtn_parent);
                    XTTFrame.frame.refreshTree(target_dmtn, target_dmtn_parent);
                    XTTFrame.frame.setAfterActionTreePath(target_dmtn, node);
                } else {
                    XTTFrame.frame.refreshTree(source_dmtn_parent, null);
                    XTTFrame.frame.refreshTree(source_dmtn, source_dmtn_parent);
                    XTTFrame.frame.refreshTree(target_dmtn_parent, null);
                    XTTFrame.frame.setAfterActionTreePath(target_dmtn_parent, node);
                }
                XTTFrame.setXTTModified(true);
                XTTFrame.frame.refresh_XTTCombo();
            }
            catch (IllegalArgumentException ilae) {
                this.setCursor(Cursor.getPredefinedCursor(0));
                GuiUt.showErrorDlg(XTTFrame.frame, ilae.getMessage(), null);
                e.rejectDrop();
            }
            catch (IOException io) {
                this.setCursor(Cursor.getPredefinedCursor(0));
                GuiUt.showErrorDlg(XTTFrame.frame, io.getMessage(), null);
                e.rejectDrop();
            }
            catch (UnsupportedFlavorException ufe) {
                this.setCursor(Cursor.getPredefinedCursor(0));
                GuiUt.showErrorDlg(XTTFrame.frame, ufe.getMessage(), null);
                e.rejectDrop();
            }
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
    }

    @Override
    public void dragExit(DropTargetEvent e) {
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        Point loc = e.getLocation();
        int row = this.rowAtPoint(loc);
        this.setRowSelectionInterval(row, row);
        this.invalidate();
        Rectangle rect = this.getCellRect(row, 0, true);
        this.scrollRectToVisible(rect);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
        this.res = ResourceBundle.getBundle("com.syscom.treetable.resource.Res", LocaleManager.getLocale());
    }

    private String testDropTarget(TreePath destination, TreePath dropper) {
        boolean destinationPathIsNull;
        boolean bl = destinationPathIsNull = destination == null;
        if (destinationPathIsNull) {
            return this.res.getString("Invalid_drop_location");
        }
        Object obj = destination.getLastPathComponent();
        if (obj instanceof Attribute) {
            return this.res.getString("This_node_does_not");
        }
        if (destination.equals(dropper)) {
            return this.res.getString("Destination_cannot_be");
        }
        if (dropper.isDescendant(destination)) {
            return this.res.getString("Destination_node");
        }
        if (dropper.getParentPath().equals(destination)) {
            return this.res.getString("Destination_node1");
        }
        return null;
    }

    public void tree_valueChanged(TreeSelectionEvent e) {
        System.out.println("tree valueChanged : start : freezeTree=" + this.freezeTree);
        if (!this.resetTree) {
            if (XTTFrame.frame.getBottomPanel() != null) {
                ((AbstractDisplayPanel)((JTabbedPane)XTTFrame.frame.getBottomPanel()).getSelectedComponent()).stopEditing();
            }
            if (!this.freezeTree) {
                TreePath p = e.getNewLeadSelectionPath();
                if (p == null) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)p.getLastPathComponent();
                if (node == null) {
                    return;
                }
                XTTTreeNodeInterface obj = (XTTTreeNodeInterface)node.getUserObject();
                XTTFrame.frame.setButtonStatus(obj);
                AbstractDisplayPanel[] comps = obj.getDisplayComponent();
                XTTTabbedPane t = new XTTTabbedPane(comps);
                XTTFrame.frame.setBottomPanel(t);
            } else {
                TreePath p = e.getOldLeadSelectionPath();
                if (p != null) {
                    this.resetTree = true;
                    System.out.println("reset selection = " + p);
                    this.getTree().setSelectionPath(p);
                    this.resetTree = false;
                    System.out.println("after reset selection");
                }
            }
        }
        System.out.println("tree valueChanged : end : freezeTree=" + this.freezeTree);
    }

    public void setResetTree(boolean stat) {
        this.resetTree = stat;
    }

    public boolean getResetTree() {
        return this.resetTree;
    }

    public void setFreezeTree(boolean stat) {
        System.out.println("set freeze = " + stat);
        this.freezeTree = stat;
    }

    public boolean getFreezeTree() {
        return this.freezeTree;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.tree != null && this.tree.getRowHeight() != rowHeight) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public Vector getQueryObjectVector() {
        return this.queryObjectVector;
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;
        private int pre_sel = -1;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows(ListSelectionEvent e) {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    if (JTreeTable.this.freezeTree && this.pre_sel != -1) {
                        System.out.println("reset selection = " + this.pre_sel);
                        this.listSelectionModel.setSelectionInterval(this.pre_sel, this.pre_sel);
                        JTreeTable.this.freezeTree = false;
                        XTTFrame.frame.nextFocus();
                        return;
                    }
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    if (min != -1 && max != -1 && min == max) {
                        TreePath selPath = JTreeTable.this.tree.getPathForRow(min);
                        if (selPath != null) {
                            JTreeTable.this.tree.setSelectionPath(selPath);
                            this.pre_sel = min;
                            JTreeTable.this.pre_sel_row = min;
                        }
                    } else if (this.pre_sel != -1) {
                        this.listSelectionModel.setSelectionInterval(this.pre_sel, this.pre_sel);
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows(e);
            }
        }
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            return JTreeTable.this.tree;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                for (int counter = JTreeTable.this.getColumnCount() - 1; counter >= 0; --counter) {
                    if (JTreeTable.this.getColumnClass(counter) != TreeTableModel.class) continue;
                    MouseEvent me = (MouseEvent)e;
                    MouseEvent newME = new MouseEvent(JTreeTable.this.tree, me.getID(), me.getWhen(), me.getModifiers(), me.getX() - JTreeTable.this.getCellRect((int)0, (int)counter, (boolean)true).x, me.getY(), me.getClickCount(), me.isPopupTrigger());
                    JTreeTable.this.tree.dispatchEvent(newME);
                    break;
                }
            }
            return false;
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;

        public TreeTableCellRenderer(TreeModel model) {
            super(model);
            this.getSelectionModel().setSelectionMode(1);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                dtcr.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                dtcr.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        @Override
        public void setRowHeight(int rowHeight) {
            if (rowHeight > 0) {
                super.setRowHeight(rowHeight);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != rowHeight) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, JTreeTable.this.getHeight());
        }

        @Override
        public void paint(Graphics g) {
            g.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(g);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.visibleRow = row;
            return this;
        }
    }
}

