/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template.builder;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.msgpack.MessageTypeException;
import org.msgpack.packer.Packer;
import org.msgpack.template.Template;
import org.msgpack.template.builder.FieldEntry;
import org.msgpack.template.builder.JavassistTemplateBuilder;
import org.msgpack.template.builder.TemplateBuildException;
import org.msgpack.unpacker.Unpacker;

public abstract class BuildContext<T extends FieldEntry> {
    private static Logger a = Logger.getLogger(BuildContext.class.getName());
    protected JavassistTemplateBuilder director;
    protected String tmplName;
    protected CtClass tmplCtClass;
    protected StringBuilder stringBuilder = null;

    protected abstract Template buildTemplate(Class<?> var1, T[] var2, Template[] var3);

    protected abstract void setSuperClass() throws CannotCompileException, NotFoundException;

    protected abstract void buildConstructor() throws CannotCompileException, NotFoundException;

    /*
     * WARNING - void declaration
     */
    public BuildContext(JavassistTemplateBuilder director) {
        void var1_1;
        this.director = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected Template build(String className) {
        try {
            void var1_1;
            this.reset(className, false);
            a.fine(String.format("started generating template class %s for original class %s", this.tmplCtClass.getName(), className));
            this.buildClass();
            this.buildConstructor();
            this.buildMethodInit();
            this.buildWriteMethod();
            this.buildReadMethod();
            a.fine(String.format("finished generating template class %s for original class %s", this.tmplCtClass.getName(), var1_1));
            BuildContext buildContext = this;
            return buildContext.buildInstance(buildContext.createClass());
        }
        catch (Exception exception) {
            String string = this.getBuiltString();
            if (string != null) {
                a.severe("builder: " + string);
                throw new TemplateBuildException("Cannot compile: " + string, exception);
            }
            throw new TemplateBuildException(exception);
        }
    }

    protected void reset(String className, boolean isWritten) {
        String string;
        string = !isWritten ? className + "_$$_Template_" + this.director.hashCode() + "_" + this.director.nextSeqId() : string + "_$$_Template";
        this.tmplCtClass = this.director.makeCtClass(string);
    }

    protected void buildClass() throws CannotCompileException, NotFoundException {
        this.setSuperClass();
        this.tmplCtClass.addInterface(this.director.getCtClass(Template.class.getName()));
    }

    protected void buildMethodInit() {
    }

    protected abstract Template buildInstance(Class<?> var1) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException;

    protected void buildWriteMethod() throws CannotCompileException, NotFoundException {
        a.fine(String.format("started generating write method in template class %s", this.tmplCtClass.getName()));
        Object object = this.buildWriteMethodBody();
        CtClass ctClass = CtClass.voidType;
        String string = "write";
        CtClass[] ctClassArray = new CtClass[]{this.director.getCtClass(Packer.class.getName()), this.director.getCtClass(Object.class.getName()), CtClass.booleanType};
        CtClass[] ctClassArray2 = new CtClass[]{this.director.getCtClass(IOException.class.getName())};
        a.fine(String.format("compiling write method body: %s", object));
        object = CtNewMethod.make(1, ctClass, string, ctClassArray, ctClassArray2, (String)object, this.tmplCtClass);
        this.tmplCtClass.addMethod((CtMethod)object);
        a.fine(String.format("finished generating write method in template class %s", this.tmplCtClass.getName()));
    }

    protected abstract String buildWriteMethodBody();

    protected void buildReadMethod() throws CannotCompileException, NotFoundException {
        a.fine(String.format("started generating read method in template class %s", this.tmplCtClass.getName()));
        Object object = this.buildReadMethodBody();
        CtClass ctClass = this.director.getCtClass(Object.class.getName());
        String string = "read";
        CtClass[] ctClassArray = new CtClass[]{this.director.getCtClass(Unpacker.class.getName()), this.director.getCtClass(Object.class.getName()), CtClass.booleanType};
        CtClass[] ctClassArray2 = new CtClass[]{this.director.getCtClass(MessageTypeException.class.getName())};
        a.fine(String.format("compiling read method body: %s", object));
        object = CtNewMethod.make(1, ctClass, string, ctClassArray, ctClassArray2, (String)object, this.tmplCtClass);
        this.tmplCtClass.addMethod((CtMethod)object);
        a.fine(String.format("finished generating read method in template class %s", this.tmplCtClass.getName()));
    }

    protected abstract String buildReadMethodBody();

    protected Class<?> createClass() throws CannotCompileException {
        return this.tmplCtClass.toClass(this.director.getClassLoader(), this.getClass().getProtectionDomain());
    }

    /*
     * WARNING - void declaration
     */
    protected void saveClass(String directoryName) throws CannotCompileException, IOException {
        void var1_1;
        this.tmplCtClass.writeFile((String)var1_1);
    }

    protected void resetStringBuilder() {
        this.stringBuilder = new StringBuilder();
    }

    /*
     * WARNING - void declaration
     */
    protected void buildString(String str) {
        void var1_1;
        this.stringBuilder.append((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void buildString(String format, Object ... args) {
        void var2_2;
        void var1_1;
        this.stringBuilder.append(String.format((String)var1_1, (Object[])var2_2));
    }

    protected String getBuiltString() {
        if (this.stringBuilder == null) {
            return null;
        }
        return this.stringBuilder.toString();
    }

    protected String primitiveWriteName(Class<?> type) {
        return "write";
    }

    /*
     * WARNING - void declaration
     */
    protected String primitiveReadName(Class<?> type) {
        void var1_1;
        if (type == Boolean.TYPE) {
            return "readBoolean";
        }
        if (type == Byte.TYPE) {
            return "readByte";
        }
        if (type == Short.TYPE) {
            return "readShort";
        }
        if (type == Integer.TYPE) {
            return "readInt";
        }
        if (type == Long.TYPE) {
            return "readLong";
        }
        if (type == Float.TYPE) {
            return "readFloat";
        }
        if (type == Double.TYPE) {
            return "readDouble";
        }
        if (var1_1 == Character.TYPE) {
            return "readInt";
        }
        return null;
    }

    protected abstract void writeTemplate(Class<?> var1, T[] var2, Template[] var3, String var4);

    /*
     * WARNING - void declaration
     */
    protected void write(String className, String directoryName) {
        String string;
        try {
            void var1_1;
            this.reset((String)var1_1, true);
            this.buildClass();
            this.buildConstructor();
            this.buildMethodInit();
            this.buildWriteMethod();
            this.buildReadMethod();
            this.saveClass(string);
            return;
        }
        catch (Exception exception) {
            string = this.getBuiltString();
            if (string != null) {
                a.severe("builder: " + string);
                throw new TemplateBuildException("Cannot compile: " + string, exception);
            }
            throw new TemplateBuildException(exception);
        }
    }

    protected abstract Template loadTemplate(Class<?> var1, T[] var2, Template[] var3);

    protected Template load(String className) {
        Object object;
        object = (String)object + "_$$_Template";
        try {
            object = this.getClass().getClassLoader().loadClass((String)object);
            return this.buildInstance((Class<?>)object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (Exception exception) {
            String string = this.getBuiltString();
            if (string != null) {
                a.severe("builder: " + string);
                throw new TemplateBuildException("Cannot compile: " + string, exception);
            }
            throw new TemplateBuildException(exception);
        }
    }
}

