/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template.builder;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.msgpack.MessageTypeException;
import org.msgpack.packer.Packer;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.template.BooleanArrayTemplate;
import org.msgpack.template.ByteArrayTemplate;
import org.msgpack.template.DoubleArrayTemplate;
import org.msgpack.template.FieldList;
import org.msgpack.template.FloatArrayTemplate;
import org.msgpack.template.IntegerArrayTemplate;
import org.msgpack.template.LongArrayTemplate;
import org.msgpack.template.ObjectArrayTemplate;
import org.msgpack.template.ShortArrayTemplate;
import org.msgpack.template.Template;
import org.msgpack.template.TemplateRegistry;
import org.msgpack.template.builder.AbstractTemplateBuilder;
import org.msgpack.template.builder.FieldEntry;
import org.msgpack.template.builder.TemplateBuildException;
import org.msgpack.unpacker.Unpacker;

public class ArrayTemplateBuilder
extends AbstractTemplateBuilder {
    private static final Logger a = Logger.getLogger(ArrayTemplateBuilder.class.getName());

    /*
     * WARNING - void declaration
     */
    public ArrayTemplateBuilder(TemplateRegistry registry) {
        super((TemplateRegistry)var1_1);
        void var1_1;
    }

    @Override
    public boolean matchType(Type targetType, boolean forceBuild) {
        Class clazz = (Class)targetType;
        boolean bl = AbstractTemplateBuilder.matchAtArrayTemplateBuilder(clazz, false);
        if (bl && a.isLoggable(Level.FINE)) {
            a.fine("matched type: " + clazz.getName());
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> Template<T> buildTemplate(Type arrayType) {
        void var1_1;
        Class clazz;
        Type type;
        int n2 = 1;
        if (arrayType instanceof GenericArrayType) {
            type = (GenericArrayType)arrayType;
            type = type.getGenericComponentType();
            while (type instanceof GenericArrayType) {
                type = type.getGenericComponentType();
                ++n2;
            }
            clazz = type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (Class)type;
        } else {
            type = (Class)arrayType;
            clazz = ((Class)type).getComponentType();
            while (clazz.isArray()) {
                clazz = clazz.getComponentType();
                ++n2;
            }
            type = clazz;
        }
        return this.a((Type)var1_1, type, clazz, n2);
    }

    private Template a(Type clazz, Type type, Class clazz2, int n2) {
        if (n2 == 1) {
            if (clazz2 == Boolean.TYPE) {
                return BooleanArrayTemplate.getInstance();
            }
            if (clazz2 == Short.TYPE) {
                return ShortArrayTemplate.getInstance();
            }
            if (clazz2 == Integer.TYPE) {
                return IntegerArrayTemplate.getInstance();
            }
            if (clazz2 == Long.TYPE) {
                return LongArrayTemplate.getInstance();
            }
            if (clazz2 == Float.TYPE) {
                return FloatArrayTemplate.getInstance();
            }
            if (clazz2 == Double.TYPE) {
                return DoubleArrayTemplate.getInstance();
            }
            if (clazz2 == Byte.TYPE) {
                return ByteArrayTemplate.getInstance();
            }
            Template template = this.registry.lookup(type);
            return new ObjectArrayTemplate(clazz2, template);
        }
        if (n2 == 2) {
            Class<?> clazz3 = Array.newInstance(clazz2, 0).getClass();
            clazz = this.a(clazz, type, clazz2, n2 - 1);
            return new a(clazz3, (Template)((Object)clazz));
        }
        a a2 = (a)this.a(clazz, type, clazz2, n2 - 1);
        clazz = Array.newInstance(a2.a(), 0).getClass();
        return new a(clazz, a2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> Template<T> buildTemplate(Class<T> targetClass, FieldList flist) throws TemplateBuildException {
        void var1_1;
        throw new UnsupportedOperationException(var1_1.getName());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected <T> Template<T> buildTemplate(Class<T> targetClass, FieldEntry[] entries) {
        void var1_1;
        throw new UnsupportedOperationException(var1_1.getName());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeTemplate(Type targetType, String directoryName) {
        void var1_1;
        throw new UnsupportedOperationException(var1_1.toString());
    }

    @Override
    public <T> Template<T> loadTemplate(Type targetType) {
        return null;
    }

    static final class a
    extends AbstractTemplate {
        private Class a;
        private Template b;

        public a(Class clazz, Template template) {
            this.a = clazz;
            this.b = template;
        }

        final Class a() {
            return this.a;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(Packer packer, Object v, boolean required) throws IOException {
            void var1_1;
            Object[] objectArray;
            if (v == null) {
                if (required) {
                    throw new MessageTypeException("Attempted to write null");
                }
                packer.writeNil();
                return;
            }
            if (!(v instanceof Object[]) || !this.a.isAssignableFrom(v.getClass().getComponentType())) {
                throw new MessageTypeException();
            }
            objectArray = objectArray;
            int n2 = objectArray.length;
            packer.writeArrayBegin(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.b.write(packer, objectArray[i2], required);
            }
            var1_1.writeArrayEnd();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Object read(Unpacker unpacker, Object to, boolean required) throws IOException {
            void var1_1;
            if (!required && unpacker.trySkipNil()) {
                return null;
            }
            int n2 = unpacker.readArrayBegin();
            Object[] objectArray = (Object[])Array.newInstance(this.a, n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                objectArray[i2] = this.b.read(unpacker, null, required);
            }
            var1_1.readArrayEnd();
            return objectArray;
        }
    }
}

