/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.analysis.MultiArrayType;
import javassist.bytecode.analysis.MultiType;

public class Type {
    private final CtClass a;
    private final boolean b;
    private static final Map c = new IdentityHashMap();
    public static final Type DOUBLE = new Type(CtClass.doubleType);
    public static final Type BOOLEAN = new Type(CtClass.booleanType);
    public static final Type LONG = new Type(CtClass.longType);
    public static final Type CHAR = new Type(CtClass.charType);
    public static final Type BYTE = new Type(CtClass.byteType);
    public static final Type SHORT = new Type(CtClass.shortType);
    public static final Type INTEGER = new Type(CtClass.intType);
    public static final Type FLOAT = new Type(CtClass.floatType);
    public static final Type VOID = new Type(CtClass.voidType);
    public static final Type UNINIT = new Type(null);
    public static final Type RETURN_ADDRESS = new Type(null, true);
    public static final Type TOP = new Type(null, true);
    public static final Type BOGUS = new Type(null, true);
    public static final Type OBJECT = Type.a("java.lang.Object");
    public static final Type SERIALIZABLE = Type.a("java.io.Serializable");
    public static final Type CLONEABLE = Type.a("java.lang.Cloneable");
    public static final Type THROWABLE = Type.a("java.lang.Throwable");

    public static Type get(CtClass clazz) {
        CtClass ctClass;
        Type type = (Type)c.get(clazz);
        if (type != null) {
            return type;
        }
        return new Type(ctClass);
    }

    private static Type a(String string) {
        try {
            return new Type(ClassPool.getDefault().get(string));
        }
        catch (NotFoundException notFoundException) {
            throw new RuntimeException(notFoundException);
        }
    }

    /*
     * WARNING - void declaration
     */
    Type(CtClass clazz) {
        this((CtClass)var1_1, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Type(CtClass clazz, boolean special) {
        void var2_2;
        void var1_1;
        this.a = var1_1;
        this.b = var2_2;
    }

    boolean a() {
        return false;
    }

    public int getSize() {
        if (this.a == CtClass.doubleType || this.a == CtClass.longType || this == TOP) {
            return 2;
        }
        return 1;
    }

    public CtClass getCtClass() {
        return this.a;
    }

    public boolean isReference() {
        return !this.b && (this.a == null || !this.a.isPrimitive());
    }

    public boolean isSpecial() {
        return this.b;
    }

    public boolean isArray() {
        return this.a != null && this.a.isArray();
    }

    public int getDimensions() {
        if (!this.isArray()) {
            return 0;
        }
        String string = this.a.getName();
        int n2 = string.length() - 1;
        int n3 = 0;
        while (string.charAt(n2) == ']') {
            n2 -= 2;
            ++n3;
        }
        return n3;
    }

    public Type getComponent() {
        CtClass ctClass;
        if (this.a == null || !this.a.isArray()) {
            return null;
        }
        try {
            ctClass = this.a.getComponentType();
        }
        catch (NotFoundException notFoundException) {
            throw new RuntimeException(notFoundException);
        }
        Type type = (Type)c.get(ctClass);
        if (type != null) {
            return type;
        }
        return new Type(ctClass);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isAssignableFrom(Type type) {
        if (this == type) {
            return true;
        }
        if (type == UNINIT && this.isReference() || this == UNINIT && type.isReference()) {
            return true;
        }
        if (type instanceof MultiType) {
            return ((MultiType)type).isAssignableTo(this);
        }
        if (type instanceof MultiArrayType) {
            return ((MultiArrayType)type).isAssignableTo(this);
        }
        if (this.a == null || this.a.isPrimitive()) {
            return false;
        }
        try {
            void var1_1;
            return var1_1.a.subtypeOf(this.a);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Type merge(Type type) {
        if (type == this) {
            return this;
        }
        if (type == null) {
            return this;
        }
        if (type == UNINIT) {
            return this;
        }
        if (this == UNINIT) {
            return type;
        }
        if (!type.isReference() || !this.isReference()) {
            return BOGUS;
        }
        if (type instanceof MultiType) {
            return type.merge(this);
        }
        if (type.isArray() && this.isArray()) {
            int n2;
            Type type2 = type;
            type = this;
            Type type3 = Type.a(type2);
            Type type4 = Type.a(type);
            int n3 = type2.getDimensions();
            if (n3 == (n2 = type.getDimensions())) {
                if ((type4 = type4.merge(type3)) == BOGUS) {
                    return OBJECT;
                }
                return type.a(type4, n2);
            }
            if (n3 < n2) {
                type4 = type3;
                n2 = n3;
            }
            if (Type.a(Type.CLONEABLE.a, type4.a) || Type.a(Type.SERIALIZABLE.a, type4.a)) {
                return type.a(type4, n2);
            }
            return type.a(OBJECT, n2);
        }
        try {
            CtClass ctClass;
            Object object;
            Type type5;
            void var2_4 = type5;
            type5 = this;
            Object object2 = var2_4.a;
            Object object3 = object = type5.a;
            Object object4 = object2;
            object = object3;
            while (!Type.a((CtClass)object3, (CtClass)object2) || ((CtClass)object3).getSuperclass() == null) {
                CtClass ctClass2 = ((CtClass)object3).getSuperclass();
                CtClass ctClass3 = ((CtClass)object2).getSuperclass();
                if (ctClass3 == null) {
                    object2 = object4;
                } else if (ctClass2 == null) {
                    object3 = object;
                    object = object4;
                    object4 = object3;
                    object3 = object2;
                    object2 = object4;
                } else {
                    object3 = ctClass2;
                    object2 = ctClass3;
                    continue;
                }
                while ((object3 = ((CtClass)object3).getSuperclass()) != null) {
                    object = ((CtClass)object).getSuperclass();
                }
                object3 = object;
                while (!Type.a((CtClass)object3, (CtClass)object2)) {
                    object3 = ((CtClass)object3).getSuperclass();
                    object2 = ((CtClass)object2).getSuperclass();
                }
                break block2;
            }
            if ((ctClass = object3).getSuperclass() == null) {
                object2 = var2_4;
                object = type5;
                object3 = ((Type)object).a(((Type)object2).a, null);
                Object object5 = object;
                object2 = ((Type)object5).a(((Type)object5).a, null);
                if ((object3 = Type.a((Map)object3, (Map)object2)).size() == 1) {
                    return new Type((CtClass)object3.values().iterator().next());
                }
                if (object3.size() > 1) {
                    return new MultiType((Map)object3);
                }
                return new Type(ctClass);
            }
            object3 = ctClass;
            object2 = var2_4;
            object = type5;
            object2 = ((Type)object).b(((Type)object2).a, null);
            Object object6 = object;
            object4 = ((Type)object6).b(((Type)object6).a, null);
            object = ((Type)object).a((CtClass)object3, null);
            for (CtClass ctClass3 : object.keySet()) {
                object2.remove(ctClass3);
                object4.remove(ctClass3);
            }
            object3 = Type.a((Map)object2, (Map)object4);
            if (object3.size() > 0) {
                return new MultiType((Map)object3, new Type(ctClass));
            }
            return new Type(ctClass);
        }
        catch (NotFoundException notFoundException) {
            throw new RuntimeException(notFoundException);
        }
    }

    static Type a(Type type) {
        while (type.isArray()) {
            type = type.getComponent();
        }
        return type;
    }

    private Type a(Type object, int n2) {
        if (object instanceof MultiType) {
            return new MultiArrayType((MultiType)object, n2);
        }
        String string = Type.a(((Type)object).a.getName(), n2);
        try {
            object = ((Type)object).a.getClassPool();
            object = Type.get(((ClassPool)(object != null ? object : ClassPool.getDefault())).get(string));
        }
        catch (NotFoundException notFoundException) {
            throw new RuntimeException(notFoundException);
        }
        return object;
    }

    static String a(String string, int n2) {
        int n3 = string.length();
        n2 = n3 + (n2 << 1);
        char[] cArray = new char[n2];
        string.getChars(0, n3, cArray, 0);
        while (n3 < n2) {
            cArray[n3++] = 91;
            cArray[n3++] = 93;
        }
        string = new String(cArray);
        return string;
    }

    static Map a(Map ctClassArray2, Map map) {
        Iterator<Object> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            if (ctClassArray2.containsKey(iterator.next())) continue;
            iterator.remove();
        }
        for (CtClass[] ctClassArray2 : new ArrayList(map.values())) {
            try {
                ctClassArray2 = ctClassArray2.getInterfaces();
            }
            catch (NotFoundException notFoundException) {
                throw new RuntimeException(notFoundException);
            }
            for (int i2 = 0; i2 < ctClassArray2.length; ++i2) {
                map.remove(ctClassArray2[i2].getName());
            }
        }
        return map;
    }

    final Map a(CtClass ctClass, Map hashMap) {
        if (hashMap == null) {
            hashMap = new HashMap<String, CtClass>();
        }
        if (ctClass.isInterface()) {
            hashMap.put(ctClass.getName(), ctClass);
        }
        do {
            try {
                CtClass[] ctClassArray = ctClass.getInterfaces();
                for (int i2 = 0; i2 < ctClassArray.length; ++i2) {
                    CtClass ctClass2 = ctClassArray[i2];
                    hashMap.put(ctClass2.getName(), ctClass2);
                    this.a(ctClass2, hashMap);
                }
                ctClass = ctClass.getSuperclass();
            }
            catch (NotFoundException notFoundException) {
                throw new RuntimeException(notFoundException);
            }
        } while (ctClass != null);
        return hashMap;
    }

    private Map b(CtClass ctClassArray, Map hashMap) {
        if (hashMap == null) {
            hashMap = new HashMap<String, Object>();
        }
        if (ctClassArray.isInterface()) {
            hashMap.put(ctClassArray.getName(), ctClassArray);
        }
        try {
            ctClassArray = ctClassArray.getInterfaces();
        }
        catch (NotFoundException notFoundException) {
            throw new RuntimeException(notFoundException);
        }
        for (int i2 = 0; i2 < ctClassArray.length; ++i2) {
            CtClass ctClass = ctClassArray[i2];
            hashMap.put(ctClass.getName(), ctClass);
            this.b(ctClass, hashMap);
        }
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o2) {
        void var1_1;
        if (!(o2 instanceof Type)) {
            return false;
        }
        return o2.getClass() == this.getClass() && Type.a(this.a, ((Type)var1_1).a);
    }

    static boolean a(CtClass ctClass, CtClass ctClass2) {
        return ctClass == ctClass2 || ctClass != null && ctClass2 != null && ctClass.getName().equals(ctClass2.getName());
    }

    public String toString() {
        if (this == BOGUS) {
            return "BOGUS";
        }
        if (this == UNINIT) {
            return "UNINIT";
        }
        if (this == RETURN_ADDRESS) {
            return "RETURN ADDRESS";
        }
        if (this == TOP) {
            return "TOP";
        }
        if (this.a == null) {
            return "null";
        }
        return this.a.getName();
    }

    static {
        c.put(CtClass.doubleType, DOUBLE);
        c.put(CtClass.longType, LONG);
        c.put(CtClass.charType, CHAR);
        c.put(CtClass.shortType, SHORT);
        c.put(CtClass.intType, INTEGER);
        c.put(CtClass.floatType, FLOAT);
        c.put(CtClass.byteType, BYTE);
        c.put(CtClass.booleanType, BOOLEAN);
        c.put(CtClass.voidType, VOID);
    }
}

