/*
 * Decompiled with CFR 0.152.
 */
package dbmaker.sql.type4.xa;

import dbmaker.sql.type4.Connection;
import dbmaker.sql.type4.Driver;
import dbmaker.sql.type4.JdbcCommon;
import dbmaker.sql.type4.LogWriterHandler;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataSource
extends JdbcCommon
implements javax.sql.DataSource {
    protected static Driver myDriver;
    protected Connection conn = null;
    protected boolean isClose;
    protected SQLWarning lastWarning;
    protected String dbName = null;
    protected String dsName = new String("dbmaker.sql.DataSource");
    protected int portNumber;
    protected String serverName;
    protected String descp;
    protected String uid = null;
    protected String passwd = null;
    private PrintWriter a = null;

    public DataSource() throws SQLException {
        if (myDriver == null) {
            myDriver = new Driver();
        }
        this.isClose = false;
    }

    public void setDatabaseName(String string) throws SQLException {
        logger.finer("setDatabaseName (" + string + ")");
        DataSource dataSource = this;
        dataSource.checkClosed(dataSource.isClose);
        this.dbName = string;
    }

    public String getDatabaseName() throws SQLException {
        logger.finer("getDatabaseName ()");
        DataSource dataSource = this;
        dataSource.checkClosed(dataSource.isClose);
        return this.dbName;
    }

    public void setDataSourceName(String string) throws SQLException {
        logger.finer("setDataSourceName (" + string + ")");
        DataSource dataSource = this;
        dataSource.checkClosed(dataSource.isClose);
        this.dsName = string;
    }

    public String getDataSourceName() throws SQLException {
        logger.finer("getDataSourceName ()");
        DataSource dataSource = this;
        dataSource.checkClosed(dataSource.isClose);
        return this.dsName;
    }

    public void setDescription(String string) throws SQLException {
        logger.finer("setDescription (" + string + ")");
        DataSource dataSource = this;
        dataSource.checkClosed(dataSource.isClose);
        this.descp = string;
    }

    public String getDescription() throws SQLException {
        logger.finer("getDescription ()");
        DataSource dataSource = this;
        dataSource.checkClosed(dataSource.isClose);
        return this.descp;
    }

    public void setUser(String string) throws SQLException {
        logger.finer("setUser (" + string + ")");
        DataSource dataSource = this;
        dataSource.checkClosed(dataSource.isClose);
        this.uid = string;
    }

    public String getUser() throws SQLException {
        logger.finer("getUser ()");
        DataSource dataSource = this;
        dataSource.checkClosed(dataSource.isClose);
        return this.uid;
    }

    public void setPassword(String string) throws SQLException {
        logger.finer("setPassword (" + string + ")");
        DataSource dataSource = this;
        dataSource.checkClosed(dataSource.isClose);
        this.passwd = string;
    }

    public void setPortNumber(int n2) throws SQLException {
        logger.finer("setPortNumber (" + n2 + ")");
        DataSource dataSource = this;
        dataSource.checkClosed(dataSource.isClose);
        this.portNumber = n2;
    }

    public int getPortNumber() throws SQLException {
        logger.finer("getPortNumber");
        DataSource dataSource = this;
        dataSource.checkClosed(dataSource.isClose);
        return this.portNumber;
    }

    public void setServerName(String string) throws SQLException {
        logger.finer("setServerName (" + string + ")");
        DataSource dataSource = this;
        dataSource.checkClosed(dataSource.isClose);
        this.serverName = string;
    }

    public String getServerName() throws SQLException {
        logger.finer("getServerName");
        DataSource dataSource = this;
        dataSource.checkClosed(dataSource.isClose);
        return this.serverName;
    }

    public void setNetworkProtocol(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException(Driver.DM_ERROR_PREFIX + this.getResourceBundle().getString("JERR_UNSUPPORT_OPERATION") + "DataSource.setNetworkProtocol(String np)");
    }

    public String getNetworkProtocol() throws SQLException {
        throw new SQLFeatureNotSupportedException(Driver.DM_ERROR_PREFIX + this.getResourceBundle().getString("JERR_UNSUPPORT_OPERATION") + "DataSource.getNetworkProtocol()");
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        logger.finer("getConnection()");
        DataSource dataSource = this;
        return dataSource.getConnection(dataSource.uid, this.passwd);
    }

    @Override
    public java.sql.Connection getConnection(String object, String string) throws SQLException {
        logger.finer("setConnection(String username, String password)");
        DataSource dataSource = this;
        dataSource.checkClosed(dataSource.isClose);
        Properties properties = new Properties();
        properties.setProperty("user", (String)object);
        properties.setProperty("password", string);
        if (this.serverName == null || this.serverName.length() == 0 || this.portNumber == 0) {
            throw new SQLException("Valid server name and port number are required.");
        }
        object = "jdbc:dbmaker:type4://" + this.serverName + ":" + this.portNumber + "/" + this.dbName;
        object = (Connection)myDriver.connect((String)object, properties);
        return object;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.a;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.a = printWriter;
        if (this.a != null) {
            logger.addHandler(new LogWriterHandler(this.a));
            logger.setLevel(Level.ALL);
        }
    }

    @Override
    public void setLoginTimeout(int n2) throws SQLException {
        logger.finer("setLoginTimeout (" + n2 + ")");
        DataSource dataSource = this;
        dataSource.checkClosed(dataSource.isClose);
        try {
            if (this.conn != null) {
                Connection connection = this.conn;
                synchronized (connection) {
                    this.conn.setOptionInt(103, n2);
                }
            } else {
                throw new SQLException(Driver.DM_ERROR_PREFIX + this.getResourceBundle().getString("JERR_CONN_NOT_OPEN") + " setLoginTimeout(int seconds)");
            }
            return;
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
            return;
        }
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        int n2;
        block6: {
            n2 = 0;
            logger.finer("getLoginTimeout ()");
            DataSource dataSource = this;
            dataSource.checkClosed(dataSource.isClose);
            try {
                if (this.conn != null) {
                    Connection connection = this.conn;
                    synchronized (connection) {
                        n2 = this.conn.getOptionInt(103);
                        break block6;
                    }
                }
                throw new SQLException(Driver.DM_ERROR_PREFIX + this.getResourceBundle().getString("JERR_CONN_NOT_OPEN") + " getLoginTimeout()");
            }
            catch (SQLWarning sQLWarning) {
                this.lastWarning = sQLWarning;
            }
        }
        return n2;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }
}

