/*
 * Decompiled with CFR 0.152.
 */
package dbmaker.sql;

import dbmaker.sql.ODBCDef;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import java.util.TimeZone;

public abstract class JdbcOdbc {
    protected int gbDbCase = 1;
    protected boolean needTrace = false;
    private PrintStream traceStream = null;
    private PrintWriter traceWriter = DriverManager.getLogWriter();

    protected abstract ResourceBundle getResourceBundle();

    public JdbcOdbc() {
        this.needTrace = this.traceWriter != null || (this.traceStream = DriverManager.getLogStream()) != null;
    }

    protected static void trace2(String string) {
        PrintWriter printWriter = DriverManager.getLogWriter();
        if (printWriter != null) {
            printWriter.write("[" + ODBCDef.getProductName() + "]" + string);
        } else {
            PrintStream printStream = DriverManager.getLogStream();
            if (printStream != null) {
                printStream.println("[" + ODBCDef.getProductName() + "]" + string);
            }
        }
    }

    protected void trace(String string) {
        if (this.traceWriter != null) {
            this.traceWriter.write("[" + ODBCDef.getProductName() + "]" + string + "\n");
            this.traceWriter.flush();
        } else if (this.traceStream != null) {
            this.traceStream.println("[" + ODBCDef.getProductName() + "]" + string);
        }
    }

    protected static byte[] convert(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes(ODBCDef.DM_UNICODE);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("encoding unsupported");
        }
    }

    protected void checkClosed(boolean bl) throws SQLException {
        if (bl) {
            this.JDBCError("JERR_OBJECT_IS_CLOSED", null);
        }
    }

    public Object modifyDateTimeDiff(Object object, int n, Calendar calendar) throws SQLException {
        GregorianCalendar gregorianCalendar;
        Cloneable cloneable;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        long l = 0L;
        if (n == 91) {
            cloneable = (java.sql.Date)object;
            l = ((Date)cloneable).getTime();
            gregorianCalendar = new GregorianCalendar(((Date)cloneable).getYear(), ((Date)cloneable).getMonth(), ((Date)cloneable).getDate());
        } else if (n == 92) {
            cloneable = (Time)object;
            l = ((Date)cloneable).getTime();
            gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.set(10, ((Date)cloneable).getHours());
            gregorianCalendar.set(12, ((Date)cloneable).getMinutes());
            gregorianCalendar.set(13, ((Date)cloneable).getSeconds());
        } else {
            cloneable = (Timestamp)object;
            l = ((Date)cloneable).getTime();
            gregorianCalendar = new GregorianCalendar(((Date)cloneable).getYear(), ((Date)cloneable).getMonth(), ((Date)cloneable).getDate(), ((Date)cloneable).getHours(), ((Date)cloneable).getMinutes(), ((Date)cloneable).getSeconds());
        }
        cloneable = calendar.getTimeZone();
        bl = ((TimeZone)cloneable).useDaylightTime();
        n2 = bl ? ((TimeZone)cloneable).getOffset(calendar.get(0), calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), calendar.get(14)) : ((TimeZone)cloneable).getRawOffset();
        TimeZone timeZone = ((Calendar)gregorianCalendar).getTimeZone();
        bl = timeZone.useDaylightTime();
        n3 = bl ? timeZone.getOffset(gregorianCalendar.get(0), gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5), gregorianCalendar.get(7), gregorianCalendar.get(14)) : timeZone.getRawOffset();
        Date date = n == 91 ? new java.sql.Date(l) : (n == 92 ? new Time(l) : new Timestamp(l -= (long)(n3 -= n2)));
        return date;
    }

    protected SQLException JDBCError(String string, String string2, SQLException sQLException) {
        this.trace("JdbcOdbc.JDBCError(int, String, SQLException) (" + string + ")");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (sQLException != null) {
            string5 = sQLException.getSQLState();
            string3 = " (" + sQLException.getErrorCode() + ", " + sQLException.getMessage() + ")";
        }
        string4 = this.getResourceBundle().getString(string);
        string4 = "[" + ODBCDef.getProductName() + "] " + string4;
        if (string2 != null) {
            string4 = string4 + ", " + string2;
        }
        if (string3 != null) {
            string4 = string4 + ", " + string3;
        }
        return new SQLException(string4, string5);
    }

    protected void JDBCError(String string, String string2) throws SQLException {
        this.trace("JdbcOdbc.JDBCError(int, String) (" + string + ")");
        String string3 = this.getResourceBundle().getString(string);
        string3 = "[" + ODBCDef.getProductName() + "] " + string3;
        if (string2 != null) {
            string3 = string3 + string2;
        }
        throw new SQLException(string3, (String)null);
    }

    public int odbc2JavaType(int n) throws SQLException {
        int n2 = n;
        switch (n) {
            case 1: {
                n2 = 1;
                break;
            }
            case -8: {
                n2 = -15;
                break;
            }
            case 12: {
                n2 = 12;
                break;
            }
            case -9: {
                n2 = -9;
                break;
            }
            case -1: {
                n2 = -1;
                break;
            }
            case -10: {
                n2 = -16;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 5;
                break;
            }
            case 4: {
                n2 = 4;
                break;
            }
            case 7: {
                n2 = 7;
                break;
            }
            case 6: {
                n2 = 6;
                break;
            }
            case 8: {
                n2 = 8;
                break;
            }
            case -7: {
                n2 = -7;
                break;
            }
            case -6: {
                n2 = -6;
                break;
            }
            case -5: {
                n2 = -5;
                break;
            }
            case -2: {
                n2 = -2;
                break;
            }
            case -3: {
                n2 = -3;
                break;
            }
            case -4: {
                n2 = -4;
                break;
            }
            case 91: {
                n2 = 91;
                break;
            }
            case 92: {
                n2 = 92;
                break;
            }
            case 93: {
                n2 = 93;
                break;
            }
            case 9: {
                n2 = 91;
                break;
            }
            case 10: {
                n2 = 92;
                break;
            }
            case 11: {
                n2 = 93;
                break;
            }
            case 0: {
                n2 = 1111;
                break;
            }
        }
        return n2;
    }

    public int java2OdbcType(int n) throws SQLException {
        int n2 = n;
        switch (n) {
            case 1: {
                n2 = 1;
                break;
            }
            case -15: {
                n2 = -8;
                break;
            }
            case 12: {
                n2 = 12;
                break;
            }
            case -9: {
                n2 = -9;
                break;
            }
            case -1: {
                n2 = -1;
                break;
            }
            case -16: {
                n2 = -10;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 5;
                break;
            }
            case 4: {
                n2 = 4;
                break;
            }
            case 7: {
                n2 = 7;
                break;
            }
            case 6: {
                n2 = 6;
                break;
            }
            case 8: {
                n2 = 8;
                break;
            }
            case -7: {
                n2 = -7;
                break;
            }
            case -6: {
                n2 = -6;
                break;
            }
            case -5: {
                n2 = -5;
                break;
            }
            case -2: {
                n2 = -2;
                break;
            }
            case -3: {
                n2 = -3;
                break;
            }
            case -4: {
                n2 = -4;
                break;
            }
            case 91: {
                n2 = 91;
                break;
            }
            case 92: {
                n2 = 92;
                break;
            }
            case 93: {
                n2 = 93;
                break;
            }
            case 1111: {
                n2 = 0;
            }
        }
        return n2;
    }

    protected static int jdbcTypeToCType(int n) {
        switch (n) {
            case 4: 
            case 5: {
                return 4;
            }
            case -5: {
                return -25;
            }
            case 6: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 92: {
                return 92;
            }
            case 93: {
                return 93;
            }
            case 91: {
                return 91;
            }
            case -15: 
            case -9: 
            case 1: 
            case 3: 
            case 12: {
                return -8;
            }
            case -2: {
                return -2;
            }
        }
        return -8;
    }

    public String mapClass(int n) throws SQLException {
        this.trace("ResultSetMetaData.mapClass" + n + ")");
        switch (n) {
            case 2003: {
                return new String("java.lang.Array");
            }
            case -5: {
                return new String("java.lang.Long");
            }
            case -2: {
                return new String("java.lang.String");
            }
            case -7: {
                return new String("java.lang.Boolean");
            }
            case 2004: {
                return new String("java.lang.StringBuffer");
            }
            case -15: 
            case 1: {
                return new String("java.lang.String");
            }
            case 2005: {
                return new String("java.lang.StringBuffer");
            }
            case 91: {
                return new String("java.sql.Date");
            }
            case 3: {
                return new String("java.lang.String");
            }
            case 8: {
                return new String("java.lang.Double");
            }
            case 6: {
                return new String("java.lang.Float");
            }
            case 4: {
                return new String("java.lang.Integer");
            }
            case -4: {
                return new String("java.lang.StringBuffer");
            }
            case -16: 
            case -1: {
                return new String("java.lang.StringBuffer");
            }
            case 2: {
                return new String("java.lang.String");
            }
            case 7: {
                return new String("java.lang.Float");
            }
            case 5: {
                return new String("java.lang.Integer");
            }
            case 92: {
                return new String("java.sql.Time");
            }
            case 93: {
                return new String("java.sql.Timestamp");
            }
            case -6: {
                return new String("java.lang.StringBuffer");
            }
            case -3: {
                return new String("java.lang.String");
            }
            case -9: 
            case 12: {
                return new String("java.lang.String");
            }
            case 0: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2006: {
                return new String("java.lang.Object");
            }
        }
        return null;
    }

    static {
        String string = null;
        String string2 = System.getProperty("java.version");
        String string3 = string2.substring(0, 3);
        string = Double.parseDouble(string3) < 1.5 ? System.getProperty("DMJDBC_TRACE") : System.getenv("DMJDBC_TRACE");
        if (DriverManager.getLogWriter() == null && string != null) {
            try {
                DriverManager.setLogWriter(new PrintWriter(new FileOutputStream(string)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
    }
}

