################################################################################
# Copyright(c) 1998-2010 SYSCOM
# All rights reserved.
################################################################################
# 1. Sample purpose:
#    (1) Demonstrate OUTPUT PARAMETER in SQL SP.
# 2. To create the SQL Stored Procedure
#    (1) Run the script "createtable.sql" to create the schema objects which be 
#        used in this Procedure in advance. For more information, please see
#        the file "createtable.sql".
#    (2) Use DMSQL tool to create the SQL SP, SQL command like:
#        connect to "DBSAMPLE5" "SYSADM" "";
#        // for Windows:
#        create procedure from '@APP_HOME@\samples\SQLSP\outputparam.sp';
#        // for Linux:
#        create procedure from '/APP_HOME/samples/SQLSP/outputparam.sp';
#    (3) use JDBATool to create the SQL SP:
#        connect to the database.
#        create-procedure-wizard => select language SQL => import outputparam.sp 
#        => finish.
# 3. To call the SQL Stored Procedure
#    (1) use DMSQL tool
#        CALL SQLSP_OUTPUTPARAM(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);
#
# For more information, see the README file in the same directory.
################################################################################

CREATE PROCEDURE SQLSP_OUTPUTPARAM(
  OUT  HASDATA       CHAR(3),
  OUT  C0_SERIAL     INT,
  OUT  C1_I16        SMALLINT,
  OUT  C2_I32        INT,
  OUT  C3_I64        BIGINT,
  OUT  C4_REAL       REAL,
  OUT  C5_DOUBLE     DOUBLE,
  OUT  C6_DEC        DECIMAL(38,18),
  OUT  C7_BINARY     BINARY(20),
  OUT  C8_CHAR       CHAR(20),
  OUT  C9_VARCHAR    VARCHAR(20),
  OUT  C10_NCHAR     NCHAR(20),
  OUT  C11_NVARCHAR  NVARCHAR(20),
  OUT  C12_DATE      DATE,
  OUT  C13_TIME      TIME,
  OUT  C14_TIMESTAMP TIMESTAMP)
LANGUAGE SQL
BEGIN
  # Declare a cursor for retrieve data
  DECLARE cur1 CURSOR FOR SELECT * FROM SQLSP_ALLTYPE;
  DECLARE notfound SMALLINT DEFAULT 0;
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET notfound = 1;
  
  OPEN cur1;
  # Only return the first tuple of the table.
  FETCH NEXT FROM cur1 INTO 
    C0_SERIAL,  C1_I16,     C2_I32,       C3_I64,
    C4_REAL,    C5_DOUBLE,  C6_DEC,       C7_BINARY,
    C8_CHAR,    C9_VARCHAR, C10_NCHAR,    C11_NVARCHAR,
    C12_DATE,   C13_TIME,   C14_TIMESTAMP;
  CLOSE cur1;
  
  IF notfound <> 0 THEN
    SET HASDATA = 'NO';
  ELSE
    SET HASDATA = 'YES';
  END IF;
END;
