local dmdbi = require 'dmdbi'
local con = assert(dmdbi.New("DBSAMPLE5", "SYSADM", ""))

print "Now, We are connecting to DB 'dbsample5'..."
print()

local function show(query)
    local exec, err = con:execdirect(query)
    if err then
        print(err)
        return
    end
    
    -- print column names
    local col_names = assert(exec:columns())
    local col = ""
    for _, v in ipairs(col_names) do
        col = col .. v .. "\t"
    end
    print(col)

    local row = 0
    for row in assert(exec:rows()) do
        local data = ""
        
        for _, v in ipairs(row) do
            data = data .. v .. "\t"
        end
        print(data)
    end
        
end

while true do
    print "Type 'go' to enter or 'quit' to exit..."
    local command = io.read()
    if command == 'go' then
        print "Please input SQL select statement..."
        local query = io.read()
        show(query)
        print()
    elseif command == 'quit' then
        print "bye!!"
        break
    else
        print "Command Error, Please input again..."
        print()
    end
end
