/**************************************************
 * Demonstrate Case of Text Index with multi column
 **************************************************/
set workdir 'd:\release\workspace';
set printto '02out.txt';

connect to DBSAMPLE5 'SAMPLEUSER';

def table fulltext.news;

//CONTAINS: precisely match a word in one or multi-column
select id,title,pubdate from fulltext.news where contains(title,'winTER');
select id,title,pubdate from fulltext.news where contains(title,'chinese');
select id,title,pubdate from fulltext.news where contains(content,'winter');
select id,title,pubdate from fulltext.news where contains(content,'chinese');
select id,title,pubdate from fulltext.news where contains(title || content,'winter & chinese');
select id,title,pubdate from fulltext.news where contains(title || content,'winter | chinese');

//another sample
drop table fulltext.fruit;
create table fulltext.fruit(sort char(20), others char(20), num serial);
insert into fulltext.fruit values('apple orange', 'banana grape', 1);
insert into fulltext.fruit values('grape orange', 'strawberry', 2);
create text index idx_fruit_sort_others on fulltext.fruit(sort,others);

select * from fulltext.fruit;
select * from fulltext.fruit where contains(sort || others, 'apple');
select * from fulltext.fruit where contains(sort || others, 'orange & grape');

// a simple sample
drop table fulltext.mulcol;
create table fulltext.mulcol(c1 serial(1),c2 varchar(20),c3 varchar(20));
insert into fulltext.mulcol values(?,?,?);
1,'1a hh xx','11a 11hh yy';
2,'2b ii yy','22b 22ii zz';
3,'3c jj zz','33c 33jj xx';
end;
create text index idx_mulcol_c2 on fulltext.mulcol(c2);
create text index idx_mulcol_c3 on fulltext.mulcol(c3);
create text index idx_mulcol_c2_c3 on fulltext.mulcol(c2,c3);
select * from fulltext.mulcol;
select * from fulltext.mulcol where contains(c2,'xx & YY');
select * from fulltext.mulcol where contains(c3,'xx & YY');
select * from fulltext.mulcol where contains(c2 || c3,'xx & YY');
select * from fulltext.mulcol where contains(c2,'xx | YY');
select * from fulltext.mulcol where contains(c3,'xx | YY');
select * from fulltext.mulcol where contains(c2 || c3,'xx | YY');


drop table fulltext.fruit;
drop table fulltext.mulcol;

set printto off;
disconnect;
q;