/**************************************************
 * Demonstrate Case of Text Index with base
 **************************************************/
set workdir 'd:\release\workspace';
set printto '01out.txt';

connect to DBSAMPLE5 'SAMPLEUSER';

set linewidth off;
def table fulltext.news; //view table structure

// MATCH: precisely match a word or multiple sequential words in one column
select id,title,pubdate from fulltext.news where title match 'winter';
select id,title,pubdate from fulltext.news where title match 'winter game';
select id,title,pubdate from fulltext.news where title match 'winter games';
select id,title,pubdate from fulltext.news where content match 'new countryside';

// Boolean characters in a search pattern
// '&' - AND , '|'  - OR , '-'  - EXCLUDE ,  '('  - Left bracket ,  ')'  - Right bracket
select id,title,pubdate from fulltext.news where title match 'winter & (game | games)';

// CONTAIN: match a character string	
select id,title,pubdate from fulltext.news where title contain 'wiN';
select id,title,pubdate from fulltext.news where title contain 'wiNter game';
select id,title,pubdate from fulltext.news where title contain 'wiNter   game';

set printto off;
disconnect;
q;