/****************************************************************************
 *  Copyright(C) 1997 - 2007 CaseMaker Inc. All rights reserved.
 *
 *	01base.ec:
 *      This sample demostrates how to use ESQL/C to develop database 
 *	    application perform following functions.
 *       1. use sqlca, dbenvca as global variable
 *       2. connect to database
 *       3. insert (id,name,addrss) to employee table
 *       4. select
 *       5. delete
 *       6. update
 *       7. fetch all data from employee table
 *       8. disconnect db
 *
 *	Referenced Table: employee(id integer,name varchar(20),address varchar(50))
 *
 ****************************************************************************/
/* The following structure must include in program */
/* must be accessible in your whole program by either global or pass in func */
EXEC SQL include sqlca;            /* declare global */
EXEC SQL include dbenvca;          /* declare global */

/* This macro is for checking and showing error and warning message */
#define chkErr() \
        { \
        if (SQLCODE && SQLCODE != SQL_NO_DATA_FOUND) \
           { \
           if (SQLCODE == SQL_SUCCESS_WITH_INFO) \
              printf("WARN(%d):%s\n", sqlca.sqlerrd[0], sqlca.sqlerrmc); \
           else \
              { \
              printf("ERR(%d):%s\n", sqlca.sqlerrd[0], sqlca.sqlerrmc); \
              goto program_exit; \
              } \
           } \
        }

main()
{
   EXEC SQL begin declare section;
   char user[8], passwd[8];           /* connection information         */
   char dbname[18];                   /* char type is fix length string */
   int	id;
   char name[21], addr[51];
   SQLLEN  ind1 = SQL_NTS;
   EXEC SQL end declare section;

   strcpy(dbname, "DBSAMPLE5");          /* get db,user,password info */
   strcpy(user, "SYSADM");
   strcpy(passwd, "");

   /* you can also directly type EXEC SQL connect to db_name user_id passwd */
   EXEC SQL connect to :dbname :user :passwd;

   /* set autocommit mode off */
   EXEC SQL set autocommit off;

   /* delete from employee where id >= 10001 and id <= 10005
   EXEC SQL delete from sample.employee where id >= 10001 and id <= 10005;
   
   /* test EXEC SQL INSERT (id, name, address) */
   id = 10001;
   strcpy(name, "John Smith");
   strcpy(addr, "Xi'an Torch Road No.1");
   EXEC SQL insert into sample.employee values (:id, :name :ind1, :addr :ind1);
   chkErr();       /* if any error occur, print out error */

   /* test EXEC SQL INSERT (id, name, address) */
   id = 10002;
   strcpy(name, "Mary Black");
   strcpy(addr, "Beijing");
   EXEC SQL insert into sample.employee values (:id, :name :ind1, :addr :ind1);
   chkErr();       /* if any error occur, print out error */

   /* test EXEC SQL INSERT (id, name, address) */
   id = 10003;
   strcpy(name, "Jane White");
   strcpy(addr, "shanghai");
   EXEC SQL insert into sample.employee values (:id, :name :ind1, :addr :ind1);
   chkErr();       /* if any error occur, print out error */

   /* test EXEC SQL SELECT (query John Smith's address */
   strcpy(name, "John Smith");
   EXEC SQL select address from sample.employee where name = :name :ind1 into :addr;
   chkErr();       /* if any error occur, print out error */

   printf("John's address is %s\n", addr);

   /* test EXEC SQL DELETE (delete John Smith's tuple) */
   strcpy(name, "John Smith");
   EXEC SQL delete from sample.employee where name = :name :ind1;
   chkErr();       /* if any error occur, print out error */

   /* test EXEC SQL UPDATE (update Jane White's address */
   strcpy(name, "Jane White");
   strcpy(addr, "guangzhou");
   EXEC SQL update sample.employee set address = :addr :ind1 where name = :name :ind1;
   chkErr();       /* if any error occur, print out error */
   
   /* test CURSOR, fetch all tuple in info table           */
   /* test EXEC SQL DECLARE CURSOR for query all data inserted by code in sample.employee table */
   EXEC SQL declare myCur cursor for 
            select name,address from sample.employee where id >= 10001 and id <= 10005 into :name, :addr;
   chkErr();

   /* test EXEC SQL OPEN CURSOR */
   EXEC SQL open myCur;        /* open cursor */
   chkErr();

   while (1)
      {
      /* test EXEC SQL FETCH CURSOR */
      Exec SQL fetch myCur;   /* fetch cursor */
      chkErr();     /* print out error, if it's not SQL_NO_DATA_FOUND */
      if (SQLCODE)  /* If any SQLCODE occurs */
         {  /* If not warning (SQL_SUCCESS_WITH_INFO), break from loop */
         if (SQLCODE != SQL_SUCCESS_WITH_INFO)
            break;
         }
      printf("Name = %s, Address = %s\n", name, addr);
      }

   /* test EXEC SQL CLOSE CURSOR */
   EXEC SQL close myCur;
   chkErr();
   
   /* delete from sample.employee where id >= 10001 and id <= 10005 */
   EXEC SQL delete from sample.employee where id >= 10001 and id <= 10005;
   chkErr();

program_exit:
   /* if no error occurs, then commit transaction */
   if (SQLCODE == SQL_SUCCESS || SQLCODE == SQL_NO_DATA_FOUND ||
       SQLCODE == SQL_SUCCESS_WITH_INFO)
      {
      EXEC SQL commit work;
      if (SQLCODE)
         printf("ERR(%d):%s\n", sqlca.sqlerrd[0], sqlca.sqlerrmc);
      }
   else  /* if any error occurs, then rollback transaction */
      EXEC SQL rollback work;
   
   EXEC SQL disconnect;
   if (SQLCODE)
      printf("ERR(%d):%s\n", sqlca.sqlerrd[0], sqlca.sqlerrmc);  
}
